/*	$NetBSD: octeon_npireg.h,v 1.1 2015/04/29 08:32:01 hikaru Exp $	*/

/*
 * Copyright (c) 2007 Internet Initiative Japan, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * NPI Registers
 */

#ifndef _OCTEON_NPIREG_H_
#define _OCTEON_NPIREG_H_

#define	MPI_CFG					0x0001070000001000ULL

#define	NPI_RSL_INT_BLOCKS			0x00011f0000000000ULL
#define	NPI_DBG_SELECT				0x00011f0000000008ULL
#define	NPI_CTL_STATUS				0x00011f0000000010ULL
#define	NPI_INT_SUM				0x00011f0000000018ULL
#define	NPI_INT_ENB				0x00011f0000000020ULL
#define	NPI_MEM_ACCESS_SUBID3			0x00011f0000000028ULL
#define	NPI_MEM_ACCESS_SUBID4			0x00011f0000000030ULL
#define	NPI_MEM_ACCESS_SUBID5			0x00011f0000000038ULL
#define	NPI_MEM_ACCESS_SUBID6			0x00011f0000000040ULL
#define	NPI_PCI_READ_CMD			0x00011f0000000048ULL
#define	NPI_NUM_DESC_OUTPUT0			0x00011f0000000050ULL
#define	NPI_BASE_ADDR_INPUT0			0x00011f0000000070ULL
#define	NPI_SIZE_INPUT0				0x00011f0000000078ULL
#define	PCI_READ_TIMEOUT			0x00011f00000000b0ULL
#define	NPI_BASE_ADDR_OUTPUT0			0x00011f00000000b8ULL
#define	NPI_PCI_BURST_SIZE			0x00011f00000000d8ULL
#define	NPI_BUFF_SIZE_OUTPUT0			0x00011f00000000e0ULL
#define	NPI_OUTPUT_CONTROL			0x00011f0000000100ULL
#define	NPI_LOWP_IBUFF_SADDR			0x00011f0000000108ULL
#define	NPI_HIGHP_IBUFF_SADDR			0x00011f0000000110ULL
#define	NPI_LOWP_DBELL				0x00011f0000000118ULL
#define	NPI_HIGHP_DBELL				0x00011f0000000120ULL
#define	NPI_DMA_CONTROL				0x00011f0000000128ULL
#define	NPI_PCI_INT_ARB_CFG			0x00011f0000000130ULL
#define	NPI_INPUT_CONTROL			0x00011f0000000138ULL
#define	NPI_DMA_LOWP_COUNTS			0x00011f0000000140ULL
#define	NPI_DMA_HIGHP_COUNTS			0x00011f0000000148ULL
#define	NPI_DMA_LOWP_NADDR			0x00011f0000000150ULL
#define	NPI_DMA_HIGHP_NADDR			0x00011f0000000158ULL
#define	NPI_P0_PAIR_CNTS			0x00011f0000000160ULL
#define	NPI_P0_DBPAIR_ADDR			0x00011f0000000180ULL
#define	NPI_P0_INSTR_CNTS			0x00011f00000001a0ULL
#define	NPI_P0_INSTR_ADDR			0x00011f00000001c0ULL
#define	NPI_WIN_READ_TO				0x00011f00000001e0ULL
#define	DBG_DATA				0x00011f00000001e8ULL
#define	NPI_PORT_BP_CONTROL			0x00011f00000001f0ULL
#define	NPI_PORT32_INSTR_HDR			0x00011f00000001f8ULL
#define	NPI_BIST_STATUS				0x00011f00000003f8ULL

#define	NPI_MSI_RCV				0x00011f0000001190ULL

#define	NPI_RSL_INT_BLOCKS_XXX_63_31		UINT64_C(0xffffffff80000000)
#define	NPI_RSL_INT_BLOCKS_IOB			UINT64_C(0x0000000040000000)
#define	NPI_RSL_INT_BLOCKS_XXX_29_23		UINT64_C(0x000000003f800000)
#define	NPI_RSL_INT_BLOCKS_ASX0			UINT64_C(0x0000000000400000)
#define	NPI_RSL_INT_BLOCKS_XXX_21		UINT64_C(0x0000000000200000)
#define	NPI_RSL_INT_BLOCKS_PIP			UINT64_C(0x0000000000100000)
#define	NPI_RSL_INT_BLOCKS_XXX_19_18		UINT64_C(0x00000000000c0000)
#define	NPI_RSL_INT_BLOCKS_LMC			UINT64_C(0x0000000000020000)
#define	NPI_RSL_INT_BLOCKS_L2C			UINT64_C(0x0000000000010000)
#define	NPI_RSL_INT_BLOCKS_XXX_15_13		UINT64_C(0x000000000000e000)
#define	NPI_RSL_INT_BLOCKS_POW			UINT64_C(0x0000000000001000)
#define	NPI_RSL_INT_BLOCKS_TIM			UINT64_C(0x0000000000000800)
#define	NPI_RSL_INT_BLOCKS_PKO			UINT64_C(0x0000000000000400)
#define	NPI_RSL_INT_BLOCKS_IPD			UINT64_C(0x0000000000000200)
#define	NPI_RSL_INT_BLOCKS_XXX_8_6		UINT64_C(0x00000000000001c0)
#define	NPI_RSL_INT_BLOCKS_FPA			UINT64_C(0x0000000000000020)
#define	NPI_RSL_INT_BLOCKS_XXX_4		UINT64_C(0x0000000000000010)
#define	NPI_RSL_INT_BLOCKS_NPI			UINT64_C(0x0000000000000008)
#define	NPI_RSL_INT_BLOCKS_GMX1			UINT64_C(0x0000000000000004)
#define	NPI_RSL_INT_BLOCKS_GMX0			UINT64_C(0x0000000000000002)
#define	NPI_RSL_INT_BLOCKS_MIO			UINT64_C(0x0000000000000001)

#define	NPI_DBG_SELECT_XXX_63_16		UINT64_C(0xffffffffffff0000)
#define	NPI_DBG_SELECT_DBG_SEL			UINT64_C(0x000000000000ffff)

#define	NPI_CTL_STATUS_XXX_63			UINT64_C(0x8000000000000000)
#define	NPI_DBG_SELECT_DBG_SEL			UINT64_C(0x000000000000ffff)

#define	NPI_CTL_STATUS_XXX_63			UINT64_C(0x8000000000000000)
#define	NPI_CTL_STATUS_CHIP_REV			UINT64_C(0x7f80000000000000)
#define	NPI_CTL_STATUS_DIS_PNIW			UINT64_C(0x0040000000000000)
#define	NPI_CTL_STATUS_SPR5			UINT64_C(0x0020000000000000)
#define	NPI_CTL_STATUS_SPR4			UINT64_C(0x0010000000000000)
#define	NPI_CTL_STATUS_SPR8			UINT64_C(0x0008000000000000)
#define	NPI_CTL_STATUS_OUT0_ENB			UINT64_C(0x0004000000000000)
#define	NPI_CTL_STATUS_SPR3			UINT64_C(0x0002000000000000)
#define	NPI_CTL_STATUS_SPR2			UINT64_C(0x0001000000000000)
#define	NPI_CTL_STATUS_SPR7			UINT64_C(0x0000800000000000)
#define	NPI_CTL_STATUS_INS0_ENB			UINT64_C(0x0000400000000000)
#define	NPI_CTL_STATUS_SPR1			UINT64_C(0x0000200000000000)
#define	NPI_CTL_STATUS_SPR0			UINT64_C(0x0000100000000000)
#define	NPI_CTL_STATUS_SPR6			UINT64_C(0x0000080000000000)
#define	NPI_CTL_STATUS_INS0_64B			UINT64_C(0x0000040000000000)
#define	NPI_CTL_STATUS_PCI_WDIS			UINT64_C(0x0000020000000000)
#define	NPI_CTL_STATUS_WAIT_COM			UINT64_C(0x0000010000000000)
#define	NPI_CTL_STATUS_SPARES1			UINT64_C(0x000000e000000000)
#define	NPI_CTL_STATUS_MAX_WORD			UINT64_C(0x0000001f00000000)
#define	NPI_CTL_STATUS_SPARES0			UINT64_C(0x00000000fffffc00)
#define	NPI_CTL_STATUS_TIMER			UINT64_C(0x00000000000003ff)

#define	NPI_INT_SUM_XXX_63_62			UINT64_C(0xc000000000000000)
#define	NPI_INT_SUM_Q1_A_F			UINT64_C(0x2000000000000000)
#define	NPI_INT_SUM_Q1_S_E			UINT64_C(0x1000000000000000)
#define	NPI_INT_SUM_PDF_P_F			UINT64_C(0x0800000000000000)
#define	NPI_INT_SUM_PDF_P_E			UINT64_C(0x0400000000000000)
#define	NPI_INT_SUM_PCF_P_F			UINT64_C(0x0200000000000000)
#define	NPI_INT_SUM_PCF_P_E			UINT64_C(0x0100000000000000)
#define	NPI_INT_SUM_RDX_S_E			UINT64_C(0x0080000000000000)
#define	NPI_INT_SUM_RWX_S_E			UINT64_C(0x0040000000000000)
#define	NPI_INT_SUM_PNC_A_F			UINT64_C(0x0020000000000000)
#define	NPI_INT_SUM_PNC_S_F			UINT64_C(0x0010000000000000)
#define	NPI_INT_SUM_COM_A_F			UINT64_C(0x0008000000000000)
#define	NPI_INT_SUM_COM_S_E			UINT64_C(0x0004000000000000)
#define	NPI_INT_SUM_Q3_A_F			UINT64_C(0x0002000000000000)
#define	NPI_INT_SUM_Q3_S_E			UINT64_C(0x0001000000000000)
#define	NPI_INT_SUM_Q2_A_F			UINT64_C(0x0000800000000000)
#define	NPI_INT_SUM_Q2_S_E			UINT64_C(0x0000400000000000)
#define	NPI_INT_SUM_PCR_A_F			UINT64_C(0x0000200000000000)
#define	NPI_INT_SUM_PCR_S_E			UINT64_C(0x0000100000000000)
#define	NPI_INT_SUM_FCR_A_F			UINT64_C(0x0000080000000000)
#define	NPI_INT_SUM_FCR_S_E			UINT64_C(0x0000040000000000)
#define	NPI_INT_SUM_IOBDMA			UINT64_C(0x0000020000000000)
#define	NPI_INT_SUM_P_DPERR			UINT64_C(0x0000010000000000)
#define	NPI_INT_SUM_WIN_RTO			UINT64_C(0x0000008000000000)
#define	NPI_INT_SUM_SPR17			UINT64_C(0x0000004000000000)
#define	NPI_INT_SUM_SPR16			UINT64_C(0x0000002000000000)
#define	NPI_INT_SUM_SPR26			UINT64_C(0x0000001000000000)
#define	NPI_INT_SUM_IO_PPERR			UINT64_C(0x0000000800000000)
#define	NPI_INT_SUM_SPR15			UINT64_C(0x0000000400000000)
#define	NPI_INT_SUM_SPR14			UINT64_C(0x0000000200000000)
#define	NPI_INT_SUM_SPR25			UINT64_C(0x0000000100000000)
#define	NPI_INT_SUM_P0_PTOUT			UINT64_C(0x0000000080000000)
#define	NPI_INT_SUM_SPR13			UINT64_C(0x0000000040000000)
#define	NPI_INT_SUM_SPR12			UINT64_C(0x0000000020000000)
#define	NPI_INT_SUM_SPR24			UINT64_C(0x0000000010000000)
#define	NPI_INT_SUM_P0_PPERR			UINT64_C(0x0000000008000000)
#define	NPI_INT_SUM_SPR11			UINT64_C(0x0000000004000000)
#define	NPI_INT_SUM_SPR10			UINT64_C(0x0000000002000000)
#define	NPI_INT_SUM_SPR23			UINT64_C(0x0000000001000000)
#define	NPI_INT_SUM_G0_RTOUT			UINT64_C(0x0000000000800000)
#define	NPI_INT_SUM_SPR9			UINT64_C(0x0000000000400000)
#define	NPI_INT_SUM_SPR8			UINT64_C(0x0000000000200000)
#define	NPI_INT_SUM_SPR22			UINT64_C(0x0000000000100000)
#define	NPI_INT_SUM_P0_PERR			UINT64_C(0x0000000000080000)
#define	NPI_INT_SUM_SPR7			UINT64_C(0x0000000000040000)
#define	NPI_INT_SUM_SPR6			UINT64_C(0x0000000000020000)
#define	NPI_INT_SUM_SPR21			UINT64_C(0x0000000000010000)
#define	NPI_INT_SUM_P0_RTOUT			UINT64_C(0x0000000000008000)
#define	NPI_INT_SUM_SPR5			UINT64_C(0x0000000000004000)
#define	NPI_INT_SUM_SPR4			UINT64_C(0x0000000000002000)
#define	NPI_INT_SUM_SPR20			UINT64_C(0x0000000000001000)
#define	NPI_INT_SUM_IO_OVERF			UINT64_C(0x0000000000000800)
#define	NPI_INT_SUM_SPR3			UINT64_C(0x0000000000000400)
#define	NPI_INT_SUM_SPR2			UINT64_C(0x0000000000000200)
#define	NPI_INT_SUM_SPR19			UINT64_C(0x0000000000000100)
#define	NPI_INT_SUM_IO_RTOUT			UINT64_C(0x0000000000000080)
#define	NPI_INT_SUM_SPR1			UINT64_C(0x0000000000000040)
#define	NPI_INT_SUM_SPR0			UINT64_C(0x0000000000000020)
#define	NPI_INT_SUM_SPR18			UINT64_C(0x0000000000000010)
#define	NPI_INT_SUM_PO0_2SML			UINT64_C(0x0000000000000008)
#define	NPI_INT_SUM_PCI_RSL			UINT64_C(0x0000000000000004)
#define	NPI_INT_SUM_RML_TWO			UINT64_C(0x0000000000000002)
#define	NPI_INT_SUM_RML_RTO			UINT64_C(0x0000000000000001)

#define	NPI_INT_ENB_XXX_63_62			UINT64_C(0xc000000000000000)
#define	NPI_INT_ENB_Q1_A_F			UINT64_C(0x2000000000000000)
#define	NPI_INT_ENB_Q1_S_E			UINT64_C(0x1000000000000000)
#define	NPI_INT_ENB_PDF_P_F			UINT64_C(0x0800000000000000)
#define	NPI_INT_ENB_PDF_P_E			UINT64_C(0x0400000000000000)
#define	NPI_INT_ENB_PCF_P_F			UINT64_C(0x0200000000000000)
#define	NPI_INT_ENB_PCF_P_E			UINT64_C(0x0100000000000000)
#define	NPI_INT_ENB_RDX_S_E			UINT64_C(0x0080000000000000)
#define	NPI_INT_ENB_RWX_S_E			UINT64_C(0x0040000000000000)
#define	NPI_INT_ENB_PNC_A_F			UINT64_C(0x0020000000000000)
#define	NPI_INT_ENB_PNC_S_F			UINT64_C(0x0010000000000000)
#define	NPI_INT_ENB_COM_A_F			UINT64_C(0x0008000000000000)
#define	NPI_INT_ENB_COM_S_E			UINT64_C(0x0004000000000000)
#define	NPI_INT_ENB_Q3_A_F			UINT64_C(0x0002000000000000)
#define	NPI_INT_ENB_Q3_S_E			UINT64_C(0x0001000000000000)
#define	NPI_INT_ENB_Q2_A_F			UINT64_C(0x0000800000000000)
#define	NPI_INT_ENB_Q2_S_E			UINT64_C(0x0000400000000000)
#define	NPI_INT_ENB_PCR_A_F			UINT64_C(0x0000200000000000)
#define	NPI_INT_ENB_PCR_S_E			UINT64_C(0x0000100000000000)
#define	NPI_INT_ENB_FCR_A_F			UINT64_C(0x0000080000000000)
#define	NPI_INT_ENB_FCR_S_E			UINT64_C(0x0000040000000000)
#define	NPI_INT_ENB_IOBDMA			UINT64_C(0x0000020000000000)
#define	NPI_INT_ENB_P_DPERR			UINT64_C(0x0000010000000000)
#define	NPI_INT_ENB_WIN_RTO			UINT64_C(0x0000008000000000)
#define	NPI_INT_ENB_SPR17			UINT64_C(0x0000004000000000)
#define	NPI_INT_ENB_SPR16			UINT64_C(0x0000002000000000)
#define	NPI_INT_ENB_SPR26			UINT64_C(0x0000001000000000)
#define	NPI_INT_ENB_IO_PPERR			UINT64_C(0x0000000800000000)
#define	NPI_INT_ENB_SPR15			UINT64_C(0x0000000400000000)
#define	NPI_INT_ENB_SPR14			UINT64_C(0x0000000200000000)
#define	NPI_INT_ENB_SPR25			UINT64_C(0x0000000100000000)
#define	NPI_INT_ENB_P0_PTOUT			UINT64_C(0x0000000080000000)
#define	NPI_INT_ENB_SPR13			UINT64_C(0x0000000040000000)
#define	NPI_INT_ENB_SPR12			UINT64_C(0x0000000020000000)
#define	NPI_INT_ENB_SPR24			UINT64_C(0x0000000010000000)
#define	NPI_INT_ENB_P0_PPERR			UINT64_C(0x0000000008000000)
#define	NPI_INT_ENB_SPR11			UINT64_C(0x0000000004000000)
#define	NPI_INT_ENB_SPR10			UINT64_C(0x0000000002000000)
#define	NPI_INT_ENB_SPR23			UINT64_C(0x0000000001000000)
#define	NPI_INT_ENB_G0_RTOUT			UINT64_C(0x0000000000800000)
#define	NPI_INT_ENB_SPR9			UINT64_C(0x0000000000400000)
#define	NPI_INT_ENB_SPR8			UINT64_C(0x0000000000200000)
#define	NPI_INT_ENB_SPR22			UINT64_C(0x0000000000100000)
#define	NPI_INT_ENB_P0_PERR			UINT64_C(0x0000000000080000)
#define	NPI_INT_ENB_SPR7			UINT64_C(0x0000000000040000)
#define	NPI_INT_ENB_SPR6			UINT64_C(0x0000000000020000)
#define	NPI_INT_ENB_SPR21			UINT64_C(0x0000000000010000)
#define	NPI_INT_ENB_P0_RTOUT			UINT64_C(0x0000000000008000)
#define	NPI_INT_ENB_SPR5			UINT64_C(0x0000000000004000)
#define	NPI_INT_ENB_SPR4			UINT64_C(0x0000000000002000)
#define	NPI_INT_ENB_SPR20			UINT64_C(0x0000000000001000)
#define	NPI_INT_ENB_IO_OVERF			UINT64_C(0x0000000000000800)
#define	NPI_INT_ENB_SPR3			UINT64_C(0x0000000000000400)
#define	NPI_INT_ENB_SPR2			UINT64_C(0x0000000000000200)
#define	NPI_INT_ENB_SPR19			UINT64_C(0x0000000000000100)
#define	NPI_INT_ENB_IO_RTOUT			UINT64_C(0x0000000000000080)
#define	NPI_INT_ENB_SPR1			UINT64_C(0x0000000000000040)
#define	NPI_INT_ENB_SPR0			UINT64_C(0x0000000000000020)
#define	NPI_INT_ENB_SPR18			UINT64_C(0x0000000000000010)
#define	NPI_INT_ENB_PO0_2SML			UINT64_C(0x0000000000000008)
#define	NPI_INT_ENB_PCI_RSL			UINT64_C(0x0000000000000004)
#define	NPI_INT_ENB_RML_TWO			UINT64_C(0x0000000000000002)
#define	NPI_INT_ENB_RML_RTO			UINT64_C(0x0000000000000001)

#define	NPI_MEM_ACCESS_SUBIDX_XXX_63_38		UINT64_C(0xffffffc000000000)
#define	NPI_MEM_ACCESS_SUBIDX_SHORT		UINT64_C(0x0000002000000000)
#define	NPI_MEM_ACCESS_SUBIDX_NMERGE		UINT64_C(0x0000001000000000)
#define	NPI_MEM_ACCESS_SUBIDX_ESR		UINT64_C(0x0000000c00000000)
#define	NPI_MEM_ACCESS_SUBIDX_ESW		UINT64_C(0x0000000300000000)
#define	NPI_MEM_ACCESS_SUBIDX_NSR		UINT64_C(0x0000000080000000)
#define	NPI_MEM_ACCESS_SUBIDX_NSW		UINT64_C(0x0000000040000000)
#define	NPI_MEM_ACCESS_SUBIDX_ROR		UINT64_C(0x0000000020000000)
#define	NPI_MEM_ACCESS_SUBIDX_ROW		UINT64_C(0x0000000010000000)
#define	NPI_MEM_ACCESS_SUBIDX_BA		UINT64_C(0x000000000fffffff)

#define	NPI_PCI_READ_CMD_XXX_63_11		UINT64_C(0xfffffffffffff800)
#define	NPI_PCI_READ_CMD_CMD_SIZE		UINT64_C(0x00000000000007ff)

#define	NPI_NUM_DESC_OUTPUT0_XXX_63_32		UINT64_C(0xffffffff00000000)
#define	NPI_NUM_DESC_OUTPUT0_SIZE		UINT64_C(0x00000000ffffffff)

#define	NPI_BASE_ADDR_INPUT0_BADDR		UINT64_C(0xfffffffffffffff8)
#define	NPI_BASE_ADDR_INPUT0_XXX_2_0		UINT64_C(0x0000000000000007)

#define	NPI_SIZE_INPUT0_XXX_63_32		UINT64_C(0xffffffff00000000)
#define	NPI_SIZE_INPUT0_SIZE			UINT64_C(0x00000000ffffffff)

#define	PCI_READ_TIMEOUT_XXX_63_32		UINT64_C(0xffffffff00000000)
#define	PCI_READ_TIMEOUT_ENB			UINT64_C(0x0000000080000000)
#define	PCI_READ_TIMEOUT_CNT			UINT64_C(0x000000007fffffff)

#define	NPI_BASE_ADDR_OUTPUT0_BADDR		UINT64_C(0xfffffffffffffff8)
#define	NPI_BASE_ADDR_OUTPUT0_XXX_2_0		UINT64_C(0x0000000000000007)

#define	NPI_PCI_BURST_SIZE_XXX_63_14		UINT64_C(0xffffffffffffc000)
#define	NPI_PCI_BURST_SIZE_WR_BRST		UINT64_C(0x0000000000003f80)
#define	NPI_PCI_BURST_SIZE_RD_BRST		UINT64_C(0x000000000000007f)

#define	NPI_BUFF_SIZE_OUTPUT0_XXX_63_23		UINT64_C(0xffffffffff800000)
#define	NPI_BUFF_SIZE_OUTPUT0_ISIZE		UINT64_C(0x00000000007f0000)
#define	NPI_BUFF_SIZE_OUTPUT0_BSIZE		UINT64_C(0x000000000000ffff)

#define	NPI_OUTPUT_CONTROL_XXX_63_48		UINT64_C(0xffff000000000000)
#define	NPI_OUTPUT_CONTROL_SPR5			UINT64_C(0x0000e00000000000)
#define	NPI_OUTPUT_CONTROL_P0_BMODE		UINT64_C(0x0000100000000000)
#define	NPI_OUTPUT_CONTROL_SPR4			UINT64_C(0x00000fff00000000)
#define	NPI_OUTPUT_CONTROL_O0_ES		UINT64_C(0x00000000c0000000)
#define	NPI_OUTPUT_CONTROL_O0_NS		UINT64_C(0x0000000020000000)
#define	NPI_OUTPUT_CONTROL_O0_RO		UINT64_C(0x0000000010000000)
#define	NPI_OUTPUT_CONTROL_SPR3			UINT64_C(0x000000000e000000)
#define	NPI_OUTPUT_CONTROL_O0_CSRM		UINT64_C(0x0000000001000000)
#define	NPI_OUTPUT_CONTROL_SPR2			UINT64_C(0x0000000000f00000)
#define	NPI_OUTPUT_CONTROL_SPR1			UINT64_C(0x00000000000e0000)
#define	NPI_OUTPUT_CONTROL_IPTR_O0		UINT64_C(0x0000000000010000)
#define	NPI_OUTPUT_CONTROL_SPR0			UINT64_C(0x000000000000fff0)
#define	NPI_OUTPUT_CONTROL_ESR_SL0		UINT64_C(0x000000000000000c)
#define	NPI_OUTPUT_CONTROL_NSR_SL0		UINT64_C(0x0000000000000002)
#define	NPI_OUTPUT_CONTROL_ROR_SL0		UINT64_C(0x0000000000000001)

#define	NPI_LOWP_IBUFF_SADDR_XXX_63_36		UINT64_C(0xfffffff000000000)
#define	NPI_LOWP_IBUFF_SADDR_SADDR		UINT64_C(0x0000000fffffffff)

#define	NPI_HIGHP_IBUFF_SADDR_XXX_63_36		UINT64_C(0xfffffff000000000)
#define	NPI_HIGHP_IBUFF_SADDR_SADDR		UINT64_C(0x0000000fffffffff)

#define	NPI_LOWP_DBELL_XXX_63_16		UINT64_C(0xffffffffffff0000)
#define	NPI_LOWP_DBELL_DBELL			UINT64_C(0x000000000000ffff)

#define	NPI_HIGHP_DBELL_XXX_63_16		UINT64_C(0xffffffffffff0000)
#define	NPI_HIGHP_DBELL_DBELL			UINT64_C(0x000000000000ffff)

#define	NPI_DMA_CONTROL_XXX_63_36		UINT64_C(0xfffffff000000000)
#define	NPI_DMA_CONTROL_B0_LEND			UINT64_C(0x0000000800000000)
#define	NPI_DMA_CONTROL_DWB_DENB		UINT64_C(0x0000000400000000)
#define	NPI_DMA_CONTROL_DWB_ICHK		UINT64_C(0x00000003fe000000)
#define	NPI_DMA_CONTROL_FPA_QUE			UINT64_C(0x0000000001c00000)
#define	NPI_DMA_CONTROL_O_ADD1			UINT64_C(0x0000000000200000)
#define	NPI_DMA_CONTROL_O_RO			UINT64_C(0x0000000000100000)
#define	NPI_DMA_CONTROL_O_NS			UINT64_C(0x0000000000080000)
#define	NPI_DMA_CONTROL_O_ES			UINT64_C(0x0000000000060000)
#define	NPI_DMA_CONTROL_O_MODE			UINT64_C(0x0000000000010000)
#define	NPI_DMA_CONTROL_HP_ENB			UINT64_C(0x0000000000008000)
#define	NPI_DMA_CONTROL_LP_ENB			UINT64_C(0x0000000000004000)
#define	NPI_DMA_CONTROL_CSIZE			UINT64_C(0x0000000000003fff)

#define	NPI_PCI_INT_ARB_CFG_XXX_63_5		UINT64_C(0xffffffffffffffe0)
#define	NPI_PCI_INT_ARB_CFG_EN			UINT64_C(0x0000000000000010)
#define	NPI_PCI_INT_ARB_CFG_PARK_MOD		UINT64_C(0x0000000000000008)
#define	NPI_PCI_INT_ARB_CFG_PARK_DEV		UINT64_C(0x0000000000000007)

#define	NPI_INPUT_CONTROL_XXX_63_22		UINT64_C(0xffffffffffc00000)
#define	NPI_INPUT_CONTROL_PBP_DHI		UINT64_C(0x00000000003ffe00)
#define	NPI_INPUT_CONTROL_D_NSR			UINT64_C(0x0000000000000100)
#define	NPI_INPUT_CONTROL_D_ESR			UINT64_C(0x00000000000000c0)
#define	NPI_INPUT_CONTROL_D_ROR			UINT64_C(0x0000000000000020)
#define	NPI_INPUT_CONTROL_USE_CSR		UINT64_C(0x0000000000000010)
#define	NPI_INPUT_CONTROL_NSR			UINT64_C(0x0000000000000008)
#define	NPI_INPUT_CONTROL_ESR			UINT64_C(0x0000000000000006)
#define	NPI_INPUT_CONTROL_ROR			UINT64_C(0x0000000000000001)

#define	NPI_DMA_LOWP_COUNTS_XXX_63_39		UINT64_C(0xffffff8000000000)
#define	NPI_DMA_LOWP_COUNTS_FCNT		UINT64_C(0x0000007f00000000)
#define	NPI_DMA_LOWP_COUNTS_DBELL		UINT64_C(0x00000000ffffffff)

#define	NPI_DMA_HIGHP_COUNTS_XXX_63_39		UINT64_C(0xffffff8000000000)
#define	NPI_DMA_HIGHP_COUNTS_FCNT		UINT64_C(0x0000007f00000000)
#define	NPI_DMA_HIGHP_COUNTS_DBELL		UINT64_C(0x00000000ffffffff)

#define	NPI_DMA_LOWP_NADDR_XXX_63_40		UINT64_C(0xffffff0000000000)
#define	NPI_DMA_LOWP_NADDR_STATE		UINT64_C(0x000000f000000000)
#define	NPI_DMA_LOWP_NADDR_ADDR			UINT64_C(0x0000000fffffffff)

#define	NPI_DMA_HIGHP_NADDR_XXX_63_40		UINT64_C(0xffffff0000000000)
#define	NPI_DMA_HIGHP_NADDR_STATE		UINT64_C(0x000000f000000000)
#define	NPI_DMA_HIGHP_NADDR_ADDR		UINT64_C(0x0000000fffffffff)

#define	NPI_P0_PAIR_CNTS_XXX_63_37		UINT64_C(0xffffffe000000000)
#define	NPI_P0_PAIR_CNTS_FCNT			UINT64_C(0xffffffff00000000)
#define	NPI_P0_PAIR_CNTS_AVAIL			UINT64_C(0x00000000c0000000)

#define	NPI_P0_DBPAIR_ADDR_XXX_63		UINT64_C(0x8000000000000000)
#define	NPI_P0_DBPAIR_ADDR_STATE		UINT64_C(0x6000000000000000)
#define	NPI_P0_DBPAIR_ADDR_NADDR		UINT64_C(0x1fffffffffffffff)

#define	NPI_P0_INSTR_CNTS_XXX_63_38		UINT64_C(0xffffffc000000000)
#define	NPI_P0_INSTR_CNTS_FCNT			UINT64_C(0x0000003f00000000)
#define	NPI_P0_INSTR_CNTS_AVAIL			UINT64_C(0x00000000ffffffff)

#define	NPI_P0_INSTR_ADDR_STATE			UINT64_C(0xe000000000000000)
#define	NPI_P0_INSTR_ADDR_NADDR			UINT64_C(0x1fffffffffffffff)

#define	NPI_WIN_READ_TO_XXX_63_32		UINT64_C(0xffffffff00000000)
#define	NPI_WIN_READ_TO_TIME			UINT64_C(0x00000000ffffffff)

#define	DBG_DATA_XXX_63_31			UINT64_C(0xffffffff80000000)
#define	DBG_DATA_PLL_MUL			UINT64_C(0x0000000070000000)
#define	DBG_DATA_XXX_27_23			UINT64_C(0x000000000f800000)
#define	DBG_DATA_C_MUL				UINT64_C(0x00000000007c0000)
#define	DBG_DATA_DSEL_EXT			UINT64_C(0x0000000000020000)
#define	DBG_DATA_DATA				UINT64_C(0x000000000001ffff)

#define	NPI_PORT_BP_CONTROL_XXX_63_5		UINT64_C(0xffffffffffffffe0)
#define	NPI_PORT_BP_CONTROL_BP_ON		UINT64_C(0x0000000000000010)
#define	NPI_PORT_BP_CONTROL_ENB			UINT64_C(0x000000000000000f)

#define	NPI_PORT32_INSTR_HDR_XXX_63_44		UINT64_C(0xfffff00000000000)
#define	NPI_PORT32_INSTR_HDR_PBP		UINT64_C(0x0000080000000000)
#define	NPI_PORT32_INSTR_HDR_XXX_42_38		UINT64_C(0x000007c000000000)
#define	NPI_PORT32_INSTR_HDR_RPARMODE		UINT64_C(0x0000003000000000)
#define	NPI_PORT32_INSTR_HDR_XXX_35		UINT64_C(0x0000000800000000)
#define	NPI_PORT32_INSTR_HDR_RSKP_LEN		UINT64_C(0x00000007f0000000)
#define	NPI_PORT32_INSTR_HDR_XXX_27_22		UINT64_C(0x000000000fc00000)
#define	NPI_PORT32_INSTR_HDR_USE_IHDR		UINT64_C(0x0000000000200000)
#define	NPI_PORT32_INSTR_HDR_XXX_20_16		UINT64_C(0x00000000001f0000)
#define	NPI_PORT32_INSTR_HDR_PAR_MODE		UINT64_C(0x000000000000c000)
#define	NPI_PORT32_INSTR_HDR_XXX_13		UINT64_C(0x0000000000002000)
#define	NPI_PORT32_INSTR_HDR_SKP_LEN		UINT64_C(0x0000000000001fc0)
#define	NPI_PORT32_INSTR_HDR_XXX_5_0		UINT64_C(0x000000000000003f)

#define	NPI_BIST_STATUS_XXX_63_20		UINT64_C(0xfffffffffff00000)
#define	NPI_BIST_STATUS_CSR_BS			UINT64_C(0x0000000000080000)
#define	NPI_BIST_STATUS_DIF_BS			UINT64_C(0x0000000000040000)
#define	NPI_BIST_STATUS_RDP_BS			UINT64_C(0x0000000000020000)
#define	NPI_BIST_STATUS_PCNC_BS			UINT64_C(0x0000000000010000)
#define	NPI_BIST_STATUS_PCN_BS			UINT64_C(0x0000000000008000)
#define	NPI_BIST_STATUS_RDN_BS			UINT64_C(0x0000000000004000)
#define	NPI_BIST_STATUS_PCAC_BS			UINT64_C(0x0000000000002000)
#define	NPI_BIST_STATUS_PCAD_BS			UINT64_C(0x0000000000001000)
#define	NPI_BIST_STATUS_RDNL_BS			UINT64_C(0x0000000000000800)
#define	NPI_BIST_STATUS_PGF_BS			UINT64_C(0x0000000000000400)
#define	NPI_BIST_STATUS_PIG_BS			UINT64_C(0x0000000000000200)
#define	NPI_BIST_STATUS_POF0_BS			UINT64_C(0x0000000000000100)
#define	NPI_BIST_STATUS_POF1_BS			UINT64_C(0x0000000000000080)
#define	NPI_BIST_STATUS_POF2_BS			UINT64_C(0x0000000000000040)
#define	NPI_BIST_STATUS_POF3_BS			UINT64_C(0x0000000000000020)
#define	NPI_BIST_STATUS_POS_BS			UINT64_C(0x0000000000000010)
#define	NPI_BIST_STATUS_NUS_BS			UINT64_C(0x0000000000000008)
#define	NPI_BIST_STATUS_DOB_BS			UINT64_C(0x0000000000000004)
#define	NPI_BIST_STATUS_PDF_BS			UINT64_C(0x0000000000000002)
#define	NPI_BIST_STATUS_DPI_BS			UINT64_C(0x0000000000000001)

#endif /* _OCTEON_NPIREG_H_ */
