/*	$NetBSD: command_table.h,v 1.7 2021/02/13 08:14:46 rillig Exp $	*/

/*-
 * Copyright 2009 Brett Lymn <blymn@NetBSD.org>
 * Copyright 2021 Roland Illig <rillig@NetBSD.org>
 *
 * All rights reserved.
 *
 * This code has been donated to The NetBSD Foundation by the Author.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef CTF_COMMAND_TABLE_H
#define	CTF_COMMAND_TABLE_H

#include "curses_commands.h"

static const char *restricted_commands[] = {
	"filter", "ripoffline", "use_env",
	"slk_init", "initscr", "newterm"
};

size_t nrcmds = sizeof(restricted_commands) / sizeof(char *);

/*
 * Curses commands
 */
struct command_def commands[] = {
	{"filter", cmd_filter},
	{"ripoffline", cmd_ripoffline},
	{"use_env", cmd_use_env},
	{"slk_init", cmd_slk_init},
	{"DRAIN", cmd_DRAIN},
	{"addbytes", cmd_addbytes},
	{"addch", cmd_addch},
	{"addchnstr", cmd_addchnstr},
	{"addchstr", cmd_addchstr},
	{"addnstr", cmd_addnstr},
	{"addstr", cmd_addstr},
	{"attr_get", cmd_attr_get},
	{"attr_off", cmd_attr_off},
	{"attr_on", cmd_attr_on},
	{"attr_set", cmd_attr_set},
	{"attroff", cmd_attroff},
	{"attron", cmd_attron},
	{"attrset", cmd_attrset},
	{"bkgd", cmd_bkgd},
	{"bkgdset", cmd_bkgdset},
	{"border", cmd_border},
	{"clear", cmd_clear},
	{"clrtobot", cmd_clrtobot},
	{"clrtoeol", cmd_clrtoeol},
	{"color_set", cmd_color_set},
	{"delch", cmd_delch},
	{"deleteln", cmd_deleteln},
	{"echochar", cmd_echochar},
	{"erase", cmd_erase},
	{"getch", cmd_getch},
	{"getnstr", cmd_getnstr},
	{"getstr", cmd_getstr},
	{"inch", cmd_inch},
	{"inchnstr", cmd_inchnstr},
	{"inchstr", cmd_inchstr},
	{"innstr", cmd_innstr},
	{"insch", cmd_insch},
	{"insdelln", cmd_insdelln},
	{"insertln", cmd_insertln},
	{"instr", cmd_instr},
	{"move", cmd_move},
	{"refresh", cmd_refresh},
	{"scrl", cmd_scrl},
	{"setscrreg", cmd_setscrreg},
	{"standend", cmd_standend},
	{"standout", cmd_standout},
	{"timeout", cmd_timeout},
	{"underscore", cmd_underscore},
	{"underend", cmd_underend},
	{"waddbytes", cmd_waddbytes},
	{"waddstr", cmd_waddstr},
	{"mvaddbytes", cmd_mvaddbytes},
	{"mvaddch", cmd_mvaddch},
	{"mvaddchnstr", cmd_mvaddchnstr},
	{"mvaddchstr", cmd_mvaddchstr},
	{"mvaddnstr", cmd_mvaddnstr},
	{"mvaddstr", cmd_mvaddstr},
	{"mvdelch", cmd_mvdelch},
	{"mvgetch", cmd_mvgetch},
	{"mvgetnstr", cmd_mvgetnstr},
	{"mvgetstr", cmd_mvgetstr},
	{"mvinch", cmd_mvinch},
	{"mvinchnstr", cmd_mvinchnstr},
	{"mvinchstr", cmd_mvinchstr},
	{"mvinnstr", cmd_mvinnstr},
	{"mvinsch", cmd_mvinsch},
	{"mvinstr", cmd_mvinstr},
	{"mvwaddbytes", cmd_mvwaddbytes},
	{"mvwaddch", cmd_mvwaddch},
	{"mvwaddchnstr", cmd_mvwaddchnstr},
	{"mvwaddchstr", cmd_mvwaddchstr},
	{"mvwaddnstr", cmd_mvwaddnstr},
	{"mvwaddstr", cmd_mvwaddstr},
	{"mvwdelch", cmd_mvwdelch},
	{"mvwgetch", cmd_mvwgetch},
	{"mvwgetnstr", cmd_mvwgetnstr},
	{"mvwgetstr", cmd_mvwgetstr},
	{"mvwinch", cmd_mvwinch},
	{"mvwinsch", cmd_mvwinsch},
	{"assume_default_colors", cmd_assume_default_colors},
	{"baudrate", cmd_baudrate},
	{"beep", cmd_beep},
	{"box", cmd_box},
	{"can_change_color", cmd_can_change_color},
	{"cbreak", cmd_cbreak},
	{"clearok", cmd_clearok},
	{"color_content", cmd_color_content},
	{"copywin", cmd_copywin},
	{"curs_set", cmd_curs_set},
	{"def_prog_mode", cmd_def_prog_mode},
	{"def_shell_mode", cmd_def_shell_mode},
	{"define_key", cmd_define_key},
	{"delay_output", cmd_delay_output},
	{"delscreen", cmd_delscreen},
	{"delwin", cmd_delwin},
	{"derwin", cmd_derwin},
	{"dupwin", cmd_dupwin},
	{"doupdate", cmd_doupdate},
	{"echo", cmd_echo},
	{"endwin", cmd_endwin},
	{"erasechar", cmd_erasechar},
	{"flash", cmd_flash},
	{"flushinp", cmd_flushinp},
	{"flushok", cmd_flushok},
	{"fullname", cmd_fullname},
	{"getattrs", cmd_getattrs},
	{"getbkgd", cmd_getbkgd},
	{"getcury", cmd_getcury},
	{"getcurx", cmd_getcurx},
	{"getyx", cmd_getyx},
	{"getbegy", cmd_getbegy},
	{"getbegx", cmd_getbegx},
	{"getmaxy", cmd_getmaxy},
	{"getmaxx", cmd_getmaxx},
	{"getpary", cmd_getpary},
	{"getparx", cmd_getparx},
	{"getparyx", cmd_getparyx},
	{"getmaxyx", cmd_getmaxyx},
	{"getbegyx", cmd_getbegyx},
	{"setsyx", cmd_setsyx},
	{"getsyx", cmd_getsyx},
	{"gettmode", cmd_gettmode},
	{"getwin", cmd_getwin},
	{"halfdelay", cmd_halfdelay},
	{"has_colors", cmd_has_colors},
	{"has_ic", cmd_has_ic},
	{"has_il", cmd_has_il},
	{"hline", cmd_hline},
	{"idcok", cmd_idcok},
	{"idlok", cmd_idlok},
	{"init_color", cmd_init_color},
	{"init_pair", cmd_init_pair},
	{"initscr", cmd_initscr},
	{"intrflush", cmd_intrflush},
	{"isendwin", cmd_isendwin},
	{"is_linetouched", cmd_is_linetouched},
	{"is_wintouched", cmd_is_wintouched},
	{"keyok", cmd_keyok},
	{"keypad", cmd_keypad},
	{"is_keypad", cmd_is_keypad},
	{"keyname", cmd_keyname},
	{"killchar", cmd_killchar},
	{"leaveok", cmd_leaveok},
	{"is_leaveok", cmd_is_leaveok},
	{"meta", cmd_meta},
	{"mvcur", cmd_mvcur},
	{"mvderwin", cmd_mvderwin},
	{"mvhline", cmd_mvhline},
	{"mvprintw", cmd_mvprintw},
	{"mvscanw", cmd_mvscanw},
	{"mvvline", cmd_mvvline},
	{"mvwhline", cmd_mvwhline},
	{"mvwvline", cmd_mvwvline},
	{"mvwin", cmd_mvwin},
	{"mvwinchnstr", cmd_mvwinchnstr},
	{"mvwinchstr", cmd_mvwinchstr},
	{"mvwinnstr", cmd_mvwinnstr},
	{"mvwinstr", cmd_mvwinstr},
	{"mvwprintw", cmd_mvwprintw},
	{"mvwscanw", cmd_mvwscanw},
	{"napms", cmd_napms},
	{"newpad", cmd_newpad},
	{"newterm", cmd_newterm},
	{"newwin", cmd_newwin},
	{"nl", cmd_nl},
	{"no_color_attributes", cmd_no_color_attributes},
	{"nocbreak", cmd_nocbreak},
	{"nodelay", cmd_nodelay},
	{"noecho", cmd_noecho},
	{"nonl", cmd_nonl},
	{"noqiflush", cmd_noqiflush},
	{"noraw", cmd_noraw},
	{"notimeout", cmd_notimeout},
	{"overlay", cmd_overlay},
	{"overwrite", cmd_overwrite},
	{"pair_content", cmd_pair_content},
	{"pechochar", cmd_pechochar},
	{"pnoutrefresh", cmd_pnoutrefresh},
	{"prefresh", cmd_prefresh},
	{"printw", cmd_printw},
	{"putwin", cmd_putwin},
	{"qiflush", cmd_qiflush},
	{"raw", cmd_raw},
	{"redrawwin", cmd_redrawwin},
	{"reset_prog_mode", cmd_reset_prog_mode},
	{"reset_shell_mode", cmd_reset_shell_mode},
	{"resetty", cmd_resetty},
	{"resizeterm", cmd_resizeterm},
	{"savetty", cmd_savetty},
	{"scanw", cmd_scanw},
	{"scroll", cmd_scroll},
	{"scrollok", cmd_scrollok},
	{"setterm", cmd_setterm},
	{"set_term", cmd_set_term},
	{"start_color", cmd_start_color},
	{"subpad", cmd_subpad},
	{"subwin", cmd_subwin},
	{"termattrs", cmd_termattrs},
	{"term_attrs", cmd_term_attrs},
	{"touchline", cmd_touchline},
	{"touchoverlap", cmd_touchoverlap},
	{"touchwin", cmd_touchwin},
	{"ungetch", cmd_ungetch},
	{"untouchwin", cmd_untouchwin},
	{"use_default_colors", cmd_use_default_colors},
	{"vline", cmd_vline},
	{"vw_printw", cmd_vw_printw},
	{"vw_scanw", cmd_vw_scanw},
	{"vwprintw", cmd_vwprintw},
	{"vwscanw", cmd_vwscanw},
	{"waddch", cmd_waddch},
	{"waddchnstr", cmd_waddchnstr},
	{"waddchstr", cmd_waddchstr},
	{"waddnstr", cmd_waddnstr},
	{"wattr_get", cmd_wattr_get},
	{"wattr_off", cmd_wattr_off},
	{"wattr_on", cmd_wattr_on},
	{"wattr_set", cmd_wattr_set},
	{"wattroff", cmd_wattroff},
	{"wattron", cmd_wattron},
	{"wattrset", cmd_wattrset},
	{"wbkgd", cmd_wbkgd},
	{"wbkgdset", cmd_wbkgdset},
	{"wborder", cmd_wborder},
	{"wclear", cmd_wclear},
	{"wclrtobot", cmd_wclrtobot},
	{"wclrtoeol", cmd_wclrtoeol},
	{"wcolor_set", cmd_wcolor_set},
	{"wdelch", cmd_wdelch},
	{"wdeleteln", cmd_wdeleteln},
	{"wechochar", cmd_wechochar},
	{"werase", cmd_werase},
	{"wgetch", cmd_wgetch},
	{"wgetnstr", cmd_wgetnstr},
	{"wgetstr", cmd_wgetstr},
	{"whline", cmd_whline},
	{"winch", cmd_winch},
	{"winchnstr", cmd_winchnstr},
	{"winchstr", cmd_winchstr},
	{"winnstr", cmd_winnstr},
	{"winsch", cmd_winsch},
	{"winsdelln", cmd_winsdelln},
	{"winsertln", cmd_winsertln},
	{"winstr", cmd_winstr},
	{"wmove", cmd_wmove},
	{"wnoutrefresh", cmd_wnoutrefresh},
	{"wprintw", cmd_wprintw},
	{"wredrawln", cmd_wredrawln},
	{"wrefresh", cmd_wrefresh},
	{"wresize", cmd_wresize},
	{"wscanw", cmd_wscanw},
	{"wscrl", cmd_wscrl},
	{"wsetscrreg", cmd_wsetscrreg},
	{"wstandend", cmd_wstandend},
	{"wstandout", cmd_wstandout},
	{"wtimeout", cmd_wtimeout},
	{"wtouchln", cmd_wtouchln},
	{"wunderend", cmd_wunderend},
	{"wunderscore", cmd_wunderscore},
	{"wvline", cmd_wvline},
	{"insnstr", cmd_insnstr},
	{"insstr", cmd_insstr},
	{"mvinsnstr", cmd_mvinsnstr},
	{"mvinsstr", cmd_mvinsstr},
	{"mvwinsnstr", cmd_mvwinsnstr},
	{"mvwinsstr", cmd_mvwinsstr},
	{"winsnstr", cmd_winsnstr},
	{"winsstr", cmd_winsstr},
	{"chgat", cmd_chgat},
	{"wchgat", cmd_wchgat},
	{"mvchgat", cmd_mvchgat},
	{"mvwchgat", cmd_mvwchgat},
	{"add_wch", cmd_add_wch},
	{"wadd_wch", cmd_wadd_wch},
	{"mvadd_wch", cmd_mvadd_wch},
	{"mvwadd_wch", cmd_mvwadd_wch},
	{"add_wchnstr", cmd_add_wchnstr},
	{"add_wchstr", cmd_add_wchstr},
	{"wadd_wchnstr", cmd_wadd_wchnstr},
	{"wadd_wchstr", cmd_wadd_wchstr},
	{"mvadd_wchnstr", cmd_mvadd_wchnstr},
	{"mvadd_wchstr", cmd_mvadd_wchstr},
	{"mvwadd_wchnstr", cmd_mvwadd_wchnstr},
	{"mvwadd_wchstr", cmd_mvwadd_wchstr},
	{"addnwstr", cmd_addnwstr},
	{"addwstr", cmd_addwstr},
	{"mvaddnwstr", cmd_mvaddnwstr},
	{"mvaddwstr", cmd_mvaddwstr},
	{"mvwaddnwstr", cmd_mvwaddnwstr},
	{"mvwaddwstr", cmd_mvwaddwstr},
	{"waddnwstr", cmd_waddnwstr},
	{"waddwstr", cmd_waddwstr},
	{"echo_wchar", cmd_echo_wchar},
	{"wecho_wchar", cmd_wecho_wchar},
	{"pecho_wchar", cmd_pecho_wchar},
	{"ins_wch", cmd_ins_wch},
	{"wins_wch", cmd_wins_wch},
	{"mvins_wch", cmd_mvins_wch},
	{"mvwins_wch", cmd_mvwins_wch},
	{"ins_nwstr", cmd_ins_nwstr},
	{"ins_wstr", cmd_ins_wstr},
	{"mvins_nwstr", cmd_mvins_nwstr},
	{"mvins_wstr", cmd_mvins_wstr},
	{"mvwins_nwstr", cmd_mvwins_nwstr},
	{"mvwins_wstr", cmd_mvwins_wstr},
	{"wins_nwstr", cmd_wins_nwstr},
	{"wins_wstr", cmd_wins_wstr},
	{"get_wch", cmd_get_wch},
	{"unget_wch", cmd_unget_wch},
	{"mvget_wch", cmd_mvget_wch},
	{"mvwget_wch", cmd_mvwget_wch},
	{"wget_wch", cmd_wget_wch},
	{"getn_wstr", cmd_getn_wstr},
	{"get_wstr", cmd_get_wstr},
	{"mvgetn_wstr", cmd_mvgetn_wstr},
	{"mvget_wstr", cmd_mvget_wstr},
	{"mvwgetn_wstr", cmd_mvwgetn_wstr},
	{"mvwget_wstr", cmd_mvwget_wstr},
	{"wgetn_wstr", cmd_wgetn_wstr},
	{"wget_wstr", cmd_wget_wstr},
	{"in_wch", cmd_in_wch},
	{"mvin_wch", cmd_mvin_wch},
	{"mvwin_wch", cmd_mvwin_wch},
	{"win_wch", cmd_win_wch},
	{"in_wchnstr", cmd_in_wchnstr},
	{"in_wchstr", cmd_in_wchstr},
	{"mvin_wchnstr", cmd_mvin_wchnstr},
	{"mvin_wchstr", cmd_mvin_wchstr},
	{"mvwin_wchnstr", cmd_mvwin_wchnstr},
	{"mvwin_wchstr", cmd_mvwin_wchstr},
	{"win_wchnstr", cmd_win_wchnstr},
	{"win_wchstr", cmd_win_wchstr},
	{"innwstr", cmd_innwstr},
	{"inwstr", cmd_inwstr},
	{"mvinnwstr", cmd_mvinnwstr},
	{"mvinwstr", cmd_mvinwstr},
	{"mvwinnwstr", cmd_mvwinnwstr},
	{"mvwinwstr", cmd_mvwinwstr},
	{"winnwstr", cmd_winnwstr},
	{"winwstr", cmd_winwstr},
	{"setcchar", cmd_setcchar},
	{"getcchar", cmd_getcchar},
	{"key_name", cmd_key_name},
	{"border_set", cmd_border_set},
	{"wborder_set", cmd_wborder_set},
	{"box_set", cmd_box_set},
	{"erasewchar", cmd_erasewchar},
	{"killwchar", cmd_killwchar},
	{"hline_set", cmd_hline_set},
	{"mvhline_set", cmd_mvhline_set},
	{"mvvline_set", cmd_mvvline_set},
	{"mvwhline_set", cmd_mvwhline_set},
	{"mvwvline_set", cmd_mvwvline_set},
	{"vline_set", cmd_vline_set},
	{"whline_set", cmd_whline_set},
	{"wvline_set", cmd_wvline_set},
	{"bkgrnd", cmd_bkgrnd},
	{"bkgrndset", cmd_bkgrndset},
	{"getbkgrnd", cmd_getbkgrnd},
	{"wbkgrnd", cmd_wbkgrnd},
	{"wbkgrndset", cmd_wbkgrndset},
	{"wgetbkgrnd", cmd_wgetbkgrnd},
	{"immedok", cmd_immedok},
	{"syncok", cmd_syncok},
	{"wcursyncup", cmd_wcursyncup},
	{"wsyncup", cmd_wsyncup},
	{"wsyncdown", cmd_wsyncdown},
	{"slk_attroff", cmd_slk_attroff},
	{"slk_attr_off", cmd_slk_attr_off},
	{"slk_attron", cmd_slk_attron},
	{"slk_attr_on", cmd_slk_attr_on},
	{"slk_attrset", cmd_slk_attrset},
	{"slk_attr_set", cmd_slk_attr_set},
	{"slk_clear", cmd_slk_clear},
	{"slk_color", cmd_slk_color},
	{"slk_label", cmd_slk_label},
	{"slk_noutrefresh", cmd_slk_noutrefresh},
	{"slk_refresh", cmd_slk_refresh},
	{"slk_restore", cmd_slk_restore},
	{"slk_set", cmd_slk_set},
	{"slk_touch", cmd_slk_touch},
	{"slk_wset", cmd_slk_wset},
};

size_t ncmds = sizeof(commands) / sizeof(struct command_def);

#endif
