/*	$NetBSD: gfrtcvar.h,v 1.2 2024/01/02 07:26:17 thorpej Exp $	*/

/*-
 * Copyright (c) 2023 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Nick Hudson.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _DEV_GOLDFISH_GFRTCVAR_H_
#define	_DEV_GOLDFISH_GFRTCVAR_H_

#include <dev/clock_subr.h>

struct gfrtc_softc {
	device_t sc_dev;
	bus_space_tag_t sc_bst;
	bus_space_handle_t sc_bsh;

	struct todr_chip_handle	sc_todr;
};

void	gfrtc_attach(struct gfrtc_softc *, bool);

uint64_t gfrtc_get_time(struct gfrtc_softc *);
void	gfrtc_set_alarm(struct gfrtc_softc *, uint64_t);
void	gfrtc_clear_alarm(struct gfrtc_softc *);
void	gfrtc_enable_interrupt(struct gfrtc_softc *);
void	gfrtc_disable_interrupt(struct gfrtc_softc *);
void	gfrtc_clear_interrupt(struct gfrtc_softc *);

void	gfrtc_delay(device_t, unsigned int);

#endif /* _DEV_GOLDFISH_GFRTCVAR_H_ */
