/*-
 * Copyright (c) 2005-2006 Pawel Jakub Dawidek <pjd@FreeBSD.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: stable/8/sys/dev/glxsb/glxsb.h 181467 2008-08-09 14:52:31Z philip $
 */

#ifndef _GLXSB_H_
#define _GLXSB_H_

#include <opencrypto/cryptodev.h>

#define SB_AES_BLOCK_SIZE       0x0010

struct glxsb_session {
	uint32_t	ses_key[4];		/* key */
	uint8_t		ses_iv[SB_AES_BLOCK_SIZE]; /* initialization vector */
	int		ses_klen;		/* key len */
	int		ses_used;		/* session is used */
	uint32_t	ses_id;			/* session id*/
	struct auth_hash *ses_axf;
	uint8_t		*ses_ictx;
	uint8_t		*ses_octx;
	int		ses_mlen;
	TAILQ_ENTRY(glxsb_session) ses_next;
};

int glxsb_hash_setup(struct glxsb_session *ses,
	    struct cryptoini *macini);

int glxsb_hash_process(struct glxsb_session *ses,
	    struct cryptodesc *maccrd, struct cryptop *crp);

void glxsb_hash_free(struct glxsb_session *ses);

#endif	/* !_GLXSB_H_ */
