.ig
$FreeBSD: stable/8/contrib/groff/src/devices/grotty/grotty.man 151503 2005-10-20 10:53:15Z ru $
Copyright (C) 1989-2000, 2001, 2002, 2003 Free Software Foundation, Inc.

Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.

Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.

Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
..
.
.do nr grotty_C \n[.C]
.cp 0
.
.TH GROTTY @MAN1EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
grotty \- groff driver for typewriter-like devices
.
.
.SH SYNOPSIS
.B grotty
[
.B \-bBcdfhioruUv
] [
.BI \-F dir
] [
.IR files \|.\|.\|.\&
]
.PP
It is possible to have whitespace between the
.B \-F
option and its parameter.
.
.
.SH DESCRIPTION
.B grotty
translates the output of GNU
.B troff
into a form suitable for typewriter-like devices.
Normally
.B grotty
should be invoked by using the
.B groff
command
with a
.BR \-Tascii ,
.BR \-Tlatin1 ,
.B \-Tkoi8-r
or
.B \-Tutf8
option on ASCII based systems, and with
.B \-Tcp1047
and
.B \-Tutf8
on EBCDIC based hosts.
If no files are given,
.B grotty
will read the standard input.
A filename of
.B \-
will also cause
.B grotty
to read the standard input.
Output is written to the standard output.
.LP
By default,
.B grotty
emits SGR escape sequences (from ISO 6429, also called ANSI color escapes)
to change text attributes (bold, italic, colors).
This makes it possible to have eight different \M[green]background\M[]
and \m[red]foreground\m[] colors; additionally, bold and italic
attributes can be used \f[BI]at the same time\f[] (by using the BI font).
.LP
The following colors are defined in
.BR tty.tmac :
black, white, red, green, blue, yellow, magenta, cyan.
Unknown colors are mapped to the default color (which is dependent on the
settings of the terminal; in most cases, this is black for the foreground
and white for the background).
.LP
Use the
.B \-c
switch to revert to the old behaviour, printing a bold character
.I c
with the sequence
.RI ` c
.SM BACKSPACE
.IR c '
and an italic character
.I c
by the sequence
.RB ` _
.SM BACKSPACE
.IR c '.
At the same time, color output is disabled.
The same effect can be achieved by setting either the
.B GROFF_NO_SGR
environment variable or using the `sgr' X command (see below).
.LP
For SGR support, it is necessary to use the
.B \-R
option of
.BR less (1)
to disable the interpretation of
.BR grotty 's
old output format.
Consequently, all programs which use
.B less
as the pager program have to pass this option to it.
For
.BR man (1)
in particular, either add
.B \-R
to the
.B $PAGER
environment variable, e.g.\&
.RS
.LP
.B PAGER="/usr/bin/less -R"
.br
.B export PAGER
.RE
.LP
or use the
.B \-P
option of
.B man
to set the pager executable and its options, or modify the configuration
file of
.B man
in a similar fashion.
.LP
.BR grotty 's
old output format can be displayed on a terminal
by piping through
.BR ul (1).
Pagers such as
.BR more (1)
or
.BR less (1)
are also able to display these sequences.
Use either
.B \-B
or
.B \-U
when piping into
.BR less (1);
use
.B \-b
when piping into
.BR more (1).
There is no need to filter the output through
.BR col (1)
since
.B grotty
never outputs reverse line feeds.
.LP
The font description file may contain a command
.IP
.BI internalname\  n
.LP
where
.I n
is a decimal integer.
If the 01 bit in
.I n
is set,
then the font will be treated as an italic font;
if the 02 bit is set,
then it will be treated as a bold font.
The code field in the font description field gives the
code which will be used to output the character.
This code can also be used in the
.B \[rs]N
escape sequence in
.BR troff .
.
.
.SH OPTIONS
.TP
.B \-b
Suppress the use of overstriking for bold characters.
Ignored if
.B \-c
isn't used.
.
.TP
.B \-B
Use only overstriking for bold-italic characters.
Ignored if
.B \-c
isn't used.
.
.TP
.B \-c
Use
.BR grotty 's
old output format (see above).
This also disables color output.
.
.TP
.B \-d
Ignore all
.B \[rs]D
commands.
Without this
.B grotty
will render
.B \[rs]D'l\|.\|.\|.\&'
commands that have at least one zero argument
(and so are either horizontal or vertical)
using
.BR \- ,
.BR | ,
and
.B +
characters.
.
.TP
.B \-f
Use form feeds in the output.
A form feed will be output at the end of each page that has no output
on its last line.
.
.TP
.BI \-F dir
Prepend directory
.IB dir /dev name
to the search path for font and device description files;
.I name
is the name of the device, usually
.BR ascii ,
.BR latin1 ,
.BR koi8-r ,
.BR utf8 ,
or
.BR cp1047 .
.TP
.B \-h
Use horizontal tabs in the output.
Tabs are assumed to be set every 8 columns.
.
.TP
.B \-i
Use escape sequences to set the italic text attribute instead of the
underline attribute for italic fonts (`I' and `BI').
Note that most terminals (including xterm) don't support this.
Ignored if
.B \-c
is active.
.
.TP
.B \-o
Suppress overstriking (other than for bold or underlined characters in
case the old output format has been activated with
.BR \-c ).
.
.TP
.B \-r
Use escape sequences to set the reverse text attribute instead of the
underline attribute for italic fonts (`I' and `BI').
Ignored if
.B \-c
is active.
.
.TP
.B \-u
Suppress the use of underlining for italic characters.
Ignored if
.B \-c
isn't used.
.
.TP
.B \-U
Use only underlining for bold-italic characters.
Ignored if
.B \-c
isn't used.
.
.TP
.B \-v
Print the version number.
.
.
.SH USAGE
.B grotty
understands a single X command produced using the
.B \[rs]X
escape sequence.
.TP
.BI \[rs]X'tty:\ sgr\  n '
If
.I n
is non-zero or missing, enable SGR output (this is the default), otherwise
use the old drawing scheme for bold and underline.
.
.
.SH ENVIRONMENT
.TP
.B GROFF_NO_SGR
If set, the old drawing scheme for bold and underline (using the
backspace character) is active.
Colors are disabled.
.
.
.SH FILES
.TP
.B @FONTDIR@/devascii/DESC
Device description file for
.B ascii
device.
.
.TP
.BI @FONTDIR@/devascii/ F
Font description file for font
.I F
of
.B ascii
device.
.TP
.B @FONTDIR@/devkoi8-r/DESC
Device description file for
.B koi8-r
device.
.TP
.BI @FONTDIR@/devkoi8-r/ F
Font description file for font
.I F
of
.B koi8-r
device.
.
.TP
.B @FONTDIR@/devlatin1/DESC
Device description file for
.B latin1
device.
.
.TP
.BI @FONTDIR@/devlatin1/ F
Font description file for font
.I F
of
.B latin1
device.
.
.TP
.B @FONTDIR@/devutf8/DESC
Device description file for
.B utf8
device.
.
.TP
.BI @FONTDIR@/devutf8/ F
Font description file for font
.I F
of
.B utf8
device.
.
.TP
.B @FONTDIR@/devcp1047/DESC
Device description file for
.B cp1047
device.
.
.TP
.BI @FONTDIR@/devcp1047/ F
Font description file for font
.I F
of
.B cp1047
device.
.
.TP
.B @MACRODIR@/tty.tmac
Macros for use with
.BR grotty .
.
.TP
.B @MACRODIR@/tty-char.tmac
Additional klugdey character definitions for use with
.BR grotty .
.LP
Note that on EBCDIC hosts, only files for the
.B cp1047
device will be installed.
.
.
.SH BUGS
.LP
.B grotty
is intended only for simple documents.
.LP
There is no support for fractional horizontal or vertical motions.
.LP
There is no support for
.B \[rs]D
commands
other than horizontal and vertical lines.
.LP
Characters above the first line (ie with a vertical position of\~0)
cannot be printed.
.LP
Color handling is different compared to
.BR grops (@MAN1EXT@).
.B \[rs]M
doesn't set the fill color for closed graphic objects (which
.B grotty
doesn't support anyway) but changes the background color of the character
cell, affecting all subsequent operations.
.
.
.SH "SEE ALSO"
.BR groff (@MAN1EXT@),
.BR @g@troff (@MAN1EXT@),
.BR groff_out (@MAN5EXT@),
.BR groff_font (@MAN5EXT@),
.BR groff_char (@MAN7EXT@),
.BR ul (1),
.BR more (1),
.BR man (1),
.BR less (1)
.
.cp \n[grotty_C]
.
.\" Local Variables:
.\" mode: nroff
.\" End:
