//
// MODTOOL
//
// Copyright (c) !998 David Lindauer (LADSOFT)
//
// see license.txt for licensing info
//
// ==============================================================
//
// MODLIST.CPP
//
// this handles the moderated group list combo box
//
#define STRICT
#include <windows.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "profile.h"
#include "mailfile.h"
#include "modlist.h"
#include "winconst.h"
#include "dialog.h"
#include "effects.h"
#include "help.h"
#include "mthi.h"

extern HINSTANCE hInst;
extern HWND hWndAnalyze;

HWND hWndModList;

char *nullstr="";		// a constant we will not free

static int thecount;		// items in mod list
static MODLIST *thelist;	// moderated group list when resident
static MODLIST *selected;	// the selected modlist when dialog box up
static int newitem;		// true if prompting for a new group


// ==============================================================
//
int ModListEmail(MODLIST *list)
{
	char buffer[256];
	if (list->email == nullstr || list->email[0] == 0) {
		if (list->email != nullstr)
			free(list->email);
		strcpy(buffer,list->group);
		char *rv;
		while (rv = strchr(buffer,'.'))
			*rv = '-';
		strcat(buffer,"@moderators.uu.net");
		list->email = litlate(buffer);
		if (!list->email)
			return MODLIST_NOMALLOC;
	}
	return MODLIST_OK;
}

// ==============================================================
//
// read the moderated group text file into memory
//
int ModListRead(MODLIST **rlist, int *count)
{
	char buffer[256];
	MODLIST *list = 0,*next,*newlist;
	FILE *fil;
	char *name,*mail;

	*count = 0;

	// open file
	if (!(fil = fopen(modlist,"r"))) {
		return 0;
	}
	while (!feof(fil)) {

		// read the buffer
		buffer[0] = 0;
		fgets(buffer,256,fil);
		if (ferror(fil)) {
			fclose(fil);
			return MODLIST_READERR;
		}
		if (buffer[0]) {

			// Kill the /n
			int len = strlen(buffer);
			if (buffer[len-1] == '\n')
				buffer[len-1] = 0;

			// make a new list
			newlist = (MODLIST *)malloc(sizeof(MODLIST));
			if (!newlist)  {
				fclose(fil);
				return MODLIST_NOMALLOC;
			}

			// tack in the email address
			newlist->email = strchr(buffer,':');
			if (newlist->email) {
				*newlist->email = 0;
				if (!(newlist->email = litlate(newlist->email+1))) {
					fclose(fil);
					return MODLIST_NOMALLOC;
				}
			}
			else newlist->email = nullstr;

			// tack in the group							
			if (!(newlist->group = litlate(buffer))) {
				fclose(fil);
				return MODLIST_NOMALLOC;
			}
			newlist->link = 0;
			if (ModListEmail(newlist) != MODLIST_OK)
				return MODLIST_NOMALLOC;
				
			// Tack the new element into the list
			if (!list)
				*rlist = list = next = newlist;
			else
				next = next->link = newlist;
			(*count)++;
		}
	}
	fclose(fil);
	return FILE_OK;
}
// ==============================================================
//
// destroy a moderated group list if we don't want to write it to disk
//
void ModListFree(MODLIST *list)
{

	while (list) {
		MODLIST *nlist = list->link;
		if (list->email != nullstr)
			free(list->email);
		free(list->group);
		free(list);
		list = nlist;
	}
		
}
// ==============================================================
//
// write the moderated group list back out
//
static int ModListWrite(MODLIST *list)
{
	FILE *fil = fopen(modlist,"w");
	if (!fil)
		return(MODLIST_WRITERR);


	while (list) {
		MODLIST *nlist = list->link;
		fprintf(fil,"%s:%s\n",list->group,list->email);
		if (list->email != nullstr)
			free(list->email);
		free(list->group);
		free(list);
		list = nlist;
	}
	fclose(fil);
	return FILE_OK;
}
// ==============================================================
//
// stick all information in a mod list
//
void ModListRefresh(void)
{
	HWND hwnd = GetDlgItem(hWndAnalyze,IDC_COBMODLIST);
	MODLIST *ilist;
	ilist = thelist;
	SendMessage(hwnd,CB_RESETCONTENT,0,0);
	while (ilist) {
		int i = SendMessage(hwnd,CB_ADDSTRING,0,(LPARAM)ilist->group);
		SendMessage(hwnd,CB_SETITEMDATA,i,(LPARAM)ilist);
		ilist = ilist->link;
	}
	SendMessage(hwnd,CB_SETCURSEL,0,0);
}
// ==============================================================
//
// Initialize the modlist 
//
void ModListCreate(void)
{
	if (thelist)
		return;
	switch(ModListRead(&thelist,&thecount)) {
		case MODLIST_NOMALLOC:
		case MODLIST_READERR:
			return;
	}
	ModListRefresh();
}
// ==============================================================
//
// destruction of the list box memory
//
// does not need to be there except when needed
//
void ModListDestroy(int towrite)
{
	if (!thelist)
		return;
	if (towrite)
		ModListWrite(thelist);
	else
		ModListFree(thelist);
	thelist = 0;
}
// ==============================================================
//
// mod list dialog box procedure
//
int FAR PASCAL ModListProc (HWND hWnd,UINT wmsg,WPARAM wparam,LPARAM lparam)
{
	char igroup[256];
	char iemail[256];
	MODLIST **ilist;
	switch(wmsg) {
		case WM_INITDIALOG:
			hWndModList = hWnd;
			CenterWindow(hWnd);
			if (selected) {
				NewFocus(hWnd,IDC_MTEDITEMAIL);
				/* Fill the dialog box fields */
				SetEditField(hWnd,IDC_MTEDITGROUP,selected->group);
				SetEditField(hWnd,IDC_MTEDITEMAIL,selected->email);

				/* group is read-only if this is not a new box */
				SetEditFieldRO(hWnd,IDC_MTEDITGROUP);
			}
			return TRUE;
		case WM_CLOSE:
			SendMessage(hWnd,WM_COMMAND,IDCANCEL,0);
			return TRUE;
		case WM_COMMAND:
			switch(LOWORD(wparam)) {
				case IDHELP:
					Help(hWnd,HID_ANALYZEMODERATEDIALOG);
					break;
				case IDOK:

					/* recover edit fields */
					GetEditField(hWnd,IDC_MTEDITGROUP,igroup);
					GetEditField(hWnd,IDC_MTEDITEMAIL,iemail);
					
					/* if we have a new item create the structs and fix the screen */
					if (!selected) {
						selected = (MODLIST *)malloc(sizeof(MODLIST));
						if (selected) {
							selected->group = litlate(igroup);
							thecount++;
							selected->email = litlate(iemail);
							selected->link = thelist;
							thelist = selected;
							if (ModListEmail(selected) != MODLIST_OK)
								return MODLIST_NOMALLOC;
							ModListRefresh();
						}
					}
					else {
						// else update the email part
						free(selected->email);
						selected->email = litlate(iemail);
					}
					hWndModList = 0;
					EndDialog(hWnd,1);
					
					break;
				case IDCANCEL:
					hWndModList = 0;
					EndDialog(hWnd,0);
					break;
				case IDC_MTBTDELETE:
					if (selected) {
						ilist = &thelist;
						// find the selected item
						// and unlink it
						while (*ilist) {
							if (selected == *ilist) {
								*ilist = (*ilist)->link;
								break;
							}
							ilist = &(*ilist)->link;
						}
						free(selected->group);
						free(selected->email);
						free(selected);
					}
					ModListRefresh();
					EndDialog(hWnd,1);
					break;
			}
		}
	return FALSE;
}
// ==============================================================
//
// put up a dialog box and get a new list item
//

void ModListNew(void)
{
	selected = 0;
	DialogBox(hInst,"DLG_MODERATEDGROUP",0,ModListProc);
}
// ==============================================================
//
// put up a dialog box and get a new email address for this item
//

void ModListSelect(void)
{
	char name[256];
	HWND hwnd = GetDlgItem(hWndAnalyze,IDC_COBMODLIST);
	selected = (MODLIST *)SendMessage(hwnd,CB_GETITEMDATA,SendMessage(hwnd,CB_GETCURSEL,0,0),0);
	DialogBox(hInst,"DLG_MODERATEDGROUP",0,ModListProc);
}