//
// MODTOOL
//
// Copyright (c) !998 David Lindauer (LADSOFT)
//
// see license.txt for licensing info
//
// ==============================================================
//
// EFFECTS.CPP
//
// this one handles special windowing effects
//   centering windows
//   generic message boxes
//
#define STRICT
#include <windows.h>
#include <stdio.h>

// ==============================================================
//
// center a window
//
VOID WINAPI CenterWindow(HWND hWnd)
{
    RECT rect;
    WORD wWidth,
         wHeight;
         
    // find out how big we are
    GetWindowRect(hWnd,&rect);

    // get screen size
    wWidth =GetSystemMetrics(SM_CXSCREEN);
    wHeight=GetSystemMetrics(SM_CYSCREEN);

    // move to center
    MoveWindow(hWnd,(wWidth/2)   - ((rect.right -  rect.left)/2),
                    (wHeight/2)  - ((rect.bottom - rect.top) /2),
                     rect.right  -   rect.left,
                     rect.bottom -   rect.top, 
                     FALSE);
}
// ==============================================================
//
// Message box function that allows formatted message strings
//
void ExtendedMessageBox(char *title,int flag, char *fmt,...)
{
	char string[512];
	va_list argptr;

	va_start( argptr, fmt);
  	vsprintf(string, fmt, argptr);
	va_end(argptr);
	MessageBox(0,string,title,flag);
}