//
// MODTOOL
//
// Copyright (c) !998 David Lindauer (LADSOFT)
//
// see license.txt for licensing info
//
// ==============================================================
//
// ANALYZE.CPP
//
// the analzyer
//
// this file analyzes the out box and approved box, fixing headers
// and such the way we need them.  If partial approvals are enabled
// that will be done too, BUT, don't use netscape to send them
//
#define STRICT
#include <windows.h>
#include <memory.h>
#include <string.h>
#include <stdio.h>
#include "profile.h"
#include "mailfile.h"
#include "modlist.h"
#include "archive.h"

extern char *nullstr;

char *partialapprovestring = "X-Approved-For-Group:";
char *tostring = "To:";
char *ccstring = "Cc:";
char *newsstring = "Newsgroups:";
char *approvestring = "Approved:";
char *mozillastatsstring = "X-Mozilla-Status:";
char *organizationstring = "Organization:";
char *subjectstring = "Subject:";

char *approvaltemp = "aptemp.tmp";

// the first three lines are not deleted if this is from the outbox
char *skip[] = {
	"to:",
	"approved:",
	"cc:",
	"path:",
	"received:",
	"date:",
	"message-id:",
	"nntp-posting-host:",
	"nntp-posting-date:",
	"xref:",
	"x-nntp-posting-host:",
	"x-complaints-to:",
	"x-trace:",
	"x-no-archive:",
	"x-mozilla-status:",		/* we reinsert later */
	"x-mozilla-news-host:" };

// ==============================================================
//
// stristr utility function
// sluggish, but hey!
//
char *stristr(char *str1,char *str2)
{
	char buf1[10000],buf2[10000],*q;
	int i;
	int len = strlen(str1);
	for (i=0; i <=len; i++)
		buf1[i] = tolower(str1[i]);
	len = strlen(str2);
	for (i=0; i <=len; i++)
		buf2[i] = tolower(str2[i]);
	q = strstr(buf1,buf2);
	if (q)
		q = q - buf1 + str1;
	return q;
}

// ==============================================================
//
// return TRUE if this is to our group
//
int IsToGroup(int count, char **header)
{
	int to,cc,ng;
	char dashname[256],*p;

	// find the relevant headers
	to = FindHeader(0,count,header,tostring);
	cc = FindHeader(0,count,header,ccstring);
	ng = FindHeader(0,count,header,newsstring);

	// translate the group id into dashed form
	strcpy(dashname,groupid);

	while (p = strchr(dashname,'.'))
		*p = '-';

	// if we have the clax mailbox or the dashed name in the to: line it is our group
	if (to != -1 && (stristr(header[to],approvalmailbox) || stristr(header[to],dashname)))
		return TRUE;

	// if we have the clax mailbox or the dashed name in the cc: line it is our group
	if (cc != -1 && (stristr(header[cc],approvalmailbox) || stristr(header[cc],dashname)))
		return TRUE;

	// if we have our group in the newsgroups line it is our group
	// this is just a stopgap, usually it is going to have a dashed name
	// or the approval mailbox in the TO: or CC: header
	if (ng != -1 && stristr(header[ng],groupid))
		return TRUE;

	// otherwise it isn't our group;
 	return FALSE;
}

// ==============================================================
//
// Fix the mozilla status to 801
//
// this DEPENDS on the falue of vILE_OK being 0
// we deleted the old mozilla status line earlier so this is not
// redundant.
//
static int FixMozillaStatus(int *count, char **header)
{
	return InsertHeader(count,header,"%s 0801\n",mozillastatsstring);
		
}
// ==============================================================
//
// Make sure we have a subject line
//
// this DEPENDS on the falue of FILE_OK being 0
//
static int FixSubjectLine(int *count, char **header)
{
	int rv = FindHeader(0,*count,header,subjectstring);
	if (rv == -1)	
		return InsertHeader(count,header,"%s Unknown\n",subjectstring);
	return 0;
		
}
// ==============================================================
//
// Make sure we have an organization line
//
// this DEPENDS on the falue of FILE_OK being 0
//
static int FixOrganizationLine(int *count, char **header)
{
	int rv = FindHeader(0,*count,header,organizationstring);
	if (rv == -1)	
		return InsertHeader(count,header,"%s %s\n",organizationstring,smtpsourcehost);
	return 0;
		
}
// ==============================================================
//
// make sure there is a newsgroup line and it has CLAX in it
//
static int FixNewsgroupsLine(int *count, char **header)
{
	int rv = FindHeader(0,*count,header,newsstring);

	// if we have no newsgroups line insert one
	if (rv == -1)	
		return InsertHeader(count,header,"%s %s\n",newsstring,groupid);
	else {
		if (!stristr(header[rv],groupid)) {

			// if it doesn't have our group insert it into string
			char buf[256];
			strcpy(buf,header[rv]);
			buf[strlen(buf)-1] = 0;
			strcat(buf,",");
			strcat(buf,groupid);
			strcat(buf,"\n");
			free(header[rv]);
			header[rv] = litlate(buf);
			if (!header[rv]) {
				header[rv] = nullstr;
				return FILE_NOMALLOC;
			}
		}
	}
	return 0;
}
// ==============================================================
//
// Get next moderated group from newsgroups string
//
static MODLIST *GetNextGroup(MODLIST *list, char **q)
{
	while (TRUE) {
		char buf[256],*group = buf;
		MODLIST *ilist = list;
		// skip spaces at the start
		while (**q && (*(*q) == ' ' || **q == '\t' || **q == ',' || **q == '\n')) (*q)++;

		// Exit if no more groups to check
		if (**q == 0) return 0;

		// gather the group name
		while (**q && **q != ' ' && **q != ' ' && **q != '\t' && **q != ',' && **q != '\n')
			*group++ = *(*q)++;
		*group++ = 0;

		// Now find any matching modlist string for the group
		while (ilist) {
			if (!memicmp(ilist->group,buf,strlen(buf)))
				return ilist;
			ilist = ilist->link;
		}
		// if we get here the current group wasn't in the moderated
		// groups list, go for next group
		(*q)++;
	}
}

// ==============================================================
//
// Check if the passed group name has been approved or not
//
// return TRUE if has not been approved
//
static int IsUnapproved(int *count, char **header, char *group)
{
	int rv = 0;
	// our group echoes as having been approved
	if (!memicmp(group,groupid,strlen(groupid)))
		return 0;

	// Now check all the x-mozilla-approved-for-group strings against our group
	while (TRUE) {
		/* find an x-approved line */
		rv = FindHeader(rv,*count,header,partialapprovestring);

		// exit if no partial approval found
		if (rv == -1)
			return 1;

		// if we have found it and it is for the group in
		// question exit
		if (stristr(header[rv],group))
			return 0;
		// else start search witn next line
		rv++;
	}

	// no partial approval found, return (we never get here)
	return 1;
}

// ==============================================================
//
// Decide how to approve the message
//
// returns +1 if forwarding to another newsgroup, or a file error otherwise
//
static int ApproveMessage(int *count, char **header, MODLIST *modkeys)
{
	char *q,*r;
	MODLIST *modlist;
	// find the newsgroup header
	int rv = FindHeader(0,*count,header,newsstring);
	// See if doing partial approvals
	if (partialapprove) {
	
		if (rv != -1) {
			q = header[rv]+12;
			// While we have a group on the moderated groups list
			while (modlist = GetNextGroup(modkeys,&q)) {
				// check if it is partially approved
				if (IsUnapproved(count,header,modlist->group)) {
					// another group needs approval
					// move clax to the end of the newsgroups header
		  			if (q = stristr(header[rv],groupid)) {
						r = q + strlen(groupid);
						if (*r == ',') {
							r++;
							while (*r)
								*q++ = *r++;
							*--q = 0; // gets rid of the LF
							strcat(header[rv],",");
							strcat(header[rv],groupid);
							strcat(header[rv],"\n");
						}
					}
					// now set the headers to send this message to the other group
					switch(InsertHeader(count,header,"%s <%s> %s\n",
							partialapprovestring,smtpsourcepath,groupid)) {
						case FILE_NOMALLOC:
							return FILE_NOMALLOC;
						case FILE_OK:
							if ((rv = FindHeader(0,*count,header,tostring)) == -1)
								switch (InsertHeader(count,header,"%s <%s>\n",tostring,modlist->email)) {
									case FILE_NOMALLOC:
										return FILE_NOMALLOC;
									case FILE_OK:
										return 1;
								}
							else if ((rv = FindHeader(0,*count,header,ccstring)) == -1)
								switch (InsertHeader(count,header,"%s <%s>\n",ccstring,modlist->email)) {
									case FILE_NOMALLOC:
										return FILE_NOMALLOC;
									case FILE_OK:
										return 1;
								}
							else {
								header[rv][strlen(header[rv])-1] = 0;
								switch (InsertHeader(count,header,"%s,<%s>\n",header[rv],modlist->email)) {
									case FILE_NOMALLOC:
										return FILE_NOMALLOC;
									case FILE_OK:
										DeleteHeader(rv,count,header);
										return 1;
								}
							}
								
					}	
				}
			}
		}
	}
	// No partial approval to make (or no news header with unapproved groups
	// on the moderated groups list), 

	// make a full approval
	switch(InsertHeader(count,header,"%s <%s>\n",approvestring,smtpsourcepath)) {
		case FILE_NOMALLOC:
		default:
			return FILE_NOMALLOC;
		case FILE_OK:
			return 0;
	}				
}
// ==============================================================
//
// delete headers we don't want
//
static void ApprovalDeleteUnused(int *count, char **header, int isnews)
{
	int pos = isnews ? 0 : 3,rv,j;
	for (j=pos; j < sizeof(skip)/sizeof(char *); j++)
		while ((rv = FindHeader(0,*count,header,skip[j])) != -1)
			DeleteHeader(rv,count,header);
}
// ==============================================================
//
// see if the mozilla status of this message is set to ignore
//
int CheckMozillaIgnore(int count, char **header)
{
	int ms = FindHeader(0,count,header,mozillastatsstring);
	if (ms == -1)
		return 0;
	sscanf(header[ms] + 18,"%x",&ms);

	// if deleted flag set in mozilla status number
	if (ms & 0x8)
		return 1;
	else
		return 0;
}
// ==============================================================
//
// translate a line and put it out, e.g. for hand rejections
//
static int TranslateLine(FILE *out, char *string)
{

	if (!memcmp(string,"\\\\",2)) {
		char name[256];

		// get rid of the line feed if it is theree
		strcpy(name,rejectmessagedir);
		if (name[0] && name[strlen(name)-1] != '\\')
			strcat(name,"\\");
		strcat(name,string+2);
		if (name[strlen(name)-1] == '\n')
			name[strlen(name)-1] = 0;
		// open the file
	        FILE *fil = fopen(name,"r");
		char line[256];
		
		// if the open failed we just copy the line to the output
		// file
		if (fil) {
			// Else we copy lines one at a time from the reject
			// message file
			while (!feof(fil)) {
				char buffer[256];
				fgets(line,256,fil);
				if (fputs(line,out) == EOF) {
					fclose(fil);
					return FILE_WRITEERR;
				}
			}
			fclose(fil);
		}
		else goto display;
	}
	else {
display:
		if (fputs(string,out) == EOF)
			return FILE_WRITEERR;
	}
	return FILE_OK;

}

// ==============================================================
//
// make a second set of headers for the POST file
//
static int CopyHeaders(int *count2,char **head2,int count1,char **head1)
{
	int i;
	*count2 = count1;
	for (i=0; i < count1; i++) {
		head2[i] = litlate(head1[i]);
		if (!head2[i])
			return FILE_NOMALLOC;
	}
	return FILE_OK;
		
}

// ==============================================================
//
// the main approval routine
//
static int ApproveNews(FILE *out, FILE *in, FILE *posted, int isnews, MODLIST *modkeys)
{
	int rv,ignore;
	char *string,**header,*header2[500];
	int count,count2;

	// first skim past the first From - line
	int done = FALSE;
	while (!done) {	
		switch(rv = ReadMailfileLine( in, FALSE, &string)) {
			case FILE_READFROM:
		    		done = TRUE;
				break;
			case FILE_OK:
				if (feof(in))
					return rv;
				if (fputs(string,out) == EOF) {
					free(string);
					return FILE_WRITEERR;
				}
				break;
			default:
				
				return rv;
		}
	}

	// now loop over the rest of the file
	while (!feof(in)) {
		int isthenews = isnews;

		// read the header
		if ((rv = ReadHeaders(in,&count,&header,&string,0)) != FILE_OK)
		        return rv;

		// find out if we are going to do anything with this message
	 	ignore = CheckMozillaIgnore(count,header);

		// process it
		if (topostedfolder && CopyHeaders(&count2,header2,count,header) != FILE_OK)
			return FILE_NOMALLOC;
		ApprovalDeleteUnused(&count,header,isthenews);
		
		FixMozillaStatus(&count,header);
		FixOrganizationLine(&count, header);
		FixSubjectLine(&count,header);

		// approval phase
		if (!isthenews) {
			// from outbox, theck for our newsgroup
			int ng = FindHeader(0,count,header,newsstring);
			if (ng != -1 && strstr(header[ng],groupid)) {
				// got it, see if approved
				rv = FindHeader(0,count,header,approvestring);
				if (rv == -1) {
					rv = FindHeader(0,count,header,partialapprovestring);
					if (rv == -1) {
						// not approved. approve it
						ApproveMessage(&count,header,modkeys);
						FixNewsgroupsLine(&count,header);
						// this will cause the newly approved 
						// message to go to the posted file
						isthenews = TRUE;
					}
				}
			}
		}
		else {
			// from approval box, just approve it
			ApproveMessage(&count,header,modkeys);
			FixNewsgroupsLine(&count,header);
		}

		// write out the banner
		if (!ignore) {
			Banner(out);
			if (isthenews && topostedfolder)
				Banner(posted);
		}

		// Write it back out
		if (!ignore) {
			if (( rv = WriteHeaders(out,count,header)) != FILE_OK) {
                		return rv;
			}
			if (isthenews && topostedfolder && ( rv = WriteHeaders(posted,count2,header2)) != FILE_OK) {
                		return rv;
			}
		}
			
		// news MUST have a blank line after headers
		// mail does not need one but it is going to get one...
		if (!ignore && string[0] != '\n') {
			if (fputc('\n',out) != EOF)
				return FILE_WRITEERR;
			if (isthenews && topostedfolder && fputc('\n',posted) != EOF)
				return FILE_WRITEERR;
		}

		// now write the rest of the file
		do {
			if (!ignore) {
				if( (rv = TranslateLine(out, string)) != FILE_OK) {
					free(string);
					return rv;
				}
				if (isthenews && topostedfolder && fputs(string,posted) ==EOF) {
					free(string);
					return FILE_WRITEERR;
				}
			}
			free(string);
			rv = ReadMailfileLine(in, FALSE,&string);
			if (rv != FILE_OK && rv != FILE_READFROM)
				return rv;
		}while (rv != FILE_READFROM && !feof(in));

		// if we are at end of file flush last line
		if (!ignore && feof(in)) {
			if ((rv = TranslateLine(out, string)) != FILE_OK)
				return rv;
			if (isthenews && topostedfolder && fputs(string,posted) == EOF)
				return FILE_WRITEERR;
		}
	}
	return FILE_OK;
}

// ==============================================================
//
// main line for doing approvals
//
int ApproveAll(void)
{
	FILE *in,*out,*posted=0;
	int count,rv;
	MODLIST *modkeys;

	rv = ModListRead(&modkeys,&count);
	if (rv != FILE_OK)
		return rv;
	// open posted folder
	if (topostedfolder) {
		posted = fopen(postedfolder,"a");
		if (!posted)
			return FILE_WRITEERR;
	}

	in = fopen(outbox,"r");
	if (in) {
		out = fopen(approvaltemp,"w");
		if (!out) {
			if (posted)
				fclose(posted);
			fclose(in);
			return FILE_WRITEERR;
		}
		switch(rv=ApproveNews(out, in, posted, FALSE, modkeys)) {
			case FILE_OK:
				break;
			default:
				if (posted)
					fclose(posted);
				fclose(in);
				fclose(out);
				return rv;
		}
		fclose(out);
		fclose(in);
		unlink(outbox);
		rename(approvaltemp,outbox);
	}
	in = fopen(approvalfolder,"r");
	if (in) {
		out = fopen(outbox,"a");
		if (!out) {
			if (posted)
				fclose(posted);
			fclose(in);
			return FILE_WRITEERR;
		}
		switch(rv=ApproveNews(out, in, posted,TRUE, modkeys)) {
			case FILE_OK:
				break;
			default:
				if (posted)
					fclose(posted);
				fclose(in);
				fclose(out);
				return rv;
		}
		fclose(out);
		fclose(in);
		unlink(approvalfolder);
		fclose(fopen(approvalfolder,"w"));
	}
	if (posted)
		fclose(posted);
	ModListFree(modkeys);
	return FILE_OK;
}