/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm.boundary;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.build.Locator;
import uk.me.parabola.mkgmap.build.LocatorUtil;
import uk.me.parabola.mkgmap.reader.osm.Tags;
import uk.me.parabola.mkgmap.reader.osm.boundary.Boundary;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryLocationInfo;
import uk.me.parabola.util.EnhancedProperties;

public class BoundaryLocationPreparer {
    private static final Logger log = Logger.getLogger(BoundaryLocationPreparer.class);
    private Locator locator;
    private static final Pattern COMMA_OR_SEMICOLON_PATTERN = Pattern.compile("[,;]+");
    private final List<String> nameList;
    private static final String[] LEVEL2_NAMES = new String[]{"name", "name:en", "int_name"};
    public static final int UNSET_ADMIN_LEVEL = 100;

    public BoundaryLocationPreparer(EnhancedProperties props) {
        if (props == null) {
            this.locator = null;
            this.nameList = new ArrayList<String>();
            for (String name : LEVEL2_NAMES) {
                this.nameList.add(name);
            }
        } else {
            this.locator = new Locator(props);
            this.nameList = LocatorUtil.getNameTags(props);
        }
    }

    public BoundaryLocationInfo parseTags(Tags tags) {
        String zip = this.getZip(tags);
        int admLevel = BoundaryLocationPreparer.getAdminLevel(tags);
        boolean isISO = false;
        String name = this.getName(tags);
        if (this.locator != null && admLevel == 2) {
            String isoCode = this.locator.addCountry(tags);
            if (isoCode != null) {
                isISO = true;
                name = isoCode;
            } else {
                log.warn("Country name", name, "not in locator config. Country may not be assigned correctly.");
            }
            log.debug("Coded:", name);
        }
        return new BoundaryLocationInfo(admLevel, name, zip, isISO);
    }

    public HashMap<String, BoundaryLocationInfo> getPreparedLocationInfo(List<Boundary> boundaries) {
        HashMap<String, BoundaryLocationInfo> preparedLocationInfo = new HashMap<String, BoundaryLocationInfo>();
        if (boundaries != null) {
            for (Boundary b : boundaries) {
                preparedLocationInfo.put(b.getId(), this.parseTags(b.getTags()));
            }
        }
        return preparedLocationInfo;
    }

    private String getName(Tags tags) {
        if ("2".equals(tags.get("admin_level"))) {
            for (String enNameTag : LEVEL2_NAMES) {
                String[] nameParts;
                String nameTagValue = tags.get(enNameTag);
                if (nameTagValue == null || (nameParts = COMMA_OR_SEMICOLON_PATTERN.split(nameTagValue)).length == 0) continue;
                return nameParts[0].trim().intern();
            }
        }
        for (String nameTag : this.nameList) {
            String[] nameParts;
            String nameTagValue = tags.get(nameTag);
            if (nameTagValue == null || (nameParts = COMMA_OR_SEMICOLON_PATTERN.split(nameTagValue)).length == 0) continue;
            return nameParts[0].trim().intern();
        }
        return null;
    }

    private String getZip(Tags tags) {
        String zip = tags.get("postal_code");
        if (zip == null && "postal_code".equals(tags.get("boundary"))) {
            String[] nameParts;
            String name = tags.get("name");
            if (name == null) {
                name = this.getName(tags);
            }
            if (name != null && (nameParts = name.split(Pattern.quote(" "))).length > 0) {
                zip = nameParts[0].trim();
            }
        }
        return zip;
    }

    private static int getAdminLevel(Tags tags) {
        String level = tags.get("admin_level");
        if (level == null) {
            return 100;
        }
        try {
            Integer res = Integer.valueOf(level);
            if (res < 2 || res > 11) {
                return 100;
            }
            return res;
        }
        catch (NumberFormatException nfe) {
            return 100;
        }
    }
}

