/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.awt.Polygon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.osm.Element;

public class Way
extends Element {
    private static final Logger log = Logger.getLogger(Way.class);
    private final List<Coord> points;
    private boolean closedInOSM;
    private boolean complete = true;
    private boolean isViaWay;

    public Way(long id) {
        this.points = new ArrayList<Coord>(5);
        this.setId(id);
    }

    public Way(long id, List<Coord> points) {
        this.points = new ArrayList<Coord>(points);
        this.setId(id);
    }

    @Override
    public Way copy() {
        Way dup = new Way(this.getId(), this.points);
        dup.copyTags(this);
        dup.closedInOSM = this.closedInOSM;
        dup.complete = this.complete;
        dup.isViaWay = this.isViaWay;
        return dup;
    }

    public List<Coord> getPoints() {
        return this.points;
    }

    public void addPoint(Coord co) {
        this.points.add(co);
    }

    public void addPointIfNotEqualToLastPoint(Coord co) {
        if (this.points.isEmpty() || !co.equals(this.points.get(this.points.size() - 1))) {
            this.points.add(co);
        }
    }

    public void reverse() {
        Collections.reverse(this.points);
    }

    public boolean isClosed() {
        if (!this.isComplete()) {
            return this.closedInOSM;
        }
        return !this.points.isEmpty() && this.hasIdenticalEndPoints();
    }

    public boolean isClosedInOSM() {
        return this.closedInOSM;
    }

    public boolean hasIdenticalEndPoints() {
        return !this.points.isEmpty() && this.points.get(0) == this.points.get(this.points.size() - 1);
    }

    public boolean hasEqualEndPoints() {
        return !this.points.isEmpty() && this.points.get(0).equals(this.points.get(this.points.size() - 1));
    }

    public void setClosedInOSM(boolean closed) {
        this.closedInOSM = closed;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public String toString() {
        if (this.points.isEmpty()) {
            return "Way: empty";
        }
        Coord coord = this.points.get(0);
        StringBuilder sb = new StringBuilder();
        sb.append("WAY: ").append(this.getId()).append(" ");
        sb.append(this.getName());
        sb.append('(');
        sb.append(Utils.toDegrees(coord.getLatitude()));
        sb.append('/');
        sb.append(Utils.toDegrees(coord.getLongitude()));
        sb.append(')');
        sb.append(' ');
        sb.append(this.toTagString());
        return sb.toString();
    }

    public int hashCode() {
        return (int)this.getId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.getId() == ((Way)o).getId();
    }

    public Coord getCofG() {
        int numPoints = this.points.size();
        if (numPoints < 1) {
            return null;
        }
        double lat = 0.0;
        double lon = 0.0;
        for (Coord p : this.points) {
            lat += (double)p.getHighPrecLat() / (double)numPoints;
            lon += (double)p.getHighPrecLon() / (double)numPoints;
        }
        return Coord.makeHighPrecCoord((int)Math.round(lat), (int)Math.round(lon));
    }

    @Override
    public String kind() {
        return "way";
    }

    public static boolean clockwise(List<Coord> points) {
        if (points.size() < 3 || !points.get(0).equals(points.get(points.size() - 1))) {
            return false;
        }
        if (!points.get(0).highPrecEquals(points.get(points.size() - 1))) {
            log.error((Object)"Way.clockwise was called for way that is not closed in high precision");
        }
        long area = 0L;
        Coord p1 = points.get(0);
        for (int i = 1; i < points.size(); ++i) {
            Coord p2 = points.get(i);
            area += (long)p1.getHighPrecLon() * (long)p2.getHighPrecLat() - (long)p2.getHighPrecLon() * (long)p1.getHighPrecLat();
            p1 = p2;
        }
        return area <= 0L;
    }

    public boolean containsPointsOf(Way other) {
        Polygon thisPoly = new Polygon();
        for (Coord p : this.points) {
            thisPoly.addPoint(p.getHighPrecLon(), p.getHighPrecLat());
        }
        for (Coord p : other.points) {
            if (thisPoly.contains(p.getHighPrecLon(), p.getHighPrecLat())) continue;
            return false;
        }
        return true;
    }

    public boolean isViaWay() {
        return this.isViaWay;
    }

    public void setViaWay(boolean isViaWay) {
        this.isViaWay = isViaWay;
    }
}

