/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.housenumber;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.CoordNode;
import uk.me.parabola.imgfmt.app.net.NumberStyle;
import uk.me.parabola.imgfmt.app.net.Numbers;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.general.LineAdder;
import uk.me.parabola.mkgmap.general.MapRoad;
import uk.me.parabola.mkgmap.osmstyle.housenumber.HousenumberMatch;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.FakeIdGenerator;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.MultiHashMap;

public class HousenumberGenerator {
    private static final Logger log = Logger.getLogger(HousenumberGenerator.class);
    private static final double MAX_DISTANCE_TO_ROAD = 150.0;
    private boolean numbersEnabled;
    private MultiHashMap<String, MapRoad> roadByNames = new MultiHashMap();
    private List<MapRoad> roads;
    private MultiHashMap<String, Element> houseNumbers = new MultiHashMap();

    public HousenumberGenerator(Properties props) {
        this.roads = new ArrayList<MapRoad>();
        this.numbersEnabled = props.containsKey("housenumbers");
    }

    private static String getStreetname(Element e) {
        String streetname = e.getTag("mkgmap:street");
        if (streetname == null) {
            streetname = e.getTag("addr:street");
        }
        return streetname;
    }

    public void addNode(Node n) {
        if (!this.numbersEnabled) {
            return;
        }
        if (HousenumberMatch.getHousenumber(n) != null) {
            String streetname = HousenumberGenerator.getStreetname(n);
            if (streetname != null) {
                this.houseNumbers.add(streetname, n);
            } else if (log.isDebugEnabled()) {
                log.debug(n.toBrowseURL(), " ignored, doesn't contain a street name.");
            }
        }
    }

    public void addWay(Way w) {
        if (!this.numbersEnabled) {
            return;
        }
        if (HousenumberMatch.getHousenumber(w) != null) {
            String streetname = HousenumberGenerator.getStreetname(w);
            if (streetname != null) {
                this.houseNumbers.add(streetname, w);
            } else if (log.isDebugEnabled()) {
                if (FakeIdGenerator.isFakeId(w.getId())) {
                    log.debug("mp-created way ignored, doesn't contain a street name. Tags:", w.toTagString());
                } else {
                    log.debug(w.toBrowseURL(), " ignored, doesn't contain a street name.");
                }
            }
        }
    }

    public void addRoad(Way osmRoad, MapRoad road) {
        String name;
        this.roads.add(road);
        if (this.numbersEnabled && (name = HousenumberGenerator.getStreetname(osmRoad)) != null) {
            if (log.isDebugEnabled()) {
                log.debug("Housenumber - Streetname:", name, "Way:", osmRoad.getId(), osmRoad.toTagString());
            }
            this.roadByNames.add(name, road);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addRelation(Relation r) {
        if (!this.numbersEnabled) {
            return;
        }
        String relType = r.getTag("type");
        if (!"associatedStreet".equals(relType)) {
            if (!"street".equals(relType)) return;
        }
        ArrayList<Element> houses = new ArrayList<Element>();
        ArrayList<Way> streets = new ArrayList<Way>();
        for (Map.Entry<String, Element> member : r.getElements()) {
            if (member.getValue() instanceof Node) {
                Node node = (Node)member.getValue();
                houses.add(node);
            } else if (member.getValue() instanceof Way) {
                String role;
                Way w = (Way)member.getValue();
                switch (role = member.getKey()) {
                    case "house": 
                    case "addr:houselink": 
                    case "address": {
                        houses.add(w);
                        break;
                    }
                    case "street": {
                        streets.add(w);
                        break;
                    }
                    case "": {
                        if (w.getTag("highway") != null) {
                            streets.add(w);
                            break;
                        }
                        String buildingTag = w.getTag("building");
                        if (buildingTag != null) {
                            houses.add(w);
                            break;
                        }
                        log.warn("Relation", r.toBrowseURL(), ": role of member", w.toBrowseURL(), "unclear");
                        break;
                    }
                }
            }
        }
        if (houses.isEmpty()) {
            if (!"associatedStreet".equals(relType)) return;
            log.warn("Relation", r.toBrowseURL(), ": ignored, found no houses");
            return;
        }
        String streetName = r.getTag("name");
        String streetNameFromRoads = null;
        boolean nameFromStreetsIsUnclear = false;
        if (!streets.isEmpty()) {
            for (Element element : streets) {
                String roadName = element.getTag("name");
                if (roadName == null) continue;
                if (streetNameFromRoads == null) {
                    streetNameFromRoads = roadName;
                    continue;
                }
                if (streetNameFromRoads.equals(roadName)) continue;
                nameFromStreetsIsUnclear = true;
            }
        }
        if (streetName == null) {
            if (nameFromStreetsIsUnclear) {
                log.warn("Relation", r.toBrowseURL(), ": ignored, street name is not clear.");
                return;
            }
            streetName = streetNameFromRoads;
        } else if (streetNameFromRoads != null) {
            if (!nameFromStreetsIsUnclear && !streetName.equals(streetNameFromRoads)) {
                log.warn("Relation", r.toBrowseURL(), ": street name is not clear, using the name from the way, not that of the relation.");
                streetName = streetNameFromRoads;
            } else if (nameFromStreetsIsUnclear) {
                log.warn("Relation", r.toBrowseURL(), ": street name is not clear, using the name from the relation.");
            }
        }
        int countOK = 0;
        if (streetName != null && !streetName.isEmpty()) {
            for (Element house : houses) {
                if (!this.addStreetTagFromRel(r, house, streetName)) continue;
                ++countOK;
            }
        }
        if (countOK > 0) {
            log.info("Relation", r.toBrowseURL(), ": added tag mkgmap:street=", streetName, "to", countOK, "of", houses.size(), "house members");
            return;
        }
        log.info("Relation", r.toBrowseURL(), ": ignored, the house members all have a addr:street or mkgmap:street tag");
    }

    private boolean addStreetTagFromRel(Relation r, Element house, String streetName) {
        String addrStreet = HousenumberGenerator.getStreetname(house);
        if (addrStreet == null) {
            house.addTag("mkgmap:street", streetName);
            if (log.isDebugEnabled()) {
                log.debug("Relation", r.toBrowseURL(), ": adding tag mkgmap:street=" + streetName, "to house", house.toBrowseURL());
            }
            return true;
        }
        if (!addrStreet.equals(streetName)) {
            if (house.getTag("mkgmap:street") != null) {
                log.warn("Relation", r.toBrowseURL(), ": street name from relation doesn't match existing mkgmap:street tag for house", house.toBrowseURL(), "the house seems to be member of another type=associatedStreet relation");
                house.deleteTag("mkgmap:street");
            } else {
                log.warn("Relation", r.toBrowseURL(), ": street name from relation doesn't match existing name for house", house.toBrowseURL());
            }
        }
        return false;
    }

    public void generate(LineAdder adder) {
        if (this.numbersEnabled) {
            for (Map.Entry entry : this.houseNumbers.entrySet()) {
                Object possibleRoads = this.roadByNames.get(entry.getKey());
                if (possibleRoads.isEmpty()) continue;
                HousenumberGenerator.match((String)entry.getKey(), (List)entry.getValue(), (List<MapRoad>)possibleRoads);
            }
        }
        for (MapRoad mapRoad : this.roads) {
            adder.add(mapRoad);
        }
        this.houseNumbers.clear();
        this.roadByNames.clear();
        this.roads.clear();
    }

    private static void match(String streetname, List<Element> elements, List<MapRoad> roads) {
        ArrayList<HousenumberMatch> numbersList = new ArrayList<HousenumberMatch>(elements.size());
        for (Element element : elements) {
            try {
                HousenumberMatch housenumberMatch = new HousenumberMatch(element);
                if (housenumberMatch.getLocation() == null) {
                    log.error((Object)"OSM element seems to have no point.");
                    log.error((Object)("Element: " + element.toBrowseURL() + " " + element));
                    log.error((Object)"Please report on the mkgmap mailing list.");
                    log.error((Object)"Continue creating the map. This should be possible without a problem.");
                    continue;
                }
                numbersList.add(housenumberMatch);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.debug((Object)illegalArgumentException);
            }
        }
        MultiHashMap<MapRoad, HousenumberMatch> roadNumbers = new MultiHashMap<MapRoad, HousenumberMatch>();
        for (HousenumberMatch housenumberMatch : numbersList) {
            for (MapRoad r : roads) {
                int node = -1;
                Coord c1 = null;
                for (Coord c2 : r.getPoints()) {
                    double frac;
                    Coord cx;
                    double dist;
                    if (c1 != null && (dist = HousenumberGenerator.distanceToSegment(c1, c2, cx = housenumberMatch.getLocation(), frac = HousenumberGenerator.getFrac(c1, c2, cx))) <= 150.0 && dist < housenumberMatch.getDistance()) {
                        housenumberMatch.setDistance(dist);
                        housenumberMatch.setSegmentFrac(frac);
                        housenumberMatch.setRoad(r);
                        housenumberMatch.setSegment(node);
                    }
                    c1 = c2;
                    ++node;
                }
            }
            if (housenumberMatch.getRoad() == null) continue;
            Coord c1 = housenumberMatch.getRoad().getPoints().get(housenumberMatch.getSegment());
            Coord c2 = housenumberMatch.getRoad().getPoints().get(housenumberMatch.getSegment() + 1);
            housenumberMatch.setLeft(HousenumberGenerator.isLeft(c1, c2, housenumberMatch.getLocation()));
            roadNumbers.add(housenumberMatch.getRoad(), housenumberMatch);
        }
        for (Map.Entry entry : roadNumbers.entrySet()) {
            MapRoad r = (MapRoad)entry.getKey();
            if (((List)entry.getValue()).isEmpty()) continue;
            ArrayList<HousenumberMatch> leftNumbers = new ArrayList<HousenumberMatch>();
            ArrayList<HousenumberMatch> rightNumbers = new ArrayList<HousenumberMatch>();
            for (HousenumberMatch hr : (List)entry.getValue()) {
                if (hr.isLeft()) {
                    leftNumbers.add(hr);
                    continue;
                }
                rightNumbers.add(hr);
            }
            Collections.sort(leftNumbers, new HousenumberMatchComparator());
            Collections.sort(rightNumbers, new HousenumberMatchComparator());
            ArrayList<Numbers> numbersListing = new ArrayList<Numbers>();
            log.info("Housenumbers for", r.getName(), r.getCity());
            log.info("Numbers:", entry.getValue());
            int n = 0;
            int nodeIndex = 0;
            int lastRoutableNodeIndex = 0;
            for (Coord p : r.getPoints()) {
                if (n == 0) assert (p instanceof CoordNode);
                if (p.getId() == 0) {
                    ++n;
                    continue;
                }
                if (n == 0) {
                    ++nodeIndex;
                    ++n;
                    continue;
                }
                Numbers numbers = new Numbers();
                numbers.setNodeNumber(0);
                numbers.setRnodNumber(lastRoutableNodeIndex);
                HousenumberGenerator.applyNumbers(numbers, leftNumbers, n, true);
                HousenumberGenerator.applyNumbers(numbers, rightNumbers, n, false);
                if (log.isInfoEnabled()) {
                    log.info(new Object[]{"Left: ", numbers.getLeftNumberStyle(), numbers.getRnodNumber(), "Start:", numbers.getLeftStart(), "End:", numbers.getLeftEnd(), "Remaining: " + leftNumbers});
                    log.info(new Object[]{"Right:", numbers.getRightNumberStyle(), numbers.getRnodNumber(), "Start:", numbers.getRightStart(), "End:", numbers.getRightEnd(), "Remaining: " + rightNumbers});
                }
                numbersListing.add(numbers);
                lastRoutableNodeIndex = nodeIndex++;
                ++n;
            }
            r.setNumbers(numbersListing);
        }
    }

    private static void applyNumbers(Numbers numbers, List<HousenumberMatch> housenumbers, int maxSegment, boolean left) {
        NumberStyle style = NumberStyle.NONE;
        if (!housenumbers.isEmpty()) {
            HousenumberMatch hn;
            int maxN = -1;
            boolean even = false;
            boolean odd = false;
            for (int i = 0; i < housenumbers.size() && (hn = housenumbers.get(i)).getSegment() < maxSegment; ++i) {
                maxN = i;
                if (hn.getHousenumber() % 2 == 0) {
                    even = true;
                    continue;
                }
                odd = true;
            }
            if (maxN >= 0) {
                style = even && odd ? NumberStyle.BOTH : (even ? NumberStyle.EVEN : NumberStyle.ODD);
                int start = housenumbers.get(0).getHousenumber();
                int end = housenumbers.get(maxN).getHousenumber();
                if (left) {
                    numbers.setLeftStart(start);
                    numbers.setLeftEnd(end);
                } else {
                    numbers.setRightStart(start);
                    numbers.setRightEnd(end);
                }
                housenumbers.subList(0, maxN + 1).clear();
            }
        }
        if (left) {
            numbers.setLeftNumberStyle(style);
        } else {
            numbers.setRightNumberStyle(style);
        }
    }

    private static boolean isLeft(Coord spoint1, Coord spoint2, Coord point) {
        return (spoint2.getHighPrecLon() - spoint1.getHighPrecLon()) * (point.getHighPrecLat() - spoint1.getHighPrecLat()) - (spoint2.getHighPrecLat() - spoint1.getHighPrecLat()) * (point.getHighPrecLon() - spoint1.getHighPrecLon()) > 0;
    }

    private static double distanceToSegment(Coord spoint1, Coord spoint2, Coord point, double frac) {
        if (frac <= 0.0) {
            return spoint1.distance(point);
        }
        if (frac >= 1.0) {
            return spoint2.distance(point);
        }
        return point.distToLineSegment(spoint1, spoint2);
    }

    private static double getFrac(Coord spoint1, Coord spoint2, Coord point) {
        int aLon = spoint1.getHighPrecLon();
        int bLon = spoint2.getHighPrecLon();
        int pLon = point.getHighPrecLon();
        int aLat = spoint1.getHighPrecLat();
        int bLat = spoint2.getHighPrecLat();
        int pLat = point.getHighPrecLat();
        double deltaLon = bLon - aLon;
        double deltaLat = bLat - aLat;
        if (deltaLon == 0.0 && deltaLat == 0.0) {
            return 0.0;
        }
        double scale = Math.cos(Coord.int30ToRadians((aLat + bLat + pLat) / 3));
        double deltaLonAP = scale * (double)(pLon - aLon);
        if ((deltaLon = scale * deltaLon) == 0.0 && deltaLat == 0.0) {
            return 0.0;
        }
        return (deltaLonAP * deltaLon + (double)(pLat - aLat) * deltaLat) / (deltaLon * deltaLon + deltaLat * deltaLat);
    }

    private static class HousenumberMatchComparator
    implements Comparator<HousenumberMatch> {
        private HousenumberMatchComparator() {
        }

        @Override
        public int compare(HousenumberMatch o1, HousenumberMatch o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1.getRoad() != o2.getRoad()) {
                return o1.getRoad().hashCode() - o2.getRoad().hashCode();
            }
            int dSegment = o1.getSegment() - o2.getSegment();
            if (dSegment != 0) {
                return dSegment;
            }
            double dFrac = o1.getSegmentFrac() - o2.getSegmentFrac();
            if (dFrac != 0.0) {
                return (int)Math.signum(dFrac);
            }
            double dDist = o1.getDistance() - o2.getDistance();
            if (dDist != 0.0) {
                return (int)Math.signum(dDist);
            }
            return 0;
        }
    }
}

