/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle;

import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.mkgmap.general.LineAdder;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.scan.SyntaxException;
import uk.me.parabola.mkgmap.scan.TokenScanner;

public class OverlayReader {
    private final Map<Integer, List<Integer>> overlays = new HashMap<Integer, List<Integer>>();
    private final Reader reader;
    private final String filename;

    public OverlayReader(Reader r, String filename) {
        this.reader = r;
        this.filename = filename;
    }

    public void readOverlays() {
        TokenScanner ts = new TokenScanner(this.filename, this.reader);
        while (!ts.isEndOfFile()) {
            String[] fields;
            String line = ts.readLine();
            int commentstart = line.indexOf("#");
            if (commentstart != -1) {
                line = line.substring(0, commentstart);
            }
            if ((fields = line.split(":", 2)).length != 2) continue;
            try {
                this.overlays.put(Integer.decode(fields[0]), this.readReplacements(ts, fields[1]));
            }
            catch (NumberFormatException e) {
                throw new SyntaxException(ts, "Expecting a number");
            }
        }
    }

    private List<Integer> readReplacements(TokenScanner ts, String line) {
        String[] nums;
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (String n : nums = line.split("[ ,]")) {
            if (n == null || n.length() == 0) continue;
            try {
                l.add(Integer.decode(n));
            }
            catch (NumberFormatException e) {
                throw new SyntaxException(ts, "List of numbers expected");
            }
        }
        return l;
    }

    public void addLine(MapLine line, LineAdder adder) {
        int origType = line.getType();
        List<Integer> integerList = this.overlays.get(origType);
        if (integerList != null) {
            MapLine newline = line.copy();
            newline.setType(integerList.get(0));
            List<Coord> points = line.getPoints();
            newline.setPoints(points);
            adder.add(newline);
            ListIterator<Integer> t = integerList.listIterator(1);
            while (t.hasNext()) {
                newline = new MapLine(line);
                newline.setType(t.next());
                newline.setPoints(new ArrayList<Coord>(points));
                adder.add(newline);
            }
        } else {
            adder.add(line);
        }
    }

    public Map<Integer, List<Integer>> getOverlays() {
        return this.overlays;
    }
}

