/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.osmstyle.StyleFileLoader;

public class DirectoryFileLoader
extends StyleFileLoader {
    private static final Logger log = Logger.getLogger(DirectoryFileLoader.class);
    private final File dir;

    public DirectoryFileLoader(File dir) {
        assert (dir.isDirectory());
        this.dir = dir;
    }

    @Override
    public Reader open(String filename) throws FileNotFoundException {
        File file = new File(this.dir, filename);
        InputStreamReader r = null;
        try {
            r = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            System.out.println("DirectoryFileLoader: Encoding UTF-8 not supported");
            r = new InputStreamReader(new FileInputStream(file));
        }
        return new BufferedReader(r);
    }

    @Override
    public void close() {
    }

    @Override
    public String[] list() {
        log.debug("dir list", this.dir);
        ArrayList<String> res = new ArrayList<String>();
        File[] allFiles = this.dir.listFiles();
        if (allFiles != null) {
            for (File file : allFiles) {
                File style;
                log.debug("dir loader", file);
                if (!file.isDirectory() || !(style = new File(file, "version")).exists()) continue;
                res.add(file.getName());
            }
        }
        if (res.isEmpty()) {
            res.add(this.dir.getName());
        }
        return res.toArray(new String[res.size()]);
    }
}

