/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle;

import java.util.List;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.net.AccessTagsAndBits;
import uk.me.parabola.imgfmt.app.trergn.MapObject;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.GType;
import uk.me.parabola.mkgmap.reader.osm.TagDict;
import uk.me.parabola.mkgmap.reader.osm.Way;

public class ConvertedWay {
    private static final Logger log = Logger.getLogger(ConvertedWay.class);
    private final int index;
    private final Way way;
    private final GType gt;
    private byte roadClass;
    private byte roadSpeed;
    private byte mkgmapAccess;
    private final byte routeFlags;
    private boolean isRoad;
    private boolean reversed;
    private boolean overlay;
    private static final short roadClassTagKey = TagDict.getInstance().xlate("mkgmap:road-class");
    private static final short roadSpeedTagKey = TagDict.getInstance().xlate("mkgmap:road-speed");
    private static final short roadSpeedClassTagKey = TagDict.getInstance().xlate("mkgmap:road-speed-class");

    public ConvertedWay(int index, Way way, GType type) {
        this.index = index;
        this.way = way;
        this.gt = type;
        if (type.isRoad() && !MapObject.hasExtendedType(this.gt.getType())) {
            this.roadClass = (byte)this.gt.getRoadClass();
            this.roadSpeed = (byte)this.gt.getRoadSpeed();
            this.recalcRoadClass(way);
            this.recalcRoadSpeed(way);
            this.mkgmapAccess = AccessTagsAndBits.evalAccessTags(way);
            this.routeFlags = AccessTagsAndBits.evalRouteTags(way);
            this.isRoad = true;
        } else {
            this.roadClass = 0;
            this.roadSpeed = 0;
            this.mkgmapAccess = 0;
            this.routeFlags = 0;
            this.isRoad = false;
        }
    }

    public ConvertedWay(ConvertedWay other, Way way) {
        this.way = way;
        this.index = other.index;
        this.gt = other.gt;
        this.roadClass = other.roadClass;
        this.roadSpeed = other.roadSpeed;
        this.mkgmapAccess = other.mkgmapAccess;
        this.routeFlags = other.routeFlags;
    }

    public int getIndex() {
        return this.index;
    }

    public GType getGType() {
        return this.gt;
    }

    public Way getWay() {
        return this.way;
    }

    public byte getAccess() {
        return this.mkgmapAccess;
    }

    public byte getRoadClass() {
        return this.roadClass;
    }

    public byte getRoadSpeed() {
        return this.roadSpeed;
    }

    public byte getRouteFlags() {
        return this.routeFlags;
    }

    public boolean recalcRoadClass(Element el) {
        byte oldRoadClass = this.roadClass;
        String val = el.getTag(roadClassTagKey);
        if (val != null) {
            this.roadClass = val.startsWith("-") ? (byte)(this.roadClass - Byte.decode(val.substring(1))) : (val.startsWith("+") ? (byte)(this.roadClass + Byte.decode(val.substring(1))) : Byte.decode(val));
            val = el.getTag("mkgmap:road-class-max");
            byte roadClassMax = 4;
            if (val != null) {
                roadClassMax = Byte.decode(val);
            }
            val = el.getTag("mkgmap:road-class-min");
            byte roadClassMin = 0;
            if (val != null) {
                roadClassMin = Byte.decode(val);
            }
            if (this.roadClass > roadClassMax) {
                this.roadClass = roadClassMax;
            } else if (this.roadClass < roadClassMin) {
                this.roadClass = roadClassMin;
            }
        }
        return this.roadClass != oldRoadClass;
    }

    public boolean recalcRoadSpeed(Element el) {
        String val;
        byte oldRoadSpeed = this.roadSpeed;
        String roadSpeedOverride = el.getTag(roadSpeedClassTagKey);
        if (roadSpeedOverride != null) {
            try {
                byte rs = Byte.decode(roadSpeedOverride);
                if (rs >= 0 && rs <= 7) {
                    this.roadSpeed = rs;
                } else {
                    log.error((Object)(el.getDebugName() + " road classification mkgmap:road-speed-class=" + roadSpeedOverride + " must be in [0;7]"));
                }
            }
            catch (Exception exp) {
                log.error((Object)(el.getDebugName() + " road classification mkgmap:road-speed-class=" + roadSpeedOverride + " must be in [0;7]"));
            }
        }
        if ((val = el.getTag(roadSpeedTagKey)) != null) {
            this.roadSpeed = val.startsWith("-") ? (byte)(this.roadSpeed - Byte.decode(val.substring(1))) : (val.startsWith("+") ? (byte)(this.roadSpeed + Byte.decode(val.substring(1))) : Byte.decode(val));
            val = el.getTag("mkgmap:road-speed-max");
            byte roadSpeedMax = 7;
            if (val != null) {
                roadSpeedMax = Byte.decode(val);
            }
            val = el.getTag("mkgmap:road-speed-min");
            byte roadSpeedMin = 0;
            if (val != null) {
                roadSpeedMin = Byte.decode(val);
            }
            if (this.roadSpeed > roadSpeedMax) {
                this.roadSpeed = roadSpeedMax;
            } else if (this.roadSpeed < roadSpeedMin) {
                this.roadSpeed = roadSpeedMin;
            }
        }
        return oldRoadSpeed != this.roadSpeed;
    }

    public List<Coord> getPoints() {
        return this.way.getPoints();
    }

    public boolean isValid() {
        if (this.way == null) {
            return false;
        }
        return this.way.getPoints() != null && this.way.getPoints().size() >= 2;
    }

    public String toString() {
        return this.getGType() + " " + this.getWay().getId() + " " + this.getWay().toTagString();
    }

    public boolean isOneway() {
        return (this.routeFlags & 4) != 0;
    }

    public boolean isRoundabout() {
        return (this.routeFlags & 0x40) != 0;
    }

    public boolean isToll() {
        return (this.routeFlags & 8) != 0;
    }

    public boolean isUnpaved() {
        return (this.routeFlags & 0x10) != 0;
    }

    public boolean isFerry() {
        return (this.routeFlags & 0x20) != 0;
    }

    public boolean isCarpool() {
        return (this.routeFlags & 2) != 0;
    }

    public boolean isThroughroute() {
        return (this.routeFlags & 1) != 0;
    }

    public boolean isRoad() {
        return this.isRoad;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    public void setOverlay(boolean b) {
        this.overlay = b;
    }

    public boolean isOverlay() {
        return this.overlay;
    }
}

