/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.main;

import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.map.Map;
import uk.me.parabola.imgfmt.app.trergn.Polyline;
import uk.me.parabola.imgfmt.app.trergn.PolylineOverview;
import uk.me.parabola.imgfmt.app.trergn.Subdivision;
import uk.me.parabola.mkgmap.main.AbstractTestMap;

public class MakeTestLangMap
extends AbstractTestMap {
    public static void main(String[] args) {
        MakeTestLangMap tm = new MakeTestLangMap();
        tm.makeMap(args);
    }

    @Override
    protected void drawTestMap(Map map, Subdivision div, double lat, double lng) {
        this.drawStreetnames(map, div, lat, lng);
    }

    private void drawStreetnames(Map map, Subdivision div, double slat, double slon) {
        char[] hexChars = "0123456789ABCDEF".toCharArray();
        double lat = slat + 0.004;
        double lon = slon + 0.002;
        div.startLines();
        map.setLabelCharset("simple8", true);
        double space = 0.002;
        double size = 0.006;
        for (int y = 0; y < 16; ++y) {
            int start = 128 + 8 * y;
            char[] out = new char[19];
            out[0] = hexChars[(start & 0xF0) >> 4];
            out[1] = hexChars[start & 0xF];
            out[2] = 32;
            for (int i = 0; i < 8; ++i) {
                out[3 + 2 * i] = (char)(65 + i);
                out[3 + 2 * i + 1] = (char)(start + i);
            }
            String name = new String(out);
            Polyline l = div.createLine(new String[]{name, null, null, null});
            double baseLat = lat + (double)y * space;
            Coord co = new Coord(baseLat, lon);
            l.addCoord(co);
            co = new Coord(baseLat, lon + size);
            l.addCoord(co);
            l.setType(6);
            map.addMapObject(l);
        }
        map.addPolylineOverview(new PolylineOverview(1536, 10));
    }
}

