/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.general;

import java.util.List;
import uk.me.parabola.imgfmt.app.lbl.City;
import uk.me.parabola.imgfmt.app.lbl.Zip;
import uk.me.parabola.imgfmt.app.net.Numbers;
import uk.me.parabola.imgfmt.app.net.RoadDef;
import uk.me.parabola.mkgmap.general.MapLine;

public class MapRoad
extends MapLine {
    private final RoadDef roadDef;
    private boolean segmentsFollowing;

    public MapRoad(long id, MapLine line) {
        super(line);
        this.setPoints(line.getPoints());
        this.roadDef = new RoadDef(id, this.getName());
    }

    private MapRoad(MapRoad r) {
        super(r);
        this.roadDef = r.roadDef;
        this.segmentsFollowing = r.segmentsFollowing;
    }

    @Override
    public MapRoad copy() {
        return new MapRoad(this);
    }

    @Override
    public boolean isRoad() {
        return true;
    }

    public void setRoadClass(int roadClass) {
        this.roadDef.setRoadClass(roadClass);
    }

    public void setSpeed(int speed) {
        this.roadDef.setSpeed(speed);
    }

    public void setOneway() {
        this.roadDef.setOneway();
    }

    public void setToll() {
        this.roadDef.setToll();
    }

    public void paved(boolean p) {
        this.roadDef.paved(p);
    }

    public void ferry(boolean f) {
        this.roadDef.ferry(f);
    }

    public void setSynthesised(boolean s) {
        this.roadDef.setSynthesised(s);
    }

    public void setAccess(byte access) {
        this.roadDef.setAccess(access);
    }

    public void setCarpoolLane() {
        this.roadDef.setCarpoolLane();
    }

    public void setNoThroughRouting() {
        this.roadDef.setNoThroughRouting();
    }

    public void setStartsWithNode(boolean s) {
        this.roadDef.setStartsWithNode(s);
    }

    public void setInternalNodes(boolean s) {
        this.roadDef.setInternalNodes(s);
    }

    public void setNumNodes(int n) {
        this.roadDef.setNumNodes(n);
    }

    public void setNumbers(List<Numbers> numbers) {
        this.roadDef.setNumbersList(numbers);
    }

    public RoadDef getRoadDef() {
        return this.roadDef;
    }

    public void setRoadCity(City c) {
        this.roadDef.setCity(c);
    }

    public void setRoadZip(Zip z) {
        this.roadDef.setZip(z);
    }

    public void setRoundabout(boolean r) {
        this.roadDef.setRoundabout(r);
    }

    public void doFlareCheck(boolean fc) {
        this.roadDef.doFlareCheck(fc);
    }

    public void setLinkRoad(boolean lr) {
        this.roadDef.setLinkRoad(lr);
    }

    public boolean hasSegmentsFollowing() {
        return this.segmentsFollowing;
    }

    public void setSegmentsFollowing(boolean segmentsFollowing) {
        this.segmentsFollowing = segmentsFollowing;
    }
}

