/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.general;

import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.mkgmap.general.MapPoint;

public class MapPointKdTree {
    private static final boolean ROOT_NODE_USES_LONGITUDE = false;
    private KdNode root = null;
    private int size;
    private MapPoint nextPoint;
    private double minDist;

    public long size() {
        return this.size;
    }

    public void add(MapPoint toAdd) {
        ++this.size;
        this.root = this.add(toAdd, this.root, false);
    }

    private boolean isSmaller(boolean longitude, Coord c1, Coord c2) {
        if (longitude) {
            return c1.getLongitude() < c2.getLongitude();
        }
        return c1.getLatitude() < c2.getLatitude();
    }

    private KdNode add(MapPoint toAdd, KdNode tree, boolean useLongitude) {
        if (tree == null) {
            tree = new KdNode(toAdd);
        } else if (this.isSmaller(useLongitude, toAdd.getLocation(), tree.point.getLocation())) {
            tree.left = this.add(toAdd, tree.left, !useLongitude);
        } else {
            tree.right = this.add(toAdd, tree.right, !useLongitude);
        }
        return tree;
    }

    public MapPoint findNextPoint(MapPoint p) {
        this.minDist = Double.MAX_VALUE;
        this.nextPoint = null;
        return this.findNextPoint(p, this.root, false);
    }

    private MapPoint findNextPoint(MapPoint p, KdNode tree, boolean useLongitude) {
        Coord test;
        boolean continueWithLeft = false;
        if (tree == null) {
            return this.nextPoint;
        }
        if (tree.left == null && tree.right == null) {
            double dist = tree.point.getLocation().distanceInDegreesSquared(p.getLocation());
            if (dist < this.minDist) {
                this.nextPoint = tree.point;
                this.minDist = dist;
            }
            return this.nextPoint;
        }
        if (this.isSmaller(useLongitude, p.getLocation(), tree.point.getLocation())) {
            continueWithLeft = false;
            this.nextPoint = this.findNextPoint(p, tree.left, !useLongitude);
        } else {
            continueWithLeft = true;
            this.nextPoint = this.findNextPoint(p, tree.right, !useLongitude);
        }
        double dist = tree.point.getLocation().distanceInDegreesSquared(p.getLocation());
        if (dist < this.minDist) {
            this.nextPoint = tree.point;
            this.minDist = dist;
        }
        if ((test = useLongitude ? Coord.makeHighPrecCoord(p.getLocation().getHighPrecLat(), tree.point.getLocation().getHighPrecLon()) : Coord.makeHighPrecCoord(tree.point.getLocation().getHighPrecLat(), p.getLocation().getHighPrecLon())).distanceInDegreesSquared(p.getLocation()) < this.minDist) {
            this.nextPoint = continueWithLeft ? this.findNextPoint(p, tree.left, !useLongitude) : this.findNextPoint(p, tree.right, !useLongitude);
        }
        return this.nextPoint;
    }

    private static class KdNode {
        MapPoint point;
        KdNode left;
        KdNode right;

        KdNode(MapPoint p) {
            this.point = p;
        }
    }
}

