/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.filters;

import uk.me.parabola.mkgmap.filters.FilterConfig;
import uk.me.parabola.mkgmap.filters.MapFilter;
import uk.me.parabola.mkgmap.filters.MapFilterChain;
import uk.me.parabola.mkgmap.general.MapElement;
import uk.me.parabola.mkgmap.general.MapLine;

public class SizeFilter
implements MapFilter {
    private final int size;
    private int minSize;
    private boolean checkRouting;

    public SizeFilter(int s) {
        this.size = s;
    }

    @Override
    public void init(FilterConfig config) {
        this.minSize = this.size * (1 << config.getShift());
        this.checkRouting = config.getLevel() == 0 && config.isRoutable();
    }

    @Override
    public void doFilter(MapElement element, MapFilterChain next) {
        MapLine line = (MapLine)element;
        if (!(line.isSkipSizeFilter() || this.checkRouting && line.isRoad()) && line.getBounds().getMaxDimension() < this.minSize) {
            return;
        }
        next.doFilter(line);
    }
}

