/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.filters;

import java.util.ArrayList;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.CoordNode;
import uk.me.parabola.mkgmap.filters.FilterConfig;
import uk.me.parabola.mkgmap.filters.MapFilter;
import uk.me.parabola.mkgmap.filters.MapFilterChain;
import uk.me.parabola.mkgmap.general.MapElement;
import uk.me.parabola.mkgmap.general.MapLine;

public class RoundCoordsFilter
implements MapFilter {
    private int shift;
    private boolean checkRouting;

    @Override
    public void init(FilterConfig config) {
        this.shift = config.getShift();
        this.checkRouting = config.getLevel() == 0 && config.isRoutable();
    }

    @Override
    public void doFilter(MapElement element, MapFilterChain next) {
        MapLine line = (MapLine)element;
        int half = 1 << this.shift - 1;
        int mask = ~((1 << this.shift) - 1);
        if (this.shift == 0) {
            next.doFilter(line);
        } else {
            ArrayList<Coord> newPoints = new ArrayList<Coord>(line.getPoints().size());
            Coord lastP = null;
            for (Coord p : line.getPoints()) {
                int lat = p.getLatitude() + half & mask;
                int lon = p.getLongitude() + half & mask;
                Coord newP = p instanceof CoordNode && this.checkRouting ? new CoordNode(lat, lon, p.getId(), p.getOnBoundary()) : new Coord(lat, lon);
                newP.preserved(p.preserved());
                if (lastP == null || !lastP.equals(newP) || newP instanceof CoordNode && !(lastP instanceof CoordNode)) {
                    newPoints.add(newP);
                    lastP = newP;
                    continue;
                }
                if (!newP.preserved()) continue;
                lastP.preserved(true);
            }
            if (newPoints.size() > 1) {
                MapLine newLine = line.copy();
                newLine.setPoints(newPoints);
                next.doFilter(newLine);
            }
        }
    }
}

