/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.build;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.net.RoadNetwork;
import uk.me.parabola.imgfmt.app.trergn.Overview;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.filters.FilterConfig;
import uk.me.parabola.mkgmap.filters.LineSizeSplitterFilter;
import uk.me.parabola.mkgmap.filters.MapFilterChain;
import uk.me.parabola.mkgmap.filters.PolygonSubdivSizeSplitterFilter;
import uk.me.parabola.mkgmap.general.MapDataSource;
import uk.me.parabola.mkgmap.general.MapElement;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.general.MapPoint;
import uk.me.parabola.mkgmap.general.MapRoad;
import uk.me.parabola.mkgmap.general.MapShape;

public class MapArea
implements MapDataSource {
    private static final Logger log = Logger.getLogger(MapArea.class);
    private static final int INITIAL_CAPACITY = 100;
    private static final int MAX_RESOLUTION = 24;
    private static final int LARGE_OBJECT_DIM = 8192;
    public static final int POINT_KIND = 0;
    public static final int LINE_KIND = 1;
    public static final int SHAPE_KIND = 2;
    public static final int XT_POINT_KIND = 3;
    public static final int XT_LINE_KIND = 4;
    public static final int XT_SHAPE_KIND = 5;
    public static final int NUM_KINDS = 6;
    private final Area bounds;
    private int minLat = Integer.MAX_VALUE;
    private int minLon = Integer.MAX_VALUE;
    private int maxLat = Integer.MIN_VALUE;
    private int maxLon = Integer.MIN_VALUE;
    private final List<MapPoint> points = new ArrayList<MapPoint>(100);
    private final List<MapLine> lines = new ArrayList<MapLine>(100);
    private final List<MapShape> shapes = new ArrayList<MapShape>(100);
    private final int[] sizes = new int[6];
    private int nActivePoints;
    private int nActiveIndPoints;
    private int nActiveLines;
    private int nActiveShapes;
    private final int areaResolution;

    public MapArea(MapDataSource src, int resolution) {
        this.areaResolution = 0;
        this.bounds = src.getBounds();
        for (MapPoint p : src.getPoints()) {
            if (this.bounds.contains(p.getLocation())) {
                this.addPoint(p);
                continue;
            }
            log.error((Object)("Point with type 0x" + Integer.toHexString(p.getType()) + " at " + p.getLocation().toOSMURL() + " is outside of the map area centred on " + this.bounds.getCenter().toOSMURL() + " width = " + this.bounds.getWidth() + " height = " + this.bounds.getHeight() + " resolution = " + resolution));
        }
        this.addLines(src, resolution);
        this.addPolygons(src, resolution);
    }

    private void addPolygons(MapDataSource src, int resolution) {
        MapFilterChain chain = new MapFilterChain(){

            @Override
            public void doFilter(MapElement element) {
                MapShape shape = (MapShape)element;
                MapArea.this.addShape(shape);
            }
        };
        PolygonSubdivSizeSplitterFilter filter = new PolygonSubdivSizeSplitterFilter();
        FilterConfig config = new FilterConfig();
        config.setResolution(resolution);
        config.setBounds(this.bounds);
        filter.init(config);
        for (MapShape s : src.getShapes()) {
            filter.doFilter(s, chain);
        }
    }

    private void addLines(MapDataSource src, int resolution) {
        MapFilterChain chain = new MapFilterChain(){

            @Override
            public void doFilter(MapElement element) {
                MapLine line = (MapLine)element;
                MapArea.this.addLine(line);
            }
        };
        LineSizeSplitterFilter filter = new LineSizeSplitterFilter();
        FilterConfig config = new FilterConfig();
        config.setResolution(resolution);
        config.setBounds(this.bounds);
        filter.init(config);
        for (MapLine l : src.getLines()) {
            filter.doFilter(l, chain);
        }
    }

    private MapArea(Area area, int res) {
        this.bounds = area;
        this.areaResolution = res;
    }

    public MapArea[] split(int nx, int ny, int resolution, Area bounds) {
        ArrayList<MapArea> largeObjectAreas;
        Area[] areas = bounds.split(nx, ny);
        MapArea[] mapAreas = new MapArea[nx * ny];
        log.info((Object)("Splitting area " + bounds + " into " + nx + "x" + ny + " pieces at resolution " + resolution));
        boolean useNormalSplit = true;
        while (true) {
            MapArea largeObjectArea;
            largeObjectAreas = new ArrayList<MapArea>();
            for (int i = 0; i < nx * ny; ++i) {
                mapAreas[i] = new MapArea(areas[i], resolution);
                if (!log.isDebugEnabled()) continue;
                log.debug("area before", mapAreas[i].getBounds());
            }
            int xbase30 = areas[0].getMinLong() << 6;
            int ybase30 = areas[0].getMinLat() << 6;
            int dx30 = areas[0].getWidth() << 6;
            int dy30 = areas[0].getHeight() << 6;
            boolean[] used = new boolean[nx * ny];
            for (MapPoint p : this.points) {
                int pos = this.pickArea(mapAreas, p, xbase30, ybase30, nx, ny, dx30, dy30);
                mapAreas[pos].addPoint(p);
                used[pos] = true;
            }
            int maxWidth = areas[0].getWidth();
            int maxHeight = areas[0].getHeight();
            if (nx * ny == 1 || maxWidth < 8192 || maxHeight < 8192) {
                maxWidth = Integer.MAX_VALUE;
                maxHeight = Integer.MAX_VALUE;
            }
            int areaIndex = 0;
            for (MapLine l : this.lines) {
                if (!(l instanceof MapRoad) && l.getRect().height <= 0 && l.getRect().width <= 0) continue;
                if (useNormalSplit) {
                    areaIndex = this.pickArea(mapAreas, l, xbase30, ybase30, nx, ny, dx30, dy30);
                    if (l.getBounds().getHeight() > maxHeight || l.getBounds().getWidth() > maxWidth) {
                        largeObjectArea = new MapArea(l.getBounds(), resolution);
                        largeObjectArea.addLine(l);
                        largeObjectAreas.add(largeObjectArea);
                        continue;
                    }
                } else {
                    ++areaIndex;
                    areaIndex %= mapAreas.length;
                }
                mapAreas[areaIndex].addLine(l);
                used[areaIndex] = true;
            }
            for (MapShape e : this.shapes) {
                if (useNormalSplit) {
                    areaIndex = this.pickArea(mapAreas, e, xbase30, ybase30, nx, ny, dx30, dy30);
                    if (e.getBounds().getHeight() > maxHeight || e.getBounds().getWidth() > maxWidth) {
                        largeObjectArea = new MapArea(e.getBounds(), resolution);
                        largeObjectArea.addShape(e);
                        largeObjectAreas.add(largeObjectArea);
                        continue;
                    }
                } else {
                    ++areaIndex;
                    areaIndex %= mapAreas.length;
                }
                mapAreas[areaIndex].addShape(e);
                used[areaIndex] = true;
            }
            if (!useNormalSplit || mapAreas.length != 2 || bounds.getMaxDimension() >= 22 || used[0] == used[1] || this.lines.size() <= 1 && this.shapes.size() <= 1) break;
            useNormalSplit = false;
        }
        if (!largeObjectAreas.isEmpty()) {
            int pos = mapAreas.length;
            mapAreas = Arrays.copyOf(mapAreas, mapAreas.length + largeObjectAreas.size());
            for (MapArea ma : largeObjectAreas) {
                mapAreas[pos++] = ma;
            }
        }
        return mapAreas;
    }

    public Area getFullBounds() {
        return new Area(this.minLat, this.minLon, this.maxLat, this.maxLon);
    }

    public int[] getEstimatedSizes() {
        return this.sizes;
    }

    @Override
    public Area getBounds() {
        return this.bounds;
    }

    @Override
    public List<MapPoint> getPoints() {
        return this.points;
    }

    @Override
    public List<MapLine> getLines() {
        return this.lines;
    }

    @Override
    public List<MapShape> getShapes() {
        return this.shapes;
    }

    @Override
    public RoadNetwork getRoadNetwork() {
        return null;
    }

    @Override
    public List<Overview> getOverviews() {
        return null;
    }

    public boolean hasPoints() {
        return this.nActivePoints > 0;
    }

    public boolean hasIndPoints() {
        return this.nActiveIndPoints > 0;
    }

    public boolean hasLines() {
        return this.nActiveLines > 0;
    }

    public int getNumLines() {
        return this.nActiveLines;
    }

    public int getNumShapes() {
        return this.nActiveShapes;
    }

    public int getNumPoints() {
        return this.nActivePoints + this.nActiveIndPoints;
    }

    public boolean hasShapes() {
        return this.nActiveShapes > 0;
    }

    private void addSize(MapElement p, int kind) {
        int res = p.getMinResolution();
        if (res > 24) {
            return;
        }
        switch (kind) {
            case 0: 
            case 3: {
                if (res > this.areaResolution) break;
                int n = kind;
                this.sizes[n] = this.sizes[n] + 9;
                if (p.hasExtendedType()) break;
                if (((MapPoint)p).isCity()) {
                    ++this.nActiveIndPoints;
                    break;
                }
                ++this.nActivePoints;
                break;
            }
            case 1: 
            case 4: {
                if (res > this.areaResolution) break;
                int numPoints = ((MapLine)p).getPoints().size();
                int numElements = 1 + (numPoints - 1) / 250;
                int n = kind;
                this.sizes[n] = this.sizes[n] + (numElements * 11 + numPoints * 4);
                if (p.hasExtendedType()) break;
                this.nActiveLines += numElements;
                break;
            }
            case 2: 
            case 5: {
                if (res > this.areaResolution) break;
                int numPoints = ((MapLine)p).getPoints().size();
                int numElements = 1 + (numPoints - 1) / 250;
                int n = kind;
                this.sizes[n] = this.sizes[n] + (numElements * 11 + numPoints * 4);
                if (p.hasExtendedType()) break;
                this.nActiveShapes += numElements;
                break;
            }
            default: {
                log.error((Object)"should not be here");
                assert (false);
                break;
            }
        }
    }

    private void addPoint(MapPoint p) {
        this.points.add(p);
        this.addToBounds(p.getLocation());
        this.addSize(p, p.hasExtendedType() ? 3 : 0);
    }

    private void addLine(MapLine l) {
        this.lines.add(l);
        this.addToBounds(l.getBounds());
        this.addSize(l, l.hasExtendedType() ? 4 : 1);
    }

    private void addShape(MapShape s) {
        this.shapes.add(s);
        this.addToBounds(s.getBounds());
        this.addSize(s, s.hasExtendedType() ? 5 : 2);
    }

    private void addToBounds(Area a) {
        int l = a.getMinLat();
        if (l < this.minLat) {
            this.minLat = l;
        }
        if ((l = a.getMaxLat()) > this.maxLat) {
            this.maxLat = l;
        }
        if ((l = a.getMinLong()) < this.minLon) {
            this.minLon = l;
        }
        if ((l = a.getMaxLong()) > this.maxLon) {
            this.maxLon = l;
        }
    }

    private void addToBounds(Coord co) {
        int lon30;
        int lonLeft;
        int lonRight;
        int latUpper;
        int lat30 = co.getHighPrecLat();
        int latLower = lat30 >> 6;
        int n = latUpper = latLower << 6 < lat30 ? latLower + 1 : latLower;
        if (latLower < this.minLat) {
            this.minLat = latLower;
        }
        if (latUpper > this.maxLat) {
            this.maxLat = latUpper;
        }
        int n2 = lonRight = (lonLeft = (lon30 = co.getHighPrecLon()) >> 6) << 6 < lon30 ? lonLeft + 1 : lonLeft;
        if (lonLeft < this.minLon) {
            this.minLon = lonLeft;
        }
        if (lonRight > this.maxLon) {
            this.maxLon = lonRight;
        }
    }

    private int pickArea(MapArea[] areas, MapElement e, int xbase30, int ybase30, int nx, int ny, int dx30, int dy30) {
        int x = e.getLocation().getHighPrecLon();
        int y = e.getLocation().getHighPrecLat();
        int xcell = (x - xbase30) / dx30;
        int ycell = (y - ybase30) / dy30;
        if (xcell < 0) {
            log.info("xcell was", xcell, "x", x, "xbase", xbase30);
            xcell = 0;
        }
        if (ycell < 0) {
            log.info("ycell was", ycell, "y", y, "ybase", ybase30);
            ycell = 0;
        }
        if (xcell >= nx) {
            xcell = nx - 1;
        }
        if (ycell >= ny) {
            ycell = ny - 1;
        }
        if (log.isDebugEnabled()) {
            log.debug("adding", e.getLocation(), "to", xcell, "/", ycell, areas[xcell * ny + ycell].getBounds());
        }
        return xcell * ny + ycell;
    }

    public boolean hasData() {
        return !this.points.isEmpty() || !this.lines.isEmpty() || !this.shapes.isEmpty();
    }
}

