/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class UsefulFormatter
extends Formatter {
    private boolean showTime = true;

    @Override
    public String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        if (this.showTime) {
            long millis = record.getMillis();
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(millis);
            sb.append(cal.get(1));
            sb.append('/');
            sb.append(this.fmt2(cal.get(2) + 1));
            sb.append('/');
            sb.append(this.fmt2(cal.get(5)));
            sb.append(' ');
            sb.append(this.fmt2(cal.get(11)));
            sb.append(':');
            sb.append(this.fmt2(cal.get(12)));
            sb.append(':');
            sb.append(this.fmt2(cal.get(13)));
            sb.append(' ');
        }
        sb.append(record.getLevel().getLocalizedName());
        sb.append(" (");
        sb.append(this.shortName(record.getLoggerName()));
        sb.append("): ");
        sb.append(record.getMessage());
        sb.append('\n');
        Throwable t = record.getThrown();
        if (t != null) {
            StringWriter out = new StringWriter();
            PrintWriter pw = new PrintWriter(out);
            t.printStackTrace(pw);
            sb.append(out.toString());
        }
        return sb.toString();
    }

    public void setShowTime(boolean showTime) {
        this.showTime = showTime;
    }

    private String fmt2(int i) {
        StringBuffer res = new StringBuffer(String.valueOf(i));
        while (res.length() < 2) {
            res.insert(0, '0');
        }
        return res.toString();
    }

    private String shortName(String name) {
        int end = name.lastIndexOf(46);
        if (end > 0) {
            return name.substring(end + 1);
        }
        return name;
    }
}

