/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.sys;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.NonReadableChannelException;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.imgfmt.sys.BlockManager;
import uk.me.parabola.imgfmt.sys.Dirent;
import uk.me.parabola.log.Logger;

public class FileNode
implements ImgChannel {
    private static final Logger log = Logger.getLogger(FileNode.class);
    private boolean open;
    private boolean writeable;
    private boolean readable;
    private final FileChannel file;
    private final BlockManager blockManager;
    private final Dirent dirent;
    private long position;
    private byte xorByte;

    public FileNode(FileChannel file, Dirent dir, String mode) {
        this.file = file;
        this.dirent = dir;
        if (mode.indexOf(114) >= 0) {
            this.readable = true;
        }
        if (mode.indexOf(119) >= 0) {
            this.writeable = true;
        }
        if (!this.readable && !this.writeable) {
            throw new IllegalArgumentException("File must be readable or writeable");
        }
        this.blockManager = dir.getBlockManager();
        if (this.blockManager == null) {
            throw new IllegalArgumentException("no file system supplied");
        }
        this.open = true;
    }

    @Override
    public void close() throws IOException {
        if (!this.open) {
            return;
        }
        this.sync();
        this.open = false;
        this.readable = false;
        this.writeable = false;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        int blockSize = this.blockManager.getBlockSize();
        long size = dst.remaining();
        long fileSize = this.dirent.getSize();
        if (this.position >= fileSize) {
            return -1;
        }
        size = Math.min(size, fileSize - this.position);
        int totalRead = 0;
        while (size > 0L) {
            int lblock = (int)(this.position / (long)blockSize);
            int pblock = this.dirent.getPhysicalBlock(lblock);
            if (pblock == 65535) {
                log.debug((Object)"at eof");
                break;
            }
            int off = (int)(this.position - (long)(lblock * blockSize));
            this.file.position((long)pblock * (long)blockSize + (long)off);
            int n = (int)size;
            if (n > blockSize) {
                n = blockSize;
            }
            if (off != 0) {
                n = Math.min(n, blockSize - off);
            }
            dst.limit(dst.position() + n);
            int pos = dst.position();
            int nr = this.file.read(dst);
            if (nr == -1) {
                return -1;
            }
            if (nr == 0) {
                throw new IOException("Read nothing");
            }
            if (this.xorByte != 0) {
                byte[] bufBytes = dst.array();
                int i = pos + n - 1;
                while (i >= pos) {
                    int n2 = i--;
                    bufBytes[n2] = (byte)(bufBytes[n2] ^ this.xorByte);
                }
            }
            size -= (long)nr;
            this.position += (long)nr;
            totalRead += nr;
        }
        log.debug("read ret", totalRead);
        return totalRead;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        int blockSize = this.blockManager.getBlockSize();
        int size = src.remaining();
        int totalWritten = 0;
        while (size > 0) {
            int lblock = (int)(this.position / (long)blockSize);
            int pblock = this.dirent.getPhysicalBlock(lblock);
            log.debug("lblock / pblock", lblock, Character.valueOf('/'), pblock);
            if (pblock == 65535) {
                log.debug((Object)"allocating new block");
                pblock = this.blockManager.allocate();
                this.dirent.addBlock(pblock);
            }
            int off = (int)(this.position - (long)(lblock * blockSize));
            this.file.position((long)pblock * (long)blockSize + (long)off);
            int n = size;
            if (n > blockSize) {
                n = blockSize;
            }
            if (off != 0) {
                n = Math.min(n, blockSize - off);
            }
            src.limit(src.position() + n);
            int nw = this.file.write(src);
            if (nw == 0) {
                throw new IOException("Wrote nothing");
            }
            size -= nw;
            this.position += (long)nw;
            totalWritten += nw;
            if (this.position <= (long)this.dirent.getSize()) continue;
            this.dirent.setSize((int)this.position);
        }
        return totalWritten;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public void position(long pos) {
        int blockSize = this.blockManager.getBlockSize();
        while (pos > this.position) {
            long lblock = this.position / (long)blockSize;
            int pblock = this.dirent.getPhysicalBlock((int)lblock);
            if (pblock == 65535 && this.writeable) {
                log.debug("setting position allocating new block", lblock);
                pblock = this.blockManager.allocate();
                this.dirent.addBlock(pblock);
            }
            this.position = (lblock + 1L) * (long)blockSize;
        }
        this.position = pos;
    }

    private void sync() throws IOException {
        if (!this.writeable) {
            return;
        }
        int bs = this.blockManager.getBlockSize();
        long rem = (long)bs - this.file.position() % (long)bs;
        ByteBuffer buf = ByteBuffer.allocate(this.blockManager.getBlockSize());
        int i = 0;
        while ((long)i < rem) {
            buf.put((byte)0);
            ++i;
        }
        buf.flip();
        this.file.write(buf);
    }

    public void setXorByte(byte xorByte) {
        this.xorByte = xorByte;
    }
}

