/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.mps;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.BufferedImgFileReader;
import uk.me.parabola.imgfmt.app.ImgFileReader;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.imgfmt.mps.MapBlock;
import uk.me.parabola.imgfmt.mps.ProductBlock;

public class MpsFileReader
implements Closeable {
    private final List<MapBlock> maps = new ArrayList<MapBlock>();
    private final List<ProductBlock> products = new ArrayList<ProductBlock>();
    private final ImgChannel chan;
    private final ImgFileReader reader;

    public MpsFileReader(ImgChannel chan) {
        this.chan = chan;
        this.reader = new BufferedImgFileReader(chan);
        this.readBlocks();
    }

    private void readBlocks() {
        byte type;
        block4: while ((type = this.reader.get()) > 0) {
            char len = this.reader.getChar();
            switch (type) {
                case 76: {
                    this.readMapBlock();
                    continue block4;
                }
                case 70: {
                    this.readProductBlock();
                    continue block4;
                }
            }
            this.reader.get(len);
        }
    }

    private void readMapBlock() {
        MapBlock block = new MapBlock();
        int val = this.reader.getInt();
        block.setIds(val >>> 16, val & 0xFFFF);
        block.setMapNumber(this.reader.getInt());
        block.setSeriesName(this.reader.getZString());
        block.setMapDescription(this.reader.getZString());
        block.setAreaName(this.reader.getZString());
        block.setHexNumber(this.reader.getInt());
        this.reader.getInt();
        this.maps.add(block);
    }

    private void readProductBlock() {
        ProductBlock block = new ProductBlock();
        block.setProductId(this.reader.getChar());
        block.setFamilyId(this.reader.getChar());
        block.setDescription(this.reader.getZString());
        this.products.add(block);
    }

    public List<MapBlock> getMaps() {
        return this.maps;
    }

    public List<ProductBlock> getProducts() {
        return this.products;
    }

    @Override
    public void close() throws IOException {
        this.chan.close();
    }
}

