/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.mps;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.imgfmt.mps.MapBlock;
import uk.me.parabola.imgfmt.mps.MapsetBlock;
import uk.me.parabola.imgfmt.mps.ProductBlock;

public class MpsFile {
    private String mapsetName = "OSM map set";
    private final Set<ProductBlock> products = new HashSet<ProductBlock>();
    private final List<MapBlock> maps = new ArrayList<MapBlock>();
    private final ImgChannel chan;

    public MpsFile(ImgChannel chan) {
        this.chan = chan;
    }

    public void sync() throws IOException {
        for (MapBlock map : this.maps) {
            map.write(this.chan);
        }
        for (ProductBlock block : this.products) {
            block.write(this.chan);
        }
        MapsetBlock mapset = new MapsetBlock();
        mapset.setName(this.mapsetName);
        mapset.write(this.chan);
    }

    public void addMap(MapBlock map) {
        this.maps.add(map);
    }

    public void addProduct(ProductBlock pb) {
        this.products.add(pb);
    }

    public void setMapsetName(String mapsetName) {
        this.mapsetName = mapsetName;
    }

    public void close() throws IOException {
        this.chan.close();
    }
}

