/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.trergn;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.trergn.Subdivision;

public class Zoom {
    private final int level;
    private boolean inherited;
    private final int resolution;
    private final List<Subdivision> subdivs = new ArrayList<Subdivision>();

    Zoom(int zoom, int resolution) {
        this.level = zoom;
        this.resolution = resolution;
    }

    public Iterator<Subdivision> subdivIterator() {
        return this.subdivs.iterator();
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    public int getLevel() {
        return this.level;
    }

    public int getResolution() {
        return this.resolution;
    }

    public int getShiftValue() {
        return 24 - this.resolution;
    }

    public void write(ImgFileWriter file) {
        file.put((byte)(this.level & 0xF | (this.inherited ? 128 : 0)));
        file.put((byte)this.resolution);
        file.putChar((char)this.subdivs.size());
    }

    public String toString() {
        return "L " + this.level + ':' + this.resolution;
    }

    void addSubdivision(Subdivision div) {
        this.subdivs.add(div);
    }
}

