/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.srt;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.BufferedImgFileWriter;
import uk.me.parabola.imgfmt.app.ImgFile;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.SectionWriter;
import uk.me.parabola.imgfmt.app.srt.CodePosition;
import uk.me.parabola.imgfmt.app.srt.SRTHeader;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.fs.ImgChannel;

public class SRTFile
extends ImgFile {
    private final SRTHeader header;
    private Sort sort;
    private boolean isMulti;
    private String description;
    private final List<Integer> srt8Starts = new ArrayList<Integer>();

    public SRTFile(ImgChannel chan) {
        this.header = new SRTHeader();
        this.setHeader(this.header);
        BufferedImgFileWriter fileWriter = new BufferedImgFileWriter(chan);
        fileWriter.setMaxSize(Long.MAX_VALUE);
        this.setWriter(fileWriter);
        this.position(this.header.getHeaderLength());
    }

    public void write() {
        ImgFileWriter writer = this.getWriter();
        this.writeDescription(writer);
        SectionWriter subWriter = this.header.makeSectionWriter(writer);
        subWriter.position(this.sort.isMulti() ? 92L : 52L);
        this.writeSrt4Chars(subWriter);
        this.writeSrt5Expansions(subWriter);
        if (this.sort.isMulti()) {
            for (int i = 0; i <= this.sort.getMaxPage(); ++i) {
                this.srt8Starts.add(-1);
            }
            this.writeSrt8(subWriter);
            this.writeSrt7(subWriter);
        }
        subWriter.close();
        writer.position(this.header.getHeaderLength());
        this.header.writeHeader2(writer);
        writer.position(this.header.getHeaderLength() + this.description.length() + 1 + 16);
        this.header.writeHeader3(writer);
        this.header.writeHeader(writer);
    }

    private void writeDescription(ImgFileWriter writer) {
        writer.position(this.header.getHeaderLength() + 16);
        writer.put(this.description.getBytes(Charset.forName("ascii")));
        writer.put((byte)0);
        this.header.endDescription(writer.position());
    }

    private void writeSrt4Chars(ImgFileWriter writer) {
        for (int i = 1; i < 256; ++i) {
            writer.put(this.sort.getFlags(i));
            this.writeWeights(writer, i);
        }
        this.header.endCharTable(writer.position());
    }

    private void writeWeights(ImgFileWriter writer, int i) {
        if (this.isMulti) {
            writer.putChar((char)this.sort.getPrimary(i));
            writer.put((byte)this.sort.getSecondary(i));
            writer.put((byte)this.sort.getTertiary(i));
        } else {
            writer.put((byte)this.sort.getPrimary(i));
            writer.put((byte)(this.sort.getTertiary(i) << 4 | this.sort.getSecondary(i) & 0xF));
        }
    }

    private void writeSrt5Expansions(ImgFileWriter writer) {
        int size = this.sort.getExpansionSize();
        for (int j = 1; j <= size; ++j) {
            CodePosition b = this.sort.getExpansion(j);
            if (this.isMulti) {
                writer.putChar(b.getPrimary());
                writer.put(b.getSecondary());
                writer.put(b.getTertiary());
                continue;
            }
            writer.put((byte)b.getPrimary());
            writer.put((byte)(b.getTertiary() << 4 | b.getSecondary() & 0xF));
        }
        this.header.endTab2(writer.position());
    }

    private void writeSrt7(SectionWriter writer) {
        assert (this.sort.isMulti());
        for (int i = 1; i <= this.sort.getMaxPage(); ++i) {
            writer.putInt(this.srt8Starts.get(i));
        }
        this.header.endSrt7(writer.position());
    }

    private void writeSrt8(SectionWriter writer) {
        assert (this.sort.isMulti());
        int offset = 0;
        for (int p = 1; p <= this.sort.getMaxPage(); ++p) {
            if (!this.sort.hasPage(p)) continue;
            this.srt8Starts.set(p, offset);
            for (int j = 0; j < 256; ++j) {
                int ch = p * 256 + j;
                writer.put(this.sort.getFlags(ch));
                this.writeWeights(writer, ch);
                offset += 5;
            }
        }
        this.header.endSrt8(writer.position());
    }

    public void setSort(Sort sort) {
        this.sort = sort;
        this.header.setSort(sort);
        this.description = sort.getDescription();
        this.isMulti = sort.isMulti();
    }
}

