/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.CoordNode;
import uk.me.parabola.imgfmt.app.net.GeneralRouteRestriction;
import uk.me.parabola.imgfmt.app.net.NOD1Part;
import uk.me.parabola.imgfmt.app.net.RoadDef;
import uk.me.parabola.imgfmt.app.net.RouteArc;
import uk.me.parabola.imgfmt.app.net.RouteCenter;
import uk.me.parabola.imgfmt.app.net.RouteNode;
import uk.me.parabola.imgfmt.app.net.RouteRestriction;
import uk.me.parabola.log.Logger;
import uk.me.parabola.util.EnhancedProperties;

public class RoadNetwork {
    private static final Logger log = Logger.getLogger(RoadNetwork.class);
    private static final int MAX_RESTRICTIONS_ARCS = 7;
    private final Map<Integer, RouteNode> nodes = new LinkedHashMap<Integer, RouteNode>();
    private final List<RouteNode> boundary = new ArrayList<RouteNode>();
    private final List<RoadDef> roadDefs = new ArrayList<RoadDef>();
    private List<RouteCenter> centers = new ArrayList<RouteCenter>();
    private int adjustTurnHeadings;
    private boolean checkRoundabouts;
    private boolean checkRoundaboutFlares;
    private int maxFlareLengthRatio;
    private boolean reportSimilarArcs;

    public void config(EnhancedProperties props) {
        String ath = props.getProperty("adjust-turn-headings");
        if (ath != null) {
            this.adjustTurnHeadings = ath.length() > 0 ? Integer.decode(ath) : 3;
        }
        this.checkRoundabouts = props.getProperty("check-roundabouts", false);
        this.checkRoundaboutFlares = props.getProperty("check-roundabout-flares", false);
        this.maxFlareLengthRatio = props.getProperty("max-flare-length-ratio", 0);
        this.reportSimilarArcs = props.getProperty("report-similar-arcs", false);
    }

    public void addRoad(RoadDef roadDef, List<Coord> coordList) {
        this.roadDefs.add(roadDef);
        CoordNode lastCoord = null;
        int lastIndex = 0;
        double roadLength = 0.0;
        double arcLength = 0.0;
        int pointsHash = 0;
        int npoints = coordList.size();
        for (int index = 0; index < npoints; ++index) {
            Coord co = coordList.get(index);
            if (index > 0) {
                double d = co.distance(coordList.get(index - 1));
                arcLength += d;
                roadLength += d;
            }
            int id = co.getId();
            pointsHash += co.hashCode();
            if (id == 0) continue;
            if (lastCoord != null) {
                double reverseFinalBearing;
                double forwardFinalBearing;
                double reverseDirectBearing;
                double directLength;
                Coord reverseBearingPoint;
                RouteNode node2;
                RouteNode node1;
                int lastId = lastCoord.getId();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("lastId = " + lastId + " curId = " + id));
                    log.debug((Object)("from " + lastCoord.toDegreeString() + " to " + co.toDegreeString()));
                    log.debug((Object)("arclength=" + arcLength + " roadlength=" + roadLength));
                }
                if ((node1 = this.getOrAddNode(lastId, lastCoord)) == (node2 = this.getOrAddNode(id, co))) {
                    log.error((Object)("Road " + roadDef + " contains consecutive identical nodes at " + co.toOSMURL() + " - routing will be broken"));
                } else if (arcLength == 0.0) {
                    log.warn((Object)("Road " + roadDef + " contains zero length arc at " + co.toOSMURL()));
                }
                Coord forwardBearingPoint = coordList.get(lastIndex + 1);
                if (lastCoord.equals(forwardBearingPoint)) {
                    for (int bi = lastIndex + 2; bi <= index; ++bi) {
                        if (lastCoord.equals(coordList.get(bi))) continue;
                        forwardBearingPoint = coordList.get(bi);
                        break;
                    }
                }
                if (co.equals(reverseBearingPoint = coordList.get(index - 1))) {
                    for (int bi = index - 2; bi > lastIndex; --bi) {
                        if (co.equals(coordList.get(bi))) continue;
                        reverseBearingPoint = coordList.get(bi);
                        break;
                    }
                }
                double forwardInitialBearing = lastCoord.bearingTo(forwardBearingPoint);
                double forwardDirectBearing = co == forwardBearingPoint ? forwardInitialBearing : lastCoord.bearingTo(co);
                double reverseInitialBearing = co.bearingTo(reverseBearingPoint);
                double d = directLength = lastIndex + 1 == index ? arcLength : lastCoord.distance(co);
                if (directLength > 0.0) {
                    reverseDirectBearing = forwardDirectBearing <= 0.0 ? 180.0 + forwardDirectBearing : -(180.0 - forwardDirectBearing) % 180.0;
                    forwardFinalBearing = reverseInitialBearing <= 0.0 ? 180.0 + reverseInitialBearing : -(180.0 - reverseInitialBearing) % 180.0;
                    reverseFinalBearing = forwardInitialBearing <= 0.0 ? 180.0 + forwardInitialBearing : -(180.0 - forwardInitialBearing) % 180.0;
                } else {
                    reverseDirectBearing = 0.0;
                    forwardFinalBearing = 0.0;
                    reverseFinalBearing = 0.0;
                }
                RouteArc arc = new RouteArc(roadDef, node1, node2, forwardInitialBearing, forwardFinalBearing, forwardDirectBearing, arcLength, arcLength, directLength, pointsHash);
                arc.setForward();
                node1.addArc(arc);
                RouteArc reverseArc = new RouteArc(roadDef, node2, node1, reverseInitialBearing, reverseFinalBearing, reverseDirectBearing, arcLength, arcLength, directLength, pointsHash);
                node2.addArc(reverseArc);
                arc.setReverseArc(reverseArc);
                reverseArc.setReverseArc(arc);
            } else {
                roadDef.setNode(this.getOrAddNode(id, co));
            }
            lastCoord = (CoordNode)co;
            lastIndex = index;
            arcLength = 0.0;
            pointsHash = co.hashCode();
        }
        roadDef.setLength(roadLength);
    }

    private RouteNode getOrAddNode(int id, Coord coord) {
        RouteNode node = this.nodes.get(id);
        if (node == null) {
            node = new RouteNode(coord);
            this.nodes.put(id, node);
            if (node.isBoundary()) {
                this.boundary.add(node);
            }
        }
        return node;
    }

    public List<RoadDef> getRoadDefs() {
        return this.roadDefs;
    }

    private void splitCenters() {
        if (this.nodes.isEmpty()) {
            return;
        }
        assert (this.centers.isEmpty()) : "already subdivided into centers";
        ArrayList<RouteNode> nodeList = new ArrayList<RouteNode>(this.nodes.values());
        this.nodes.clear();
        for (int group = 0; group <= 4; ++group) {
            NOD1Part nod1 = new NOD1Part();
            int n = 0;
            for (RouteNode node : nodeList) {
                if (node.getGroup() != group) continue;
                if (!node.isBoundary()) {
                    if (this.checkRoundabouts) {
                        node.checkRoundabouts();
                    }
                    if (this.checkRoundaboutFlares) {
                        node.checkRoundaboutFlares(this.maxFlareLengthRatio);
                    }
                    if (this.reportSimilarArcs) {
                        node.reportSimilarArcs();
                    }
                }
                if (this.adjustTurnHeadings != 0) {
                    node.tweezeArcs(this.adjustTurnHeadings);
                }
                nod1.addNode(node);
                ++n;
            }
            if (n <= 0) continue;
            this.centers.addAll(nod1.subdivide());
        }
    }

    public List<RouteCenter> getCenters() {
        if (this.centers.isEmpty()) {
            this.addArcsToMajorRoads();
            this.splitCenters();
        }
        return this.centers;
    }

    private void addArcsToMajorRoads() {
        long t1 = System.currentTimeMillis();
        for (RoadDef rd : this.roadDefs) {
            if (rd.getRoadClass() < 1) continue;
            rd.getNode().addArcsToMajorRoads(rd);
        }
        log.info((Object)(" added major road arcs in " + (System.currentTimeMillis() - t1) + " ms"));
    }

    public List<RouteNode> getBoundary() {
        return this.boundary;
    }

    public int addRestriction(GeneralRouteRestriction grr) {
        List<RouteArc> fromArcs;
        if (grr.getType() == GeneralRouteRestriction.RestrType.TYPE_NO_TROUGH) {
            return this.addNoThroughRoute(grr);
        }
        String sourceDesc = grr.getSourceDesc();
        ArrayList<RouteNode> viaNodes = new ArrayList<RouteNode>();
        for (CoordNode via : grr.getViaNodes()) {
            RouteNode vn = this.nodes.get(via.getId());
            if (vn == null) {
                log.error(sourceDesc, "can't locate 'via' RouteNode with id", via.getId());
                return 0;
            }
            viaNodes.add(vn);
        }
        int firstViaId = grr.getViaNodes().get(0).getId();
        int lastViaId = grr.getViaNodes().get(grr.getViaNodes().size() - 1).getId();
        RouteNode firstViaNode = this.nodes.get(firstViaId);
        RouteNode lastViaNode = this.nodes.get(lastViaId);
        ArrayList<List<RouteArc>> viaArcsList = new ArrayList<List<RouteArc>>();
        if (grr.getViaNodes().size() != grr.getViaWayIds().size() + 1) {
            log.error(sourceDesc, "internal error: number of via nodes and via ways doesn't fit");
            return 0;
        }
        for (int i = 1; i < grr.getViaNodes().size(); ++i) {
            RouteNode vn = (RouteNode)viaNodes.get(i - 1);
            Long viaWayId = grr.getViaWayIds().get(i - 1);
            List<RouteArc> viaArcs = vn.getDirectArcsTo((RouteNode)viaNodes.get(i), viaWayId);
            if (viaArcs.isEmpty()) {
                log.error(sourceDesc, "can't locate arc from 'via' node at", vn.getCoord().toOSMURL(), "to next 'via' node on way", viaWayId);
                return 0;
            }
            viaArcsList.add(viaArcs);
        }
        int fromId = 0;
        RouteNode fn = null;
        if (grr.getFromNode() != null) {
            fromId = grr.getFromNode().getId();
            fn = this.nodes.get(fromId);
            if (fn == null) {
                log.error(sourceDesc, "can't locate 'from' RouteNode with id", fromId);
                return 0;
            }
        } else {
            List<RouteArc> possibleFromArcs = firstViaNode.getDirectArcsOnWay(grr.getFromWayId());
            for (RouteArc arc : possibleFromArcs) {
                if (fn == null) {
                    fn = arc.getDest();
                    continue;
                }
                if (fn == arc.getDest()) continue;
                log.warn(sourceDesc, "found different 'from' arcs for way", grr.getFromWayId(), "restriction is ignored");
                return 0;
            }
            if (fn == null) {
                log.warn(sourceDesc, "can't locate 'from' RouteNode for 'from' way", grr.getFromWayId());
                return 0;
            }
            fromId = fn.getCoord().getId();
        }
        if ((fromArcs = fn.getDirectArcsTo(firstViaNode, grr.getFromWayId())).isEmpty()) {
            log.error(sourceDesc, "can't locate arc from 'from' node ", fromId, "to 'via' node", firstViaId, "on way", grr.getFromWayId());
            return 0;
        }
        RouteNode uTurnNode = viaNodes.size() > 1 ? (RouteNode)viaNodes.get(viaNodes.size() - 2) : fn;
        long uTurnWay = viaNodes.size() > 1 ? grr.getViaWayIds().get(grr.getViaWayIds().size() - 1).longValue() : grr.getFromWayId();
        RouteNode tn = null;
        int toId = 0;
        List toArcs = new ArrayList();
        if (grr.getToNode() != null) {
            toId = grr.getToNode().getId();
            tn = this.nodes.get(toId);
            if (tn == null) {
                log.error(sourceDesc, "can't locate 'to' RouteNode with id", toId);
                return 0;
            }
        } else {
            List<RouteArc> possibleToArcs = lastViaNode.getDirectArcsOnWay(grr.getToWayId());
            RouteArc fromArc = fromArcs.get(0);
            boolean ignoreAngle = false;
            if ((double)fromArc.getLengthInMeter() <= 1.0E-4) {
                ignoreAngle = true;
            }
            if (grr.getDirIndicator() == '?') {
                ignoreAngle = true;
            }
            log.info(sourceDesc, "found", possibleToArcs.size(), "candidates for to-arc");
            TreeMap<Integer, ArrayList<RouteArc>> treeMap = new TreeMap<Integer, ArrayList<RouteArc>>();
            for (RouteArc arc : possibleToArcs) {
                Integer angle;
                ArrayList<RouteArc> list;
                if ((double)arc.getLengthInMeter() <= 1.0E-4) {
                    ignoreAngle = true;
                }
                if ((list = (ArrayList<RouteArc>)treeMap.get(angle = Integer.valueOf(Math.round(RoadNetwork.getAngle(fromArc, arc))))) == null) {
                    list = new ArrayList<RouteArc>();
                    treeMap.put(angle, list);
                }
                list.add(arc);
            }
            Iterator iter = treeMap.entrySet().iterator();
            Integer bestAngle = null;
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (!ignoreAngle && !RoadNetwork.matchDirectionInfo(((Integer)entry.getKey()).intValue(), grr.getDirIndicator())) continue;
                if (bestAngle == null) {
                    bestAngle = (Integer)entry.getKey();
                    continue;
                }
                bestAngle = RoadNetwork.getBetterAngle(bestAngle, (Integer)entry.getKey(), grr.getDirIndicator());
            }
            if (bestAngle == null) {
                log.warn(sourceDesc, "the angle of the from and to way don't match the restriction");
                return 0;
            }
            toArcs = (List)treeMap.get(bestAngle);
        }
        if (toArcs.isEmpty()) {
            log.error(sourceDesc, "can't locate arc from 'via' node ", lastViaId, "to 'to' node", toId, "on way", grr.getToWayId());
            return 0;
        }
        ArrayList<RouteArc> badArcs = new ArrayList<RouteArc>();
        if (grr.getType() == GeneralRouteRestriction.RestrType.TYPE_NOT) {
            for (RouteArc toArc : toArcs) {
                badArcs.add(toArc);
            }
        } else if (grr.getType() == GeneralRouteRestriction.RestrType.TYPE_ONLY) {
            int uTurns = 0;
            for (RouteArc routeArc : lastViaNode.arcsIteration()) {
                if (!routeArc.isDirect() || toArcs.contains(routeArc)) continue;
                if (routeArc.getDest() == uTurnNode && routeArc.getRoadDef().getId() == uTurnWay) {
                    ++uTurns;
                    continue;
                }
                badArcs.add(routeArc);
            }
            if (badArcs.isEmpty()) {
                if (uTurns > 0) {
                    log.warn(sourceDesc, "restriction ignored because it forbids only u-turn");
                } else {
                    log.warn(sourceDesc, "restriction ignored because it has no effect");
                }
                return 0;
            }
        }
        ArrayList<List<RouteArc>> arcLists = new ArrayList<List<RouteArc>>();
        arcLists.add(fromArcs);
        arcLists.addAll(viaArcsList);
        arcLists.add(badArcs);
        if (arcLists.size() > 7) {
            log.warn(sourceDesc, "has more than", 7, "arcs, this is not supported");
            return 0;
        }
        for (int i = 0; i < arcLists.size(); ++i) {
            List list = (List)arcLists.get(i);
            int countNoEffect = 0;
            int countOneway = 0;
            for (int j = list.size() - 1; j >= 0; --j) {
                RouteArc arc = (RouteArc)list.get(j);
                if (!RoadNetwork.isUsable(arc.getRoadDef().getAccess(), grr.getExceptionMask())) {
                    ++countNoEffect;
                    list.remove(j);
                    continue;
                }
                if (!arc.getRoadDef().isOneway() || arc.isForward()) continue;
                ++countOneway;
                list.remove(j);
            }
            String arcType = null;
            if (!list.isEmpty()) continue;
            arcType = i == 0 ? "from way is" : (i == arcLists.size() - 1 ? (grr.getType() == GeneralRouteRestriction.RestrType.TYPE_ONLY ? "all possible other ways are" : "to way is") : "via way is");
            String reason = countNoEffect > 0 & countOneway > 0 ? "wrong direction in oneway or not accessible for restricted vehicles" : (countNoEffect > 0 ? "not accessible for restricted vehicles" : "wrong direction in oneway");
            log.warn(sourceDesc, "restriction ignored because", arcType, reason);
            return 0;
        }
        if (viaNodes.contains(fn)) {
            log.warn(sourceDesc, "restriction not written because from node appears also as via node");
            return 0;
        }
        int numCombis = 1;
        int[] nArray = new int[arcLists.size()];
        for (int i = 0; i < nArray.length; ++i) {
            List arcs = (List)arcLists.get(i);
            numCombis *= arcs.size();
        }
        ArrayList<RouteArc> path = new ArrayList<RouteArc>();
        int added = 0;
        for (int i = 0; i < numCombis; ++i) {
            for (RouteNode vn : viaNodes) {
                path.clear();
                boolean viaNodeFound = false;
                int pathNoAccessMask = 0;
                for (int j = 0; j < nArray.length; ++j) {
                    RouteArc arc = (RouteArc)((List)arcLists.get(j)).get(nArray[j]);
                    if (arc.getDest() == vn || !viaNodeFound) {
                        arc = arc.getReverseArc();
                    }
                    if (arc.getSource() == vn) {
                        viaNodeFound = true;
                    }
                    if (arc.getDest() == vn) {
                        if (added > 0) {
                            log.error(sourceDesc, "restriction incompletely written because dest in arc is via node");
                        } else {
                            log.warn(sourceDesc, "restriction not written because dest in arc is via node");
                        }
                        return added;
                    }
                    pathNoAccessMask = (byte)(pathNoAccessMask | ~arc.getRoadDef().getAccess());
                    path.add(arc);
                }
                byte pathAccessMask = (byte)(~pathNoAccessMask);
                if (!RoadNetwork.isUsable(pathAccessMask, grr.getExceptionMask())) continue;
                vn.addRestriction(new RouteRestriction(vn, path, grr.getExceptionMask()));
                ++added;
            }
            int n = nArray.length - 1;
            nArray[n] = nArray[n] + 1;
            for (int j = nArray.length - 1; j > 0; --j) {
                if (nArray[j] < ((List)arcLists.get(j)).size()) continue;
                nArray[j] = 0;
                int n2 = j - 1;
                nArray[n2] = nArray[n2] + 1;
            }
        }
        if (nArray[0] != ((List)arcLists.get(0)).size()) {
            log.error(sourceDesc, " failed to generate all possible paths");
        }
        log.info(sourceDesc, "added", added, "route restriction(s) to img file");
        return added;
    }

    private static boolean isUsable(byte roadAccess, byte exceptionMask) {
        return (roadAccess & (byte)(~exceptionMask)) != 0;
    }

    private int addNoThroughRoute(GeneralRouteRestriction grr) {
        assert (grr.getViaNodes() != null);
        assert (grr.getViaNodes().size() == 1);
        int viaId = grr.getViaNodes().get(0).getId();
        RouteNode vn = this.nodes.get(viaId);
        if (vn == null) {
            log.error(grr.getSourceDesc(), "can't locate 'via' RouteNode with id", viaId);
            return 0;
        }
        int added = 0;
        for (RouteArc routeArc : vn.arcsIteration()) {
            if (!routeArc.isDirect()) continue;
            for (RouteArc routeArc2 : vn.arcsIteration()) {
                if (!routeArc2.isDirect() || routeArc2 == routeArc || routeArc2.getDest() == routeArc.getDest()) continue;
                byte pathAccessMask = (byte)(routeArc.getRoadDef().getAccess() & routeArc2.getRoadDef().getAccess());
                if (RoadNetwork.isUsable(pathAccessMask, grr.getExceptionMask())) {
                    vn.addRestriction(new RouteRestriction(vn, Arrays.asList(routeArc2, routeArc), grr.getExceptionMask()));
                    ++added;
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug(grr.getSourceDesc(), "ignored no-through-route", routeArc2, "to", routeArc);
            }
        }
        return added;
    }

    public void addThroughRoute(int junctionNodeId, long roadIdA, long roadIdB) {
        RouteNode node = this.nodes.get(junctionNodeId);
        assert (node != null) : "Can't find node with id " + junctionNodeId;
        node.addThroughRoute(roadIdA, roadIdB);
    }

    private static float getAngle(RouteArc fromArc, RouteArc toArc) {
        float angle;
        float headingFrom = fromArc.getFinalHeading();
        float headingTo = toArc.getInitialHeading();
        for (angle = headingTo - headingFrom; angle > 180.0f; angle -= 360.0f) {
        }
        while (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    private static Integer getBetterAngle(Integer angle1, Integer angle2, char dirIndicator) {
        switch (dirIndicator) {
            case 'l': {
                if (Math.abs(-90 - angle2) >= Math.abs(-90 - angle1)) break;
                return angle2;
            }
            case 'r': {
                if (Math.abs(90 - angle2) >= Math.abs(90 - angle1)) break;
                return angle2;
            }
            case 'u': {
                double d2;
                double d1 = angle1 < 0 ? (double)(-180 - angle1) : (double)(180 - angle1);
                double d = d2 = angle2 < 0 ? (double)(-180 - angle2) : (double)(180 - angle2);
                if (!(Math.abs(d2) < Math.abs(d1))) break;
                return angle2;
            }
            case 's': {
                if (Math.abs(angle2) >= Math.abs(angle1)) break;
                return angle2;
            }
        }
        return angle1;
    }

    private static boolean matchDirectionInfo(float angle, char dirIndicator) {
        switch (dirIndicator) {
            case 'l': {
                if (!(angle < -3.0f) || !(angle > -177.0f)) break;
                return true;
            }
            case 'r': {
                if (!(angle > 3.0f) || !(angle < 177.0f)) break;
                return true;
            }
            case 'u': {
                if (!(angle < -87.0f) && !(angle > 93.0f)) break;
                return true;
            }
            case 's': {
                if (!(angle > -87.0f) || !(angle < 87.0f)) break;
                return true;
            }
            case '?': {
                return true;
            }
        }
        return false;
    }
}

