/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.app.BitWriter;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Label;
import uk.me.parabola.imgfmt.app.lbl.City;
import uk.me.parabola.imgfmt.app.lbl.Zip;
import uk.me.parabola.imgfmt.app.net.NODHeader;
import uk.me.parabola.imgfmt.app.net.NumberPreparer;
import uk.me.parabola.imgfmt.app.net.Numbers;
import uk.me.parabola.imgfmt.app.net.RoadIndex;
import uk.me.parabola.imgfmt.app.net.RouteNode;
import uk.me.parabola.imgfmt.app.trergn.Polyline;
import uk.me.parabola.log.Logger;

public class RoadDef {
    private static final Logger log = Logger.getLogger(RoadDef.class);
    public static final int NET_FLAG_NODINFO = 64;
    public static final int NET_FLAG_ADDRINFO = 16;
    private static final int NET_FLAG_UNK1 = 4;
    private static final int NET_FLAG_ONEWAY = 2;
    private static final int NOD2_FLAG_UNK = 1;
    private static final int TABA_FLAG_TOLL = 128;
    private static final int TABA_FLAG_ONEWAY = 8;
    private static final int TABAACCESS_FLAG_CARPOOL = 8;
    private static final int TABAACCESS_FLAG_NOTHROUGHROUTE = 128;
    private static final int TABAACCESS_FLAG_NO_EMERGENCY = 32768;
    private static final int TABAACCESS_FLAG_NO_DELIVERY = 16384;
    private static final int TABAACCESS_FLAG_NO_CAR = 1;
    private static final int TABAACCESS_FLAG_NO_BUS = 2;
    private static final int TABAACCESS_FLAG_NO_TAXI = 4;
    private static final int TABAACCESS_FLAG_NO_FOOT = 16;
    private static final int TABAACCESS_FLAG_NO_BIKE = 32;
    private static final int TABAACCESS_FLAG_NO_TRUCK = 64;
    private int offsetNod2;
    private int offsetNet1;
    private int netFlags = 4;
    private byte mkgmapAccess;
    private int roadLength;
    private static final int MAX_LABELS = 4;
    private final Label[] labels = new Label[4];
    private int numlabels;
    private final SortedMap<Integer, List<RoadIndex>> roadIndexes = new TreeMap<Integer, List<RoadIndex>>();
    private City city;
    private Zip zip;
    private boolean paved = true;
    private boolean ferry;
    private boolean roundabout;
    private boolean linkRoad;
    private boolean synthesised;
    private boolean flareCheck;
    private Set<String> messageIssued;
    private final List<Offset> rgnOffsets = new ArrayList<Offset>();
    private RouteNode node;
    private boolean startsWithNode = true;
    private int nnodes;
    private int nod2Flags = 1;
    private int tabAInfo;
    private int tabAAccess;
    private final long id;
    private final String name;
    private List<Numbers> numbersList;
    private int nodeCount;
    private boolean internalNodes = true;
    private int roadClass = -1;

    public RoadDef(long id, String name) {
        this.id = id;
        this.name = name;
    }

    public RoadDef(long id, int net1offset, String name) {
        this.id = id;
        this.offsetNet1 = net1offset;
        this.name = name;
    }

    public String toString() {
        String browseURL = "http://www.openstreetmap.org/browse/way/" + this.id;
        return "(" + browseURL + ")";
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.labels[0] != null) {
            return this.labels[0].toString();
        }
        return null;
    }

    public long getId() {
        return this.id;
    }

    void writeNet1(ImgFileWriter writer, int numCities, int numZips) {
        if (this.numlabels == 0) {
            return;
        }
        assert (this.numlabels > 0);
        this.offsetNet1 = writer.position();
        NumberPreparer numbers = null;
        if (this.numbersList != null) {
            numbers = new NumberPreparer(this.numbersList);
            numbers.fetchBitStream();
            if (!numbers.isValid()) {
                numbers = null;
                log.warn("Invalid housenumbers in", this.toString());
            }
        }
        this.writeLabels(writer);
        if (numbers != null && numbers.getSwapped()) {
            this.netFlags |= 0x20;
        }
        writer.put((byte)this.netFlags);
        writer.put3(this.roadLength);
        int maxlevel = this.writeLevelCount(writer);
        this.writeLevelDivs(writer, maxlevel);
        if ((this.netFlags & 0x10) != 0) {
            --this.nodeCount;
            writer.put((byte)(this.nodeCount & 0xFF));
            int code = 232;
            code |= this.nodeCount >> 8 & 3;
            if (this.city == null) {
                code |= 0x10;
            }
            if (this.zip == null) {
                code |= 4;
            }
            if (numbers != null) {
                code &= 0xFFFFFF3F;
                if (numbers.fetchBitStream().getLength() > 255) {
                    code |= 0x40;
                }
            }
            writer.put((byte)code);
            if (this.zip != null) {
                char zipIndex = (char)this.zip.getIndex();
                if (numZips > 255) {
                    writer.putChar(zipIndex);
                } else {
                    writer.put((byte)zipIndex);
                }
            }
            if (this.city != null) {
                char cityIndex = (char)this.city.getIndex();
                if (numCities > 255) {
                    writer.putChar(cityIndex);
                } else {
                    writer.put((byte)cityIndex);
                }
            }
            if (numbers != null) {
                BitWriter bw = numbers.fetchBitStream();
                if (bw.getLength() > 255) {
                    writer.putChar((char)bw.getLength());
                } else {
                    writer.put((byte)bw.getLength());
                }
                writer.put(bw.getBytes(), 0, bw.getLength());
            }
        }
        if (this.hasNodInfo()) {
            int val = this.offsetNod2;
            if (val < Short.MAX_VALUE) {
                writer.put((byte)1);
                writer.putChar((char)val);
            } else {
                writer.put((byte)2);
                writer.put3(val);
            }
        }
    }

    private void writeLabels(ImgFileWriter writer) {
        for (int i = 0; i < this.numlabels; ++i) {
            Label l = this.labels[i];
            int ptr = l.getOffset();
            if (i == this.numlabels - 1) {
                ptr |= 0x800000;
            }
            writer.put3(ptr);
        }
    }

    public void putSortedRoadEntry(ImgFileWriter writer, Label label) {
        for (int i = 0; i < this.labels.length && this.labels[i] != null; ++i) {
            if (!this.labels[i].equals(label)) continue;
            writer.put3(i << 22 | this.offsetNet1);
            return;
        }
    }

    private int writeLevelCount(ImgFileWriter writer) {
        int maxlevel = this.getMaxZoomLevel();
        for (int i = 0; i <= maxlevel; ++i) {
            int b;
            List l = (List)this.roadIndexes.get(i);
            int n = b = l == null ? 0 : l.size();
            assert (b < 128) : "too many polylines at level " + i;
            if (i == maxlevel) {
                b |= 0x80;
            }
            writer.put((byte)b);
        }
        return maxlevel;
    }

    private void writeLevelDivs(ImgFileWriter writer, int maxlevel) {
        for (int i = 0; i <= maxlevel; ++i) {
            List l = (List)this.roadIndexes.get(i);
            if (l == null) continue;
            for (RoadIndex ri : l) {
                ri.write(writer);
            }
        }
    }

    public void addLabel(Label l) {
        int i;
        for (i = 0; i < 4 && this.labels[i] != null; ++i) {
            if (!l.equals(this.labels[i])) continue;
            return;
        }
        if (i < 4) {
            this.labels[i] = l;
            ++this.numlabels;
        } else {
            log.warn((Object)(this.toString() + " discarding extra label (already have " + 4 + ")"));
        }
    }

    public Label[] getLabels() {
        return this.labels;
    }

    public void addPolylineRef(Polyline pl) {
        int level;
        ArrayList<RoadIndex> l;
        if (log.isDebugEnabled()) {
            log.debug("adding polyline ref", this, pl.getSubdiv());
        }
        if ((l = (ArrayList<RoadIndex>)this.roadIndexes.get(level = pl.getSubdiv().getZoom().getLevel())) == null) {
            l = new ArrayList<RoadIndex>();
            this.roadIndexes.put(level, l);
        }
        l.add(new RoadIndex(pl));
        if (level == 0) {
            this.nodeCount += pl.getNodeCount();
        }
    }

    private int getMaxZoomLevel() {
        return this.roadIndexes.lastKey();
    }

    public boolean connectedTo(RoadDef other) {
        List l = (List)this.roadIndexes.get(0);
        if (l == null) {
            return false;
        }
        List ol = (List)other.roadIndexes.get(0);
        if (ol == null) {
            return false;
        }
        for (RoadIndex ri : l) {
            for (RoadIndex ori : ol) {
                if (!ri.getLine().sharesNodeWith(ori.getLine())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean sameDiv(RoadDef other) {
        return this.getStartSubdivNumber() == other.getStartSubdivNumber();
    }

    public int getStartSubdivNumber() {
        Integer key = this.roadIndexes.firstKey();
        return ((RoadIndex)((List)this.roadIndexes.get(key)).get(0)).getLine().getSubdiv().getNumber();
    }

    public void setLength(double lenInMeter) {
        this.roadLength = NODHeader.metersToRaw(lenInMeter);
    }

    public boolean hasHouseNumbers() {
        return this.numbersList != null && !this.numbersList.isEmpty();
    }

    public void addOffsetTarget(int position, int flags) {
        this.rgnOffsets.add(new Offset(position, flags));
    }

    void writeRgnOffsets(ImgFileWriter rgn) {
        if (this.offsetNet1 >= 0x400000) {
            throw new MapFailedException("Overflow of the NET1. The tile (" + log.threadTag() + ") must be split so that there are fewer roads in it");
        }
        for (Offset off : this.rgnOffsets) {
            rgn.position(off.getPosition());
            rgn.put3(this.offsetNet1 | off.getFlags());
        }
    }

    public boolean hasInternalNodes() {
        return this.internalNodes;
    }

    public void setInternalNodes(boolean n) {
        this.internalNodes = n;
    }

    public void setNode(RouteNode node) {
        this.netFlags |= 0x40;
        this.node = node;
    }

    public RouteNode getNode() {
        return this.node;
    }

    private boolean hasNodInfo() {
        return (this.netFlags & 0x40) != 0;
    }

    public void setStartsWithNode(boolean s) {
        this.startsWithNode = s;
    }

    public void setNumNodes(int n) {
        this.nnodes = n;
    }

    public void setNumbersList(List<Numbers> numbersList) {
        if (numbersList != null && !numbersList.isEmpty()) {
            this.numbersList = numbersList;
            this.netFlags |= 0x10;
        }
    }

    public void writeNod2(ImgFileWriter writer) {
        int i;
        if (!this.hasNodInfo()) {
            return;
        }
        log.debug((Object)"writing nod2");
        this.offsetNod2 = writer.position();
        writer.put((byte)this.nod2Flags);
        writer.put3(this.node.getOffsetNod1());
        int nbits = this.nnodes;
        if (!this.startsWithNode) {
            ++nbits;
        }
        writer.putChar((char)nbits);
        boolean[] bits = new boolean[nbits];
        for (i = 0; i < bits.length; ++i) {
            bits[i] = true;
        }
        if (!this.startsWithNode) {
            bits[0] = false;
        }
        for (i = 0; i < bits.length; i += 8) {
            int b = 0;
            for (int j = 0; j < 8 && j < bits.length - i; ++j) {
                if (!bits[i + j]) continue;
                b |= 1 << j;
            }
            writer.put((byte)b);
        }
    }

    public int getOffsetNet1() {
        return this.offsetNet1;
    }

    public void setToll() {
        this.tabAInfo |= 0x80;
    }

    public void setCarpoolLane() {
        this.tabAAccess |= 8;
    }

    public void setNoThroughRouting() {
        this.tabAAccess |= 0x80;
    }

    public byte getAccess() {
        return this.mkgmapAccess;
    }

    public void setAccess(byte mkgmapAccess) {
        this.mkgmapAccess = mkgmapAccess;
        this.tabAAccess &= 0xFFFF3F88;
        if (mkgmapAccess == -1) {
            return;
        }
        if ((mkgmapAccess & 1) == 0) {
            this.tabAAccess |= 0x10;
        }
        if ((mkgmapAccess & 2) == 0) {
            this.tabAAccess |= 0x20;
        }
        if ((mkgmapAccess & 4) == 0) {
            this.tabAAccess |= 1;
        }
        if ((mkgmapAccess & 8) == 0) {
            this.tabAAccess |= 0x4000;
        }
        if ((mkgmapAccess & 0x10) == 0) {
            this.tabAAccess |= 0x40;
        }
        if ((mkgmapAccess & 0x20) == 0) {
            this.tabAAccess |= 2;
        }
        if ((mkgmapAccess & 0x40) == 0) {
            this.tabAAccess |= 4;
        }
        if ((mkgmapAccess & 0xFFFFFF80) == 0) {
            this.tabAAccess |= 0x8000;
        }
    }

    public int getTabAInfo() {
        return this.tabAInfo;
    }

    public int getTabAAccess() {
        return this.tabAAccess;
    }

    public void setRoadClass(int roadClass) {
        assert (roadClass < 8);
        this.roadClass = roadClass;
        int shifted = roadClass << 4 & 0xFF;
        this.tabAInfo |= shifted;
        this.nod2Flags |= shifted;
    }

    public int getRoadClass() {
        assert (this.roadClass >= 0) : "roadClass not set";
        return this.roadClass;
    }

    public void setSpeed(int speed) {
        assert (speed < 8);
        this.tabAInfo |= speed;
        this.nod2Flags |= speed << 1;
    }

    public int getRoadSpeed() {
        return this.tabAInfo & 7;
    }

    public void setOneway() {
        this.tabAInfo |= 8;
        this.netFlags |= 2;
    }

    public boolean isOneway() {
        return (this.netFlags & 2) != 0;
    }

    public void setCity(City city) {
        this.city = city;
        this.netFlags |= 0x10;
    }

    public void setZip(Zip zip) {
        this.zip = zip;
        this.netFlags |= 0x10;
    }

    public City getCity() {
        return this.city;
    }

    public boolean paved() {
        return this.paved;
    }

    public void paved(boolean p) {
        this.paved = p;
    }

    public void ferry(boolean f) {
        this.ferry = f;
    }

    public boolean ferry() {
        return this.ferry;
    }

    public void setRoundabout(boolean r) {
        this.roundabout = r;
    }

    public boolean isRoundabout() {
        return this.roundabout;
    }

    public void setLinkRoad(boolean lr) {
        this.linkRoad = lr;
    }

    public boolean isLinkRoad() {
        return this.linkRoad;
    }

    public void setSynthesised(boolean s) {
        this.synthesised = s;
    }

    public boolean isSynthesised() {
        return this.synthesised;
    }

    public void doFlareCheck(boolean fc) {
        this.flareCheck = fc;
    }

    public boolean doFlareCheck() {
        return this.flareCheck;
    }

    public boolean messagePreviouslyIssued(String key) {
        if (this.messageIssued == null) {
            this.messageIssued = new HashSet<String>();
        }
        boolean previouslyIssued = this.messageIssued.contains(key);
        this.messageIssued.add(key);
        return previouslyIssued;
    }

    class Offset {
        final int position;
        final int flags;

        Offset(int position, int flags) {
            this.position = position;
            this.flags = flags;
        }

        int getPosition() {
            return this.position;
        }

        int getFlags() {
            return this.flags;
        }
    }
}

