/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import java.util.Arrays;
import uk.me.parabola.imgfmt.ReadFailedException;
import uk.me.parabola.imgfmt.app.CommonHeader;
import uk.me.parabola.imgfmt.app.ImgFileReader;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Section;

public class NODHeader
extends CommonHeader {
    public static final int HEADER_LEN = 127;
    static final char DEF_ALIGN = '\u0006';
    private static final char BOUNDARY_ITEM_SIZE = '\t';
    private final Section nodes = new Section();
    private final Section roads = new Section(this.nodes);
    private final Section boundary = new Section(this.roads, '\t');
    private final Section highClassBoundary = new Section(this.boundary);
    private final int[] classBoundaries = new int[5];
    private int flags;
    private int align;
    private int mult1;
    private int tableARecordLen;
    private boolean driveOnLeft;
    static final int DISTANCE_MULT_SHIFT = 1;
    static final int DISTANCE_MULT = 2;
    private static final double UNIT_TO_METER = 2.4;

    public NODHeader() {
        super(127, "GARMIN NOD");
        Arrays.fill(this.classBoundaries, Integer.MAX_VALUE);
    }

    @Override
    protected void readFileHeader(ImgFileReader reader) throws ReadFailedException {
        this.nodes.readSectionInfo(reader, false);
        this.flags = reader.getChar();
        reader.getChar();
        this.align = reader.get();
        this.mult1 = reader.get();
        this.tableARecordLen = reader.getChar();
        this.roads.readSectionInfo(reader, false);
        reader.getInt();
        this.boundary.readSectionInfo(reader, true);
        reader.getInt();
        if (this.getHeaderLength() > 63) {
            this.highClassBoundary.readSectionInfo(reader, false);
            this.classBoundaries[0] = reader.getInt();
            this.classBoundaries[1] = this.classBoundaries[0] + reader.getInt();
            this.classBoundaries[2] = this.classBoundaries[1] + reader.getInt();
            this.classBoundaries[3] = this.classBoundaries[2] + reader.getInt();
            this.classBoundaries[4] = this.classBoundaries[3] + reader.getInt();
        }
    }

    @Override
    protected void writeFileHeader(ImgFileWriter writer) {
        this.nodes.setPosition(127);
        this.nodes.writeSectionInfo(writer);
        int flags = 519;
        assert (Integer.bitCount(2) == 1);
        flags |= 0x20;
        if (this.driveOnLeft) {
            flags |= 0x100;
        }
        writer.putInt(flags);
        byte align = 6;
        writer.put(align);
        writer.put((byte)0);
        writer.putChar('\u0005');
        this.roads.writeSectionInfo(writer);
        writer.putInt(0);
        this.boundary.writeSectionInfo(writer);
        writer.putInt(2);
        this.highClassBoundary.writeSectionInfo(writer);
        writer.putInt(this.classBoundaries[0]);
        for (int i = 1; i < this.classBoundaries.length; ++i) {
            writer.putInt(this.classBoundaries[i] - this.classBoundaries[i - 1]);
        }
    }

    public static int metersToRaw(double m) {
        double d = m / 4.8;
        return (int)Math.round(d);
    }

    public int getNodeStart() {
        return this.nodes.getPosition();
    }

    public void setNodeStart(int start) {
        this.nodes.setPosition(start);
    }

    public int getNodeSize() {
        return this.nodes.getSize();
    }

    public void setNodeSize(int size) {
        this.nodes.setSize(size);
    }

    public Section getNodeSection() {
        return this.nodes;
    }

    public void setRoadSize(int size) {
        this.roads.setSize(size);
    }

    public Section getRoadSection() {
        return this.roads;
    }

    public void setBoundarySize(int size) {
        this.boundary.setSize(size);
    }

    public Section getBoundarySection() {
        return this.boundary;
    }

    public void setHighClassBoundarySize(int size) {
        this.highClassBoundary.setSize(size);
    }

    public Section getHighClassBoundary() {
        return this.highClassBoundary;
    }

    public int[] getClassBoundaries() {
        return this.classBoundaries;
    }

    public void setDriveOnLeft(boolean dol) {
        this.driveOnLeft = dol;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getAlign() {
        return this.align;
    }

    public int getMult1() {
        return this.mult1;
    }

    public int getTableARecordLen() {
        return this.tableARecordLen;
    }
}

