/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.net.RouteArc;
import uk.me.parabola.imgfmt.app.net.RouteCenter;
import uk.me.parabola.imgfmt.app.net.RouteNode;
import uk.me.parabola.imgfmt.app.net.RouteRestriction;
import uk.me.parabola.imgfmt.app.net.TableA;
import uk.me.parabola.imgfmt.app.net.TableB;
import uk.me.parabola.log.Logger;

public class NOD1Part {
    private static final Logger log = Logger.getLogger(NOD1Part.class);
    private static final int MAX_SIZE_UNSAFE = 65536;
    private static final int MAX_SIZE = 63488;
    private static final int MAX_TABA_UNSAFE = 256;
    private static final int MAX_TABA = 248;
    private static final int MAX_TABB_UNSAFE = 256;
    private static final int MAX_TABB = 254;
    private static final int MAX_NODES_SIZE = 8192;
    private int nodesSize;
    private final BBox bbox;
    private final BBox bboxActual = new BBox();
    private List<RouteNode> nodes = new ArrayList<RouteNode>();
    private TableA tabA = new TableA();
    private Map<RouteNode, RouteNode> destNodes = new LinkedHashMap<RouteNode, RouteNode>();

    public NOD1Part() {
        log.info((Object)"creating new unbounded NOD1Part");
        this.bbox = null;
    }

    private NOD1Part(BBox bbox) {
        log.info("creating new NOD1Part:", bbox);
        this.bbox = bbox;
    }

    public void addNode(RouteNode node) {
        assert (this.bbox == null || this.bbox.contains(node.getCoord())) : "trying to add out-of-bounds node: " + node;
        this.bboxActual.extend(node.getCoord());
        this.nodes.add(node);
        for (RouteArc routeArc : node.arcsIteration()) {
            this.tabA.addArc(routeArc);
            RouteNode dest = routeArc.getDest();
            if (!routeArc.isInternal()) {
                this.destNodes.put(dest, dest);
                continue;
            }
            if ((this.bbox == null || this.bbox.contains(dest.getCoord())) && dest.getGroup() == node.getGroup()) continue;
            routeArc.setInternal(false);
            this.destNodes.put(dest, dest);
        }
        for (RouteRestriction routeRestriction : node.getRestrictions()) {
            List<RouteArc> arcs = routeRestriction.getArcs();
            if (arcs.size() < 3) continue;
            for (int i = 0; i < arcs.size(); ++i) {
                RouteArc arc = arcs.get(i);
                if (arc.getSource() == node) continue;
                this.tabA.addArc(arc);
                RouteNode dest = arc.getDest();
                if (!arc.isInternal()) {
                    this.destNodes.put(dest, dest);
                    continue;
                }
                if ((this.bbox == null || this.bbox.contains(dest.getCoord())) && dest.getGroup() == node.getGroup()) continue;
                arc.setInternal(false);
                this.destNodes.put(dest, dest);
            }
        }
        this.nodesSize += node.boundSize();
    }

    public List<RouteCenter> subdivide() {
        return this.subdivideHelper(0);
    }

    protected List<RouteCenter> subdivideHelper(int depth) {
        LinkedList<RouteCenter> centers = new LinkedList<RouteCenter>();
        if (this.satisfiesConstraints()) {
            centers.add(this.toRouteCenter());
            return centers;
        }
        if (depth > 48) {
            log.error((Object)("Region contains too many nodes/arcs (discarding " + this.nodes.size() + " nodes to be able to continue)"));
            log.error((Object)("  Expect the routing to be broken near " + this.bbox));
            for (RouteNode node : this.nodes) {
                node.discard();
            }
            return centers;
        }
        log.info("subdividing", this.bbox, this.bboxActual);
        BBox[] split = this.bboxActual.getWidth() > this.bboxActual.getHeight() ? this.bboxActual.splitLon() : this.bboxActual.splitLat();
        NOD1Part[] parts = new NOD1Part[2];
        for (int i = 0; i < split.length; ++i) {
            parts[i] = new NOD1Part(split[i]);
        }
        for (RouteNode node : this.nodes) {
            int i = 0;
            while (!split[i].contains(node.getCoord())) {
                ++i;
            }
            parts[i].addNode(node);
        }
        this.tabA = null;
        this.destNodes = null;
        this.nodes = null;
        for (NOD1Part part : parts) {
            if (part.bboxActual.empty) continue;
            centers.addAll(part.subdivideHelper(depth + 1));
        }
        return centers;
    }

    private boolean satisfiesConstraints() {
        log.debug("constraints:", this.bboxActual, this.tabA.size(), this.destNodes.size(), this.nodesSize);
        return this.bboxActual.getMaxDimension() < 63488 && this.tabA.size() < 248 && this.destNodes.size() < 254 && this.nodesSize < 8192;
    }

    private RouteCenter toRouteCenter() {
        Collections.sort(this.nodes, new Comparator<RouteNode>(){

            @Override
            public int compare(RouteNode n1, RouteNode n2) {
                return n1.getCoord().compareTo(n2.getCoord());
            }
        });
        TableB tabB = new TableB();
        for (RouteNode rn : this.destNodes.keySet()) {
            tabB.addNode(rn);
        }
        return new RouteCenter(this.bboxActual.toArea(), this.nodes, this.tabA, tabB);
    }

    public class BBox {
        int maxLat;
        int minLat;
        int maxLon;
        int minLon;
        boolean empty;

        BBox() {
            this.empty = true;
        }

        BBox(Coord co) {
            this.empty = false;
            int lat = co.getLatitude();
            int lon = co.getLongitude();
            this.minLat = lat;
            this.maxLat = lat + 1;
            this.minLon = lon;
            this.maxLon = lon + 1;
        }

        BBox(int minLat, int maxLat, int minLon, int maxLon) {
            this.empty = false;
            this.minLat = minLat;
            this.maxLat = maxLat;
            this.minLon = minLon;
            this.maxLon = maxLon;
        }

        Area toArea() {
            return new Area(this.minLat, this.minLon, this.maxLat, this.maxLon);
        }

        boolean contains(BBox bbox) {
            return this.minLat <= bbox.minLat && bbox.maxLat <= this.maxLat && this.minLon <= bbox.minLon && bbox.maxLon <= this.maxLon;
        }

        boolean contains(Coord co) {
            return this.contains(new BBox(co));
        }

        void extend(BBox bbox) {
            if (bbox.empty) {
                return;
            }
            if (this.empty) {
                this.empty = false;
                this.minLat = bbox.minLat;
                this.maxLat = bbox.maxLat;
                this.minLon = bbox.minLon;
                this.maxLon = bbox.maxLon;
            } else {
                this.minLat = Math.min(this.minLat, bbox.minLat);
                this.maxLat = Math.max(this.maxLat, bbox.maxLat);
                this.minLon = Math.min(this.minLon, bbox.minLon);
                this.maxLon = Math.max(this.maxLon, bbox.maxLon);
            }
        }

        void extend(Coord co) {
            this.extend(new BBox(co));
        }

        BBox[] splitLat() {
            BBox[] ret = new BBox[2];
            int midLat = (this.minLat + this.maxLat) / 2;
            ret[0] = new BBox(this.minLat, midLat, this.minLon, this.maxLon);
            ret[1] = new BBox(midLat, this.maxLat, this.minLon, this.maxLon);
            return ret;
        }

        BBox[] splitLon() {
            BBox[] ret = new BBox[2];
            int midLon = (this.minLon + this.maxLon) / 2;
            ret[0] = new BBox(this.minLat, this.maxLat, this.minLon, midLon);
            ret[1] = new BBox(this.minLat, this.maxLat, midLon, this.maxLon);
            return ret;
        }

        int getWidth() {
            return this.maxLon - this.minLon;
        }

        int getHeight() {
            return this.maxLat - this.minLat;
        }

        int getMaxDimension() {
            return Math.max(this.getWidth(), this.getHeight());
        }

        public String toString() {
            return "BBox[" + new Coord(this.minLat, this.minLon).toDegreeString() + ", " + new Coord(this.maxLat, this.maxLon).toDegreeString() + "]";
        }
    }
}

