/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.BufferedImgFileWriter;
import uk.me.parabola.imgfmt.app.ImgFile;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Label;
import uk.me.parabola.imgfmt.app.lbl.City;
import uk.me.parabola.imgfmt.app.net.NETHeader;
import uk.me.parabola.imgfmt.app.net.RoadDef;
import uk.me.parabola.imgfmt.app.srt.IntegerSortKey;
import uk.me.parabola.imgfmt.app.srt.MultiSortKey;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.srt.SortKey;
import uk.me.parabola.imgfmt.fs.ImgChannel;

public class NETFile
extends ImgFile {
    private final NETHeader netHeader = new NETHeader();
    private List<RoadDef> roads;
    private Sort sort;

    public NETFile(ImgChannel chan) {
        this.setHeader(this.netHeader);
        this.setWriter(new BufferedImgFileWriter(chan));
        this.position(55L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int numCities, int numZips) {
        ImgFileWriter writer = this.netHeader.makeRoadWriter(this.getWriter());
        try {
            for (RoadDef rd : this.roads) {
                rd.writeNet1(writer, numCities, numZips);
            }
        }
        finally {
            Utils.closeFile(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePost(ImgFileWriter rgn) {
        for (RoadDef rd : this.roads) {
            rd.writeRgnOffsets(rgn);
        }
        ImgFileWriter writer = this.netHeader.makeSortedRoadWriter(this.getWriter());
        try {
            List<LabeledRoadDef> labeledRoadDefs = this.sortRoads();
            for (LabeledRoadDef labeledRoadDef : labeledRoadDefs) {
                labeledRoadDef.roadDef.putSortedRoadEntry(writer, labeledRoadDef.label);
            }
        }
        finally {
            Utils.closeFile(writer);
        }
        this.getHeader().writeHeader(this.getWriter());
    }

    private List<LabeledRoadDef> sortRoads() {
        ArrayList<MultiSortKey<Object>> sortKeys = new ArrayList<MultiSortKey<Object>>(this.roads.size());
        HashMap<Label, byte[]> cache = new HashMap<Label, byte[]>();
        for (RoadDef rd : this.roads) {
            Label[] labels = rd.getLabels();
            for (int i = 0; i < labels.length && labels[i] != null; ++i) {
                SortKey<Object> cityKey;
                Label label = labels[i];
                if (label.getLength() == 0) continue;
                LabeledRoadDef labeledRoadDef = new LabeledRoadDef(label, rd);
                SortKey<LabeledRoadDef> nameKey = this.sort.createSortKey(labeledRoadDef, label, 0, cache);
                City city = rd.getCity();
                if (city != null) {
                    int region = city.getRegionNumber();
                    int country = city.getCountryNumber();
                    cityKey = this.sort.createSortKey(null, city.getLabel(), (region & 0xFFFF) << 16 | country & 0xFFFF, cache);
                } else {
                    cityKey = this.sort.createSortKey(null, Label.NULL_OUT_LABEL, 0, cache);
                }
                MultiSortKey<Object> sortKey = new MultiSortKey<Object>(nameKey, cityKey, new IntegerSortKey<Object>(null, rd.getStartSubdivNumber(), 0));
                sortKeys.add(sortKey);
            }
        }
        Collections.sort(sortKeys);
        ArrayList<LabeledRoadDef> out = new ArrayList<LabeledRoadDef>(sortKeys.size());
        Label lastName = null;
        City lastCity = null;
        ArrayList<LabeledRoadDef> dupes = new ArrayList<LabeledRoadDef>();
        for (SortKey sortKey : sortKeys) {
            LabeledRoadDef lrd = (LabeledRoadDef)sortKey.getObject();
            Label name = lrd.label;
            RoadDef road = lrd.roadDef;
            City city = road.getCity();
            if (road.hasHouseNumbers() || !name.equals(lastName) || city != lastCity) {
                this.addDisconnected(dupes, out);
                dupes = new ArrayList();
                lastName = name;
                lastCity = city;
            }
            dupes.add(lrd);
        }
        this.addDisconnected(dupes, out);
        return out;
    }

    private void addDisconnected(List<LabeledRoadDef> in, List<LabeledRoadDef> out) {
        if (in.size() > 200) {
            this.addDisconnectedLarge(in, out);
        } else {
            this.addDisconnectedSmall(in, out);
        }
    }

    private void addDisconnectedSmall(List<LabeledRoadDef> in, List<LabeledRoadDef> out) {
        boolean done;
        int[] groups = new int[in.size()];
        for (int i = 0; i < groups.length; ++i) {
            groups[i] = i;
        }
        do {
            done = true;
            for (int current = 0; current < groups.length; ++current) {
                RoadDef first = in.get(current).roadDef;
                for (int i = current; i < groups.length; ++i) {
                    if (groups[current] == groups[i] || !first.connectedTo(in.get(i).roadDef)) continue;
                    groups[current] = groups[i] = Math.min(groups[current], groups[i]);
                    done = false;
                }
            }
        } while (!done);
        int last = -1;
        for (int i = 0; i < groups.length; ++i) {
            if (groups[i] <= last) continue;
            LabeledRoadDef lrd = in.get(i);
            out.add(lrd);
            last = groups[i];
        }
    }

    private void addDisconnectedLarge(List<LabeledRoadDef> in, List<LabeledRoadDef> out) {
        Collections.sort(in, new Comparator<LabeledRoadDef>(){

            @Override
            public int compare(LabeledRoadDef o1, LabeledRoadDef o2) {
                Integer i1 = o1.roadDef.getStartSubdivNumber();
                Integer i2 = o2.roadDef.getStartSubdivNumber();
                return i1.compareTo(i2);
            }
        });
        int lastDiv = 0;
        ArrayList<LabeledRoadDef> dupes = new ArrayList<LabeledRoadDef>();
        for (LabeledRoadDef lrd : in) {
            int sd = lrd.roadDef.getStartSubdivNumber();
            if (sd != lastDiv) {
                this.addDisconnectedSmall(dupes, out);
                dupes = new ArrayList();
                lastDiv = sd;
            }
            dupes.add(lrd);
        }
        this.addDisconnectedSmall(dupes, out);
    }

    public void setNetwork(List<RoadDef> roads) {
        this.roads = roads;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    class LabeledRoadDef {
        private final Label label;
        private final RoadDef roadDef;

        LabeledRoadDef(Label label, RoadDef roadDef) {
            this.label = label;
            this.roadDef = roadDef;
        }
    }
}

