/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import java.util.LinkedHashMap;
import java.util.Map;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.TagDict;

public final class AccessTagsAndBits {
    public static final byte FOOT = 1;
    public static final byte BIKE = 2;
    public static final byte CAR = 4;
    public static final byte DELIVERY = 8;
    public static final byte TRUCK = 16;
    public static final byte BUS = 32;
    public static final byte TAXI = 64;
    public static final byte EMERGENCY = -128;
    public static final byte R_THROUGHROUTE = 1;
    public static final byte R_CARPOOL = 2;
    public static final byte R_ONEWAY = 4;
    public static final byte R_TOLL = 8;
    public static final byte R_UNPAVED = 16;
    public static final byte R_FERRY = 32;
    public static final byte R_ROUNDABOUT = 64;
    public static final Map<String, Byte> ACCESS_TAGS = new LinkedHashMap<String, Byte>(){
        {
            this.put("mkgmap:foot", (byte)1);
            this.put("mkgmap:bicycle", (byte)2);
            this.put("mkgmap:car", (byte)4);
            this.put("mkgmap:delivery", (byte)8);
            this.put("mkgmap:truck", (byte)16);
            this.put("mkgmap:bus", (byte)32);
            this.put("mkgmap:taxi", (byte)64);
            this.put("mkgmap:emergency", (byte)-128);
        }
    };
    public static final Map<Short, Byte> ACCESS_TAGS_COMPILED = new LinkedHashMap<Short, Byte>(){
        {
            for (Map.Entry<String, Byte> entry : ACCESS_TAGS.entrySet()) {
                this.put(TagDict.getInstance().xlate(entry.getKey()), entry.getValue());
            }
        }
    };
    public static final Map<String, Byte> ROUTE_TAGS = new LinkedHashMap<String, Byte>(){
        {
            this.put("mkgmap:throughroute", (byte)1);
            this.put("mkgmap:carpool", (byte)2);
            this.put("oneway", (byte)4);
            this.put("mkgmap:toll", (byte)8);
            this.put("mkgmap:unpaved", (byte)16);
            this.put("mkgmap:ferry", (byte)32);
            this.put("junction", (byte)64);
        }
    };
    private static final short carpoolTagKey = TagDict.getInstance().xlate("mkgmap:carpool");
    private static final short tollTagKey = TagDict.getInstance().xlate("mkgmap:toll");
    private static final short unpavedTagKey = TagDict.getInstance().xlate("mkgmap:unpaved");
    private static final short ferryTagKey = TagDict.getInstance().xlate("mkgmap:ferry");
    private static final short throughrouteTagKey = TagDict.getInstance().xlate("mkgmap:throughroute");
    private static final short junctionTagKey = TagDict.getInstance().xlate("junction");
    private static final short onewayTagKey = TagDict.getInstance().xlate("oneway");

    public static byte evalAccessTags(Element el) {
        int noAccess = 0;
        for (Map.Entry<Short, Byte> entry : ACCESS_TAGS_COMPILED.entrySet()) {
            if (!el.tagIsLikeNo(entry.getKey())) continue;
            noAccess = (byte)(noAccess | entry.getValue());
        }
        return (byte)(~noAccess);
    }

    public static byte evalRouteTags(Element el) {
        byte routeFlags = 0;
        if (el.tagIsLikeYes(carpoolTagKey)) {
            routeFlags = (byte)(routeFlags | 2);
        }
        if (el.tagIsLikeYes(tollTagKey)) {
            routeFlags = (byte)(routeFlags | 8);
        }
        if (el.tagIsLikeYes(unpavedTagKey)) {
            routeFlags = (byte)(routeFlags | 0x10);
        }
        if (el.tagIsLikeYes(ferryTagKey)) {
            routeFlags = (byte)(routeFlags | 0x20);
        }
        routeFlags = el.tagIsLikeNo(throughrouteTagKey) ? (byte)((byte)(routeFlags & 0xFFFFFFFE)) : (byte)((byte)(routeFlags | 1));
        if ("roundabout".equals(el.getTag(junctionTagKey))) {
            routeFlags = (byte)(routeFlags | 0x40);
        }
        if (el.tagIsLikeYes(onewayTagKey)) {
            routeFlags = (byte)(routeFlags | 4);
        }
        return routeFlags;
    }
}

