/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.HasHeaderFlags;
import uk.me.parabola.imgfmt.app.mdr.Mdr13Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr28Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.mdr.MdrSection;
import uk.me.parabola.imgfmt.app.mdr.MdrUtils;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.srt.SortKey;

public class Mdr28
extends MdrSection
implements HasHeaderFlags {
    private final List<Mdr28Record> index = new ArrayList<Mdr28Record>();

    public Mdr28(MdrConfig config) {
        this.setConfig(config);
    }

    public void buildFromRegions(List<Mdr13Record> regions) {
        Sort sort = this.getConfig().getSort();
        List<SortKey<Mdr13Record>> keys = MdrUtils.sortList(sort, regions);
        int record = 0;
        Mdr28Record mdr28 = null;
        String lastName = null;
        for (SortKey<Mdr13Record> key : keys) {
            Mdr13Record region = key.getObject();
            String name = region.getName();
            if (!name.equals(lastName)) {
                mdr28 = new Mdr28Record();
                mdr28.setIndex(++record);
                mdr28.setName(name);
                mdr28.setStrOffset(region.getStrOffset());
                mdr28.setMdr14(region.getMdr14());
                this.index.add(mdr28);
                lastName = name;
            }
            assert (mdr28 != null);
            region.setMdr28(mdr28);
        }
    }

    @Override
    public void writeSectData(ImgFileWriter writer) {
        MdrSection.PointerSizes sizes = this.getSizes();
        int size21 = sizes.getSize(21);
        int size23 = sizes.getSize(23);
        int size27 = sizes.getSize(27);
        int idx = 0;
        for (Mdr28Record mdr28 : this.index) {
            this.putN(writer, size23, mdr28.getMdr23());
            this.putStringOffset(writer, mdr28.getStrOffset());
            this.putN(writer, size21, mdr28.getMdr21());
            this.putN(writer, size27, mdr28.getMdr27());
            ++idx;
        }
    }

    @Override
    public int getItemSize() {
        MdrSection.PointerSizes sizes = this.getSizes();
        return sizes.getSize(23) + sizes.getStrOffSize() + sizes.getSize(21) + sizes.getSize(27);
    }

    @Override
    protected int numberOfItems() {
        return this.index.size();
    }

    @Override
    public int getExtraValue() {
        return 7;
    }

    public List<Mdr28Record> getIndex() {
        return Collections.unmodifiableList(this.index);
    }
}

