/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.HasHeaderFlags;
import uk.me.parabola.imgfmt.app.mdr.Mdr18Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.mdr.MdrSection;

public class Mdr18
extends MdrSection
implements HasHeaderFlags {
    private List<Mdr18Record> poiTypes = new ArrayList<Mdr18Record>();

    public Mdr18(MdrConfig config) {
        this.setConfig(config);
    }

    @Override
    public void writeSectData(ImgFileWriter writer) {
        int poiSize = this.getSizes().getSize(19);
        for (Mdr18Record pt : this.poiTypes) {
            writer.putChar((char)(pt.getType() | 0x4000));
            this.putN(writer, poiSize, pt.getRecord());
        }
    }

    @Override
    public int getItemSize() {
        return 2 + this.getSizes().getSize(19);
    }

    @Override
    protected int numberOfItems() {
        return this.poiTypes.size();
    }

    public void setPoiTypes(List<Mdr18Record> poiTypes) {
        this.poiTypes = poiTypes;
    }

    @Override
    public int getExtraValue() {
        return 4 + this.getSizes().getSize(19) - 1;
    }
}

