/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.HasHeaderFlags;
import uk.me.parabola.imgfmt.app.mdr.Mdr1MapIndex;
import uk.me.parabola.imgfmt.app.mdr.Mdr1Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.mdr.MdrSection;

public class Mdr1
extends MdrSection
implements HasHeaderFlags {
    private final List<Mdr1Record> maps = new ArrayList<Mdr1Record>();
    private int[] mapping;

    public Mdr1(MdrConfig config) {
        this.setConfig(config);
    }

    public void addMap(int mapNumber, int index) {
        assert (index > 0);
        Mdr1Record rec = new Mdr1Record(mapNumber, this.getConfig());
        rec.setMapIndex(index);
        this.maps.add(rec);
        if (!this.isForDevice()) {
            Mdr1MapIndex mapIndex = new Mdr1MapIndex();
            rec.setMdrMapIndex(mapIndex);
        }
    }

    public void finish() {
        Collections.sort(this.maps, new Comparator<Mdr1Record>(){

            @Override
            public int compare(Mdr1Record o1, Mdr1Record o2) {
                if (o1.getMapNumber() == o2.getMapNumber()) {
                    return 0;
                }
                if (o1.getMapNumber() < o2.getMapNumber()) {
                    return -1;
                }
                return 1;
            }
        });
        this.mapping = new int[this.maps.size()];
        int count = 1;
        for (Mdr1Record r : this.maps) {
            this.mapping[r.getMapIndex() - 1] = count++;
        }
    }

    public void writeSubSections(ImgFileWriter writer) {
        if (this.isForDevice()) {
            return;
        }
        for (Mdr1Record rec : this.maps) {
            rec.setIndexOffset(writer.position());
            Mdr1MapIndex mapIndex = rec.getMdrMapIndex();
            mapIndex.writeSubSection(writer);
        }
    }

    @Override
    public void writeSectData(ImgFileWriter writer) {
        boolean revIndex = (this.getExtraValue() & 1) != 0;
        for (Mdr1Record rec : this.maps) {
            writer.putInt(rec.getMapNumber());
            if (!revIndex) continue;
            writer.putInt(rec.getIndexOffset());
        }
    }

    @Override
    public int getItemSize() {
        return this.isForDevice() ? 4 : 8;
    }

    public void setStartPosition(int sectionNumber) {
        if (this.isForDevice()) {
            return;
        }
        for (Mdr1Record mi : this.maps) {
            mi.getMdrMapIndex().startSection(sectionNumber);
        }
    }

    public void setEndPosition(int sectionNumber) {
        if (this.isForDevice()) {
            return;
        }
        for (Mdr1Record mi : this.maps) {
            mi.getMdrMapIndex().endSection(sectionNumber);
        }
    }

    public void setPointerSize(int sectionSize, int recordSize) {
        for (Mdr1Record mi : this.maps) {
            Mdr1MapIndex mapIndex = mi.getMdrMapIndex();
            mapIndex.setPointerSize(sectionSize, recordSize);
        }
    }

    public void addPointer(int mapNumber, int recordNumber) {
        Mdr1MapIndex mi = this.maps.get(mapNumber - 1).getMdrMapIndex();
        mi.addPointer(recordNumber);
    }

    @Override
    protected int numberOfItems() {
        return this.maps.size();
    }

    @Override
    public int getExtraValue() {
        int magic = 0;
        if (!this.isForDevice()) {
            magic |= 1;
        }
        return magic;
    }

    public int sortedMapIndex(int n) {
        return this.mapping[n - 1];
    }
}

