/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.lbl;

import java.io.UnsupportedEncodingException;
import uk.me.parabola.imgfmt.app.CommonHeader;
import uk.me.parabola.imgfmt.app.ImgFileReader;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.lbl.PlacesHeader;
import uk.me.parabola.imgfmt.app.srt.Sort;

public class LBLHeader
extends CommonHeader {
    public static final int HEADER_LEN = 196;
    private static final char UNK3_REC_LEN = '\u0000';
    private int labelStart;
    private int labelSize;
    private int offsetMultiplier;
    private Sort sort;
    private int sortDescriptionLength;
    private int encodingType = 6;
    private final PlacesHeader placeHeader = new PlacesHeader();

    public LBLHeader() {
        super(196, "GARMIN LBL");
    }

    public int getSortDescriptionLength() {
        return this.sortDescriptionLength;
    }

    @Override
    protected void readFileHeader(ImgFileReader reader) {
        String description;
        this.labelStart = reader.getInt();
        this.labelSize = reader.getInt();
        this.offsetMultiplier = 1 << reader.get();
        this.encodingType = reader.get();
        this.placeHeader.readFileHeader(reader);
        char codepage = reader.getChar();
        char id1 = reader.getChar();
        char id2 = reader.getChar();
        int descOff = reader.getInt();
        int descLen = reader.getInt();
        reader.position(descOff);
        byte[] bytes = reader.get(descLen);
        try {
            description = new String(bytes, "ascii");
        }
        catch (UnsupportedEncodingException e) {
            description = "Unknown";
        }
        this.sort = new Sort();
        this.sort.setCodepage(codepage);
        this.sort.setId1(id1);
        this.sort.setId2(id2);
        this.sort.setDescription(description);
        reader.position(this.labelStart);
    }

    @Override
    protected void writeFileHeader(ImgFileWriter writer) {
        writer.putInt(196 + this.sortDescriptionLength);
        writer.putInt(this.getLabelSize());
        writer.put((byte)this.offsetMultiplier);
        writer.put((byte)this.encodingType);
        this.placeHeader.writeFileHeader(writer);
        writer.putChar((char)this.getCodePage());
        char id1 = (char)this.sort.getId1();
        writer.putChar(id1);
        char id2 = (char)this.sort.getId2();
        if (id1 != '\u0000' && id2 != '\u0000') {
            id2 = (char)(id2 | 0x8000);
        }
        writer.putChar(id2);
        writer.putInt(196);
        writer.putInt(this.sortDescriptionLength);
        writer.putInt(this.placeHeader.getLastPos());
        writer.putInt(0);
        writer.putChar('\u0000');
        writer.putChar('\u0000');
    }

    protected int getEncodingType() {
        return this.encodingType;
    }

    public void setEncodingType(int type) {
        this.encodingType = type;
    }

    protected int getLabelSize() {
        return this.labelSize;
    }

    public void setLabelSize(int labelSize) {
        this.labelSize = labelSize;
        this.placeHeader.setLabelEnd(196 + this.sortDescriptionLength + labelSize);
    }

    protected int getCodePage() {
        return this.sort.getCodepage();
    }

    public void setSort(Sort sort) {
        this.sortDescriptionLength = sort.getDescription().length() + 1;
        this.sort = sort;
    }

    public int getSortOrderId() {
        return this.sort.getSortOrderId();
    }

    public int getLabelStart() {
        return this.labelStart;
    }

    public int getOffsetMultiplier() {
        return this.offsetMultiplier;
    }

    public PlacesHeader getPlaceHeader() {
        return this.placeHeader;
    }

    public void setOffsetMultiplier(int offsetMultiplier) {
        this.offsetMultiplier = offsetMultiplier;
    }
}

