/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.lbl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.me.parabola.imgfmt.app.BufferedImgFileReader;
import uk.me.parabola.imgfmt.app.ImgFile;
import uk.me.parabola.imgfmt.app.ImgFileReader;
import uk.me.parabola.imgfmt.app.Label;
import uk.me.parabola.imgfmt.app.labelenc.CharacterDecoder;
import uk.me.parabola.imgfmt.app.labelenc.CodeFunctions;
import uk.me.parabola.imgfmt.app.labelenc.DecodedText;
import uk.me.parabola.imgfmt.app.lbl.City;
import uk.me.parabola.imgfmt.app.lbl.Country;
import uk.me.parabola.imgfmt.app.lbl.LBLHeader;
import uk.me.parabola.imgfmt.app.lbl.POIRecord;
import uk.me.parabola.imgfmt.app.lbl.PlacesHeader;
import uk.me.parabola.imgfmt.app.lbl.Region;
import uk.me.parabola.imgfmt.app.lbl.Zip;
import uk.me.parabola.imgfmt.app.trergn.Subdivision;
import uk.me.parabola.imgfmt.fs.ImgChannel;

public class LBLFileReader
extends ImgFile {
    private CharacterDecoder textDecoder = CodeFunctions.getDefaultDecoder();
    private final LBLHeader header = new LBLHeader();
    private final Map<Integer, Label> labels = new HashMap<Integer, Label>();
    private final Map<Integer, POIRecord> pois = new HashMap<Integer, POIRecord>();
    private final List<Country> countries = new ArrayList<Country>();
    private final List<Region> regions = new ArrayList<Region>();
    private final Map<Integer, Zip> zips = new HashMap<Integer, Zip>();
    private final List<City> cities = new ArrayList<City>();

    public LBLFileReader(ImgChannel chan) {
        this.setHeader(this.header);
        this.setReader(new BufferedImgFileReader(chan));
        this.header.readHeader(this.getReader());
        int offsetMultiplier = this.header.getOffsetMultiplier();
        CodeFunctions funcs = CodeFunctions.createEncoderForLBL(this.header.getEncodingType(), this.header.getCodePage());
        this.textDecoder = funcs.getDecoder();
        this.readLables(offsetMultiplier);
        this.readCountries();
        this.readRegions();
        this.readCities();
        this.readZips();
        this.readPoiInfo();
    }

    public Label fetchLabel(int offset) {
        Label label = this.labels.get(offset);
        if (label == null) {
            assert (offset == 0) : "Invalid label offset found " + offset;
            return Label.NULL_LABEL;
        }
        return label;
    }

    public List<City> getCities() {
        return this.cities;
    }

    public List<Country> getCountries() {
        return Collections.unmodifiableList(this.countries);
    }

    public List<Region> getRegions() {
        return Collections.unmodifiableList(this.regions);
    }

    public List<Zip> getZips() {
        return new ArrayList<Zip>(this.zips.values());
    }

    public POIRecord fetchPoi(int offset) {
        return this.pois.get(offset);
    }

    private void readCountries() {
        ImgFileReader reader = this.getReader();
        PlacesHeader placeHeader = this.header.getPlaceHeader();
        this.countries.add(null);
        int start = placeHeader.getCountriesStart();
        int end = placeHeader.getCountriesEnd();
        reader.position(start);
        int index = 1;
        while (reader.position() < (long)end) {
            int offset = reader.getu3();
            Label label = this.fetchLabel(offset);
            if (label != null) {
                Country country = new Country(index);
                country.setLabel(label);
                this.countries.add(country);
            }
            ++index;
        }
    }

    private void readRegions() {
        ImgFileReader reader = this.getReader();
        PlacesHeader placeHeader = this.header.getPlaceHeader();
        int start = placeHeader.getRegionsStart();
        int end = placeHeader.getRegionsEnd();
        this.regions.add(null);
        reader.position(start);
        int index = 1;
        while (reader.position() < (long)end) {
            char country = reader.getChar();
            int offset = reader.getu3();
            Label label = this.fetchLabel(offset);
            if (label != null) {
                Region region = new Region(this.countries.get(country));
                region.setIndex(index);
                region.setLabel(label);
                this.regions.add(region);
            }
            ++index;
        }
    }

    private void readCities() {
        PlacesHeader placeHeader = this.header.getPlaceHeader();
        int start = placeHeader.getCitiesStart();
        int end = placeHeader.getCitiesEnd();
        ImgFileReader reader = this.getReader();
        reader.position(start);
        int index = 1;
        while (reader.position() < (long)end) {
            City city;
            int label = reader.getu3();
            char info = reader.getChar();
            if ((info & 0x4000) == 0) {
                Region region = this.regions.get(info & 0x3FFF);
                city = new City(region);
            } else {
                Country country = this.countries.get(info & 0x3FFF);
                city = new City(country);
            }
            city.setIndex(index);
            if ((info & 0x8000) == 0) {
                city.setSubdivision(Subdivision.createEmptySubdivision(1));
                Label label1 = this.labels.get(label & 0x3FFFFF);
                city.setLabel(label1);
            } else {
                int pointIndex = label & 0xFF;
                int subdiv = label >> 8 & 0xFFFF;
                city.setPointIndex((byte)pointIndex);
                city.setSubdivision(Subdivision.createEmptySubdivision(subdiv));
            }
            this.cities.add(city);
            ++index;
        }
    }

    private void readLables(int mult) {
        ImgFileReader reader = this.getReader();
        this.labels.put(0, Label.NULL_LABEL);
        int start = this.header.getLabelStart();
        int size = this.header.getLabelSize();
        reader.position(start + mult);
        int labelOffset = mult;
        for (int off = mult; off <= size; ++off) {
            byte b = reader.get();
            if (!this.textDecoder.addByte(b)) continue;
            labelOffset = this.saveLabel(labelOffset, off, mult);
            while ((labelOffset & mult - 1) != 0) {
                this.textDecoder.reset();
                if (labelOffset <= off) {
                    ++labelOffset;
                    continue;
                }
                reader.get();
                ++off;
                ++labelOffset;
            }
        }
    }

    private int saveLabel(int labelOffset, int currentOffset, int multiplier) {
        DecodedText encText = this.textDecoder.getText();
        String text = encText.getText();
        Label label = new Label(text);
        assert ((labelOffset & multiplier - 1) == 0);
        int adustedOffset = labelOffset / multiplier;
        label.setOffset(adustedOffset);
        this.labels.put(adustedOffset, label);
        return currentOffset + 1 + encText.getOffsetAdjustment();
    }

    private void readZips() {
        ImgFileReader reader = this.getReader();
        PlacesHeader placeHeader = this.header.getPlaceHeader();
        int start = placeHeader.getZipsStart();
        int end = placeHeader.getZipsEnd();
        reader.position(start);
        int zipIndex = 1;
        while (reader.position() < (long)end) {
            int lblOffset = reader.get3();
            Zip zip = new Zip();
            zip.setLabel(this.fetchLabel(lblOffset));
            zip.setIndex(zipIndex);
            this.zips.put(zip.getIndex(), zip);
            ++zipIndex;
        }
    }

    private void readPoiInfo() {
        ImgFileReader reader = this.getReader();
        PlacesHeader placeHeader = this.header.getPlaceHeader();
        byte poiGlobalFlags = placeHeader.getPOIGlobalFlags();
        int start = placeHeader.getPoiPropertiesStart();
        int end = placeHeader.getPoiPropertiesEnd();
        reader.position(start);
        PoiMasks localMask = this.makeLocalMask(placeHeader);
        while (reader.position() < (long)end) {
            byte b;
            boolean hasTides;
            boolean hasHighwayExit;
            boolean hasPhone;
            boolean hasZip;
            boolean hasCity;
            boolean hasStreet;
            boolean hasStreetNum;
            byte flags;
            int poiOffset = this.position() - start;
            int val = reader.getu3();
            int labelOffset = val & 0x3FFFFF;
            boolean override = (val & 0x800000) != 0;
            POIRecord poi = new POIRecord();
            poi.setLabel(this.fetchLabel(labelOffset));
            if (override) {
                flags = reader.get();
                hasStreetNum = (flags & localMask.streetNumMask) != 0;
                hasStreet = (flags & localMask.streetMask) != 0;
                hasCity = (flags & localMask.cityMask) != 0;
                hasZip = (flags & localMask.zipMask) != 0;
                hasPhone = (flags & localMask.phoneMask) != 0;
                hasHighwayExit = (flags & localMask.highwayExitMask) != 0;
                hasTides = (flags & localMask.tidesMask) != 0;
            } else {
                flags = poiGlobalFlags;
                hasStreetNum = (flags & 1) != 0;
                hasStreet = (flags & 2) != 0;
                hasCity = (flags & 4) != 0;
                hasZip = (flags & 8) != 0;
                hasPhone = (flags & 0x10) != 0;
                hasHighwayExit = (flags & 0x20) != 0;
                boolean bl = hasTides = (flags & 0x40) != 0;
            }
            if (hasStreetNum) {
                b = reader.get();
                if ((b & 0x80) == 0) {
                    int mpoffset = b << 16 & 0xFF0000;
                    poi.setComplexStreetNumber(this.fetchLabel(mpoffset |= reader.getChar() & 0xFFFF));
                } else {
                    poi.setSimpleStreetNumber(reader.getBase11str(b, '-'));
                }
            }
            if (hasStreet) {
                int streetNameOffset = reader.getu3();
                Label label = this.fetchLabel(streetNameOffset);
                poi.setStreetName(label);
            }
            if (hasCity) {
                int cityIndex = placeHeader.getNumCities() > 255 ? reader.getChar() : reader.get() & 0xFF;
                poi.setCity(this.cities.get(cityIndex - 1));
            }
            if (hasZip) {
                int zipIndex = placeHeader.getNumZips() > 255 ? reader.getChar() : reader.get() & 0xFF;
                poi.setZip(this.zips.get(zipIndex - 1));
            }
            if (hasPhone) {
                b = reader.get();
                if ((b & 0x80) == 0) {
                    int mpoffset = b << 16 & 0xFF0000;
                    poi.setComplexPhoneNumber(this.fetchLabel(mpoffset |= reader.getChar() & 0xFFFF));
                } else {
                    poi.setSimplePhoneNumber(reader.getBase11str(b, '-'));
                }
            }
            if (hasHighwayExit) {
                char highwayIndex;
                int lblinfo = reader.getu3();
                int highwayLabelOffset = lblinfo & 0x3FFFF;
                boolean indexed = (lblinfo & 0x800000) != 0;
                boolean overnightParking = (lblinfo & 0x400000) != 0;
                char c = highwayIndex = placeHeader.getNumHighways() > 255 ? reader.getChar() : (char)reader.get();
                if (indexed) {
                    char eidx;
                    char c2 = eidx = placeHeader.getNumExits() > 255 ? reader.getChar() : (char)reader.get();
                }
            }
            if (hasTides) {
                System.out.println("Map has tide prediction, please implement!");
            }
            this.pois.put(poiOffset, poi);
        }
    }

    private PoiMasks makeLocalMask(PlacesHeader placeHeader) {
        byte globalPoi = placeHeader.getPOIGlobalFlags();
        char mask = '\u0001';
        boolean hasStreetNum = (globalPoi & 1) != 0;
        boolean hasStreet = (globalPoi & 2) != 0;
        boolean hasCity = (globalPoi & 4) != 0;
        boolean hasZip = (globalPoi & 8) != 0;
        boolean hasPhone = (globalPoi & 0x10) != 0;
        boolean hasHighwayExit = (globalPoi & 0x20) != 0;
        boolean hasTides = (globalPoi & 0x40) != 0;
        PoiMasks localMask = new PoiMasks();
        if (hasStreetNum) {
            localMask.streetNumMask = mask;
            mask = (char)(mask << 1);
        }
        if (hasStreet) {
            localMask.streetMask = mask;
            mask = (char)(mask << 1);
        }
        if (hasCity) {
            localMask.cityMask = mask;
            mask = (char)(mask << 1);
        }
        if (hasZip) {
            localMask.zipMask = mask;
            mask = (char)(mask << 1);
        }
        if (hasPhone) {
            localMask.phoneMask = mask;
            mask = (char)(mask << 1);
        }
        if (hasHighwayExit) {
            localMask.highwayExitMask = mask;
            mask = (char)(mask << 1);
        }
        if (hasTides) {
            localMask.tidesMask = mask;
            mask = (char)(mask << 1);
        }
        return localMask;
    }

    public Map<Integer, String> getLabels() {
        HashMap<Integer, String> m = new HashMap<Integer, String>();
        for (Map.Entry<Integer, Label> ent : this.labels.entrySet()) {
            m.put(ent.getKey(), ent.getValue().getText());
        }
        return m;
    }

    public int getCodePage() {
        return this.header.getCodePage();
    }

    public int getSortOrderId() {
        return this.header.getSortOrderId();
    }

    public int getEncodingType() {
        return this.header.getEncodingType();
    }

    private class PoiMasks {
        private char streetNumMask;
        private char streetMask;
        private char cityMask;
        private char zipMask;
        private char phoneMask;
        private char highwayExitMask;
        private char tidesMask;

        private PoiMasks() {
        }
    }
}

