/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.log.Logger;

public class BufferedImgFileWriter
implements ImgFileWriter {
    private static final Logger log = Logger.getLogger(BufferedImgFileWriter.class);
    private static final int KBYTE = 1024;
    private static final int INIT_SIZE = 16384;
    private static final int GROW_SIZE = 131072;
    private static final int GUARD_SIZE = 1024;
    private final ImgChannel chan;
    private ByteBuffer buf = ByteBuffer.allocate(16384);
    private int bufferSize = 16384;
    private int maxSize;
    private long maxAllowedSize = 0xFFFFFFL;

    public BufferedImgFileWriter(ImgChannel chan) {
        this.chan = chan;
        this.buf.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void sync() throws IOException {
        this.buf.limit(this.maxSize);
        this.buf.position(0);
        log.debug("syncing to pos", this.chan.position(), ", size", this.buf.limit());
        this.chan.write(this.buf);
    }

    @Override
    public int position() {
        return this.buf.position();
    }

    @Override
    public void position(long pos) {
        int cur = this.position();
        if (cur > this.maxSize) {
            this.maxSize = cur;
        }
        this.buf.position((int)pos);
    }

    @Override
    public void close() throws IOException {
        this.chan.close();
    }

    @Override
    public void put(byte b) {
        this.ensureSize(1);
        this.buf.put(b);
    }

    @Override
    public void putChar(char c) {
        this.ensureSize(2);
        this.buf.putChar(c);
    }

    @Override
    public void put3(int val) {
        this.ensureSize(3);
        this.buf.put((byte)(val & 0xFF));
        this.buf.putChar((char)(val >> 8));
    }

    @Override
    public void putInt(int val) {
        this.ensureSize(4);
        this.buf.putInt(val);
    }

    @Override
    public void put(byte[] val) {
        this.ensureSize(val.length);
        this.buf.put(val);
    }

    @Override
    public void put(byte[] src, int start, int length) {
        this.ensureSize(length);
        this.buf.put(src, start, length);
    }

    @Override
    public void put(ByteBuffer src) {
        this.ensureSize(src.limit());
        this.buf.put(src);
    }

    @Override
    public long getSize() {
        return this.maxSize;
    }

    public ByteBuffer getBuffer() {
        return this.buf;
    }

    private void ensureSize(int length) {
        int needed = this.buf.position() + length;
        if (needed > this.bufferSize - 1024) {
            while (needed > this.bufferSize - 1024) {
                this.bufferSize += 131072;
            }
            if ((long)this.bufferSize > this.maxAllowedSize) {
                throw new MapFailedException("There is not enough room in a single garmin map for all the input data. The .osm file should be split into smaller pieces first.");
            }
            ByteBuffer newb = ByteBuffer.allocate(this.bufferSize);
            newb.order(ByteOrder.LITTLE_ENDIAN);
            this.buf.flip();
            newb.put(this.buf);
            this.buf = newb;
        }
    }

    public void setMaxSize(long maxSize) {
        this.maxAllowedSize = maxSize;
    }
}

