/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;

public class Area {
    private static final Logger log = Logger.getLogger(Area.class);
    private final int minLat;
    private final int minLong;
    private final int maxLat;
    private final int maxLong;

    public Area(int minLat, int minLong, int maxLat, int maxLong) {
        this.minLat = minLat;
        this.maxLat = maxLat == minLat ? minLat + 1 : maxLat;
        this.minLong = minLong;
        this.maxLong = minLong == maxLong ? maxLong + 1 : maxLong;
    }

    public Area(double minLat, double minLong, double maxLat, double maxLong) {
        this(Utils.toMapUnit(minLat), Utils.toMapUnit(minLong), Utils.toMapUnit(maxLat), Utils.toMapUnit(maxLong));
    }

    public int getMinLat() {
        return this.minLat;
    }

    public int getMinLong() {
        return this.minLong;
    }

    public int getMaxLat() {
        return this.maxLat;
    }

    public int getMaxLong() {
        return this.maxLong;
    }

    public int getWidth() {
        return this.maxLong - this.minLong;
    }

    public int getHeight() {
        return this.maxLat - this.minLat;
    }

    public Coord getCenter() {
        return new Coord((this.minLat + this.maxLat) / 2, (this.minLong + this.maxLong) / 2);
    }

    public String toString() {
        return "(" + Utils.toDegrees(this.minLat) + ',' + Utils.toDegrees(this.minLong) + ") to (" + Utils.toDegrees(this.maxLat) + ',' + Utils.toDegrees(this.maxLong) + ')';
    }

    public Area[] split(int xsplit, int ysplit) {
        Area[] areas = new Area[xsplit * ysplit];
        int xsize = this.getWidth() / xsplit;
        int ysize = this.getHeight() / ysplit;
        int xextra = this.getWidth() - xsize * xsplit;
        int yextra = this.getHeight() - ysize * ysplit;
        for (int x = 0; x < xsplit; ++x) {
            int xstart = this.minLong + x * xsize;
            int xend = xstart + xsize;
            if (x == xsplit - 1) {
                xend += xextra;
            }
            for (int y = 0; y < ysplit; ++y) {
                int ystart = this.minLat + y * ysize;
                int yend = ystart + ysize;
                if (y == ysplit - 1) {
                    yend += yextra;
                }
                Area a = new Area(ystart, xstart, yend, xend);
                log.debug(x, y, a);
                areas[x * ysplit + y] = a;
            }
        }
        assert (areas.length == xsplit * ysplit);
        return areas;
    }

    public int getMaxDimension() {
        return Math.max(this.getWidth(), this.getHeight());
    }

    public final boolean contains(Coord co) {
        int lat30 = co.getHighPrecLat();
        int lon30 = co.getHighPrecLon();
        return lat30 >= this.minLat << 6 && lat30 <= this.maxLat << 6 && lon30 >= this.minLong << 6 && lon30 <= this.maxLong << 6;
    }

    public final boolean contains(Area other) {
        return other.getMinLat() >= this.minLat && other.getMaxLat() <= this.maxLat && other.getMinLong() >= this.minLong && other.getMaxLong() <= this.maxLong;
    }

    public final boolean insideBoundary(Coord co) {
        int lat30 = co.getHighPrecLat();
        int lon30 = co.getHighPrecLon();
        return lat30 > this.minLat << 6 && lat30 < this.maxLat << 6 && lon30 > this.minLong << 6 && lon30 < this.maxLong << 6;
    }

    public final boolean insideBoundary(Area other) {
        return other.getMinLat() > this.minLat && other.getMaxLat() < this.maxLat && other.getMinLong() > this.minLong && other.getMaxLong() < this.maxLong;
    }

    public final boolean onBoundary(Coord co) {
        return this.contains(co) && !this.insideBoundary(co);
    }

    public final boolean intersects(Area bbox) {
        return this.minLat <= bbox.getMaxLat() && this.maxLat >= bbox.getMinLat() && this.minLong <= bbox.getMaxLong() && this.maxLong >= bbox.getMinLong();
    }

    public boolean isEmpty() {
        return this.minLat >= this.maxLat || this.minLong >= this.maxLong;
    }

    public boolean allInsideBoundary(List<Coord> coords) {
        for (Coord co : coords) {
            if (this.insideBoundary(co)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Area area = (Area)o;
        if (this.maxLat != area.maxLat) {
            return false;
        }
        if (this.maxLong != area.maxLong) {
            return false;
        }
        if (this.minLat != area.minLat) {
            return false;
        }
        return this.minLong == area.minLong;
    }

    public int hashCode() {
        int result = this.minLat;
        result = 31 * result + this.minLong;
        result = 31 * result + this.maxLat;
        result = 31 * result + this.maxLong;
        return result;
    }

    public List<Coord> toCoords() {
        ArrayList<Coord> coords = new ArrayList<Coord>(5);
        Coord start = new Coord(this.minLat, this.minLong);
        coords.add(start);
        Coord co = new Coord(this.minLat, this.maxLong);
        coords.add(co);
        co = new Coord(this.maxLat, this.maxLong);
        coords.add(co);
        co = new Coord(this.maxLat, this.minLong);
        coords.add(co);
        coords.add(start);
        return coords;
    }
}

