#!/bin/sh
# $Id: t-stress-dns-0.sh,v 1.7 2005/08/15 22:30:25 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# perform DNS MX+A lookups by contacting SMAR
# uses t-smar-1, t-smar-3, and startsmar.sh
# ------------------------------------------------------------
#
test -s stop && exit 1
#

if test X"${SM_NO_DNS_TEST}" != "X"
then
  echo "SKIPPED: $0"
  exit 0
fi

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

IN=${SD}/domains.rand
rm -f ${SOCK} ${PIDS}

# different input file?
if test $# -ge 1
then
  IN=$1
fi

${CAT} > ${MT} <<EOF
EOF

# start SMAR
${SHELL} ${SD}/startsmar.sh || exit 1

i=0
while read d0
do
  # IPv4 address?
  if echo ${d0} | grep '^[1-9][0-9]*\.[0-9]*\.[0-9]*\.[0-9]*$' > /dev/null
  then
    ${VALGRIND} ./t-smar-3 ${d0} >/dev/null 2>&1 &
  else
    ${VALGRIND} ./t-smar-1 -M '<a'@${d0}'>' >/dev/null 2>&1 &
  fi

  i=`expr ${i} + 1`
  # up to 10 concurrent requests
  if test ${i} -ge 10
  then
    wait
    i=0
    test -s stop && break
  fi
done < ${IN}


# stop SMAR
for i in `cat ${PIDS}`
do
  kill ${i}
done
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi

exit ${ERRS}
