#!/bin/sh
# $Id: t-smar-3.sh,v 1.21 2005/10/05 23:17:47 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Script to test access map restrictions (only IP addresses)
# and reverse lookups (PTR).
# Uses smar, t-smar-3, access map, t-mm, startsmar.sh
# ------------------------------------------------------------
#
test -s stop && exit 1
#

if test X"${SM_NO_DNS_TEST}" != "X"
then
  echo "SKIPPED: $0"
  exit 0
fi

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

OUT=smar-3.out
IP=smar-3.ip
OK=smar-3.ok
VERBOSE=false
TPRG=./t-smar-3

if test X"`uname`" != "XOSF1"
then
while getopts V FLAG
do
  case "${FLAG}" in
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# some IP addresses which don't have reverse mapping....
NORVRSIP=${SM_NORVRSIP:-10.255.255.255}
NORVRSIPOK=${SM_NORVRSIP:-10.255.255.0}

rm -f ${ACCMAP} ${SOCK} ${PIDS}

# create access map for tests
${MM} -t'	' -F ${ACCMAP} <<EOF
cltaddr:1.2.3.4	error:550 5.7.1 access denied
cltaddr:10.12.13.14	quick:error:551 5.7.2 access quickly denied
cltaddr:${NORVRSIPOK}	OK
cltaddr:134.245.248.42	error:450 4.7.1 hey
cltresolve:NO	error:450 4.7.1 get a name
EOF

# start SMAR
${SHELL} ${SD}/startsmar.sh || exit 1
rm -f ${OUT} ${IP} ${OK}

TEST=1
# ----------------------------------------
# test: PTR lookup of services.sendmail.org
# Note: increase timeout?
${VALGRIND} ${TPRG} '209.246.26.22' > ${OUT} 2>&1

grep '^react=' ${OUT} > ${IP}
cat > ${OK} <<EOF
react=rvrs_st, ret=0, stat=1
react=rvrs_name, ret=0, name=services.sendmail.org.
EOF

if diff -i ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

TEST=2
# ----------------------------------------
# test: mine.informatik.uni-kiel.de.
${VALGRIND} ${TPRG} '134.245.248.42' > ${OUT} 2>&1

grep '^react=' ${OUT} > ${IP}
cat > ${OK} <<EOF
react=statt, ret=0, statt='450 4.7.1 hey
react=rvrs_st, ret=0, stat=1
react=rvrs_name, ret=0, name=mine.informatik.uni-kiel.de.
EOF

if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

TEST=3
# ----------------------------------------
# test: cltaddr
# THIS DOESN'T WORK reliably! someone could have an entry in his local DNS.
${VALGRIND} ${TPRG} '1.2.3.4' > ${OUT} 2>&1

grep '^react=' ${OUT} > ${IP}
cat > ${OK} <<EOF
react=statt, ret=0, statt='550 5.7.1 access denied
react=rvrs_st, ret=0, stat=2
EOF

if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

TEST=4
# ----------------------------------------
# test: quick
# THIS DOESN'T WORK reliably! someone could have an entry in his local DNS.
${VALGRIND} ${TPRG} '10.12.13.14' > ${OUT} 2>&1

grep '^react=' ${OUT} > ${IP}
cat > ${OK} <<EOF
react=statt, ret=0, statt='551 5.7.2 access quickly denied
react=rvrs_st, ret=0, stat=2
EOF

if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi


TEST=5
# ----------------------------------------
# THIS DOESN'T WORK reliably! someone could have an entry in his local DNS.
${VALGRIND} ${TPRG} ${NORVRSIP} > ${OUT} 2>&1

grep '^react=' ${OUT} > ${IP}
cat > ${OK} <<EOF
react=statt, ret=0, statt='450 4.7.1 get a name
react=rvrs_st, ret=0, stat=2
EOF

if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

TEST=6
# ----------------------------------------
# THIS DOESN'T WORK reliably! someone could have an entry in his local DNS.
${VALGRIND} ${TPRG} ${NORVRSIPOK} > ${OUT} 2>&1

grep '^react=' ${OUT} > ${IP}
cat > ${OK} <<EOF
react=rvrs_st, ret=0, stat=2
EOF

if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

# How to test for the various errors?
# temporary lookup failures
# permanent lookup failures
# forward != revervse lookup


# stop SMAR
for i in `cat ${PIDS}`
do
  kill ${i}
done
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi
sleep 3

exit ${ERRS}
