#!/bin/sh
# $Id: t-mxinvalid.sh,v 1.10 2005/10/05 23:17:47 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# simple DNS MX+A lookup tests by contacting SMAR
# uses t-smar-1 and startsmar.sh
# ------------------------------------------------------------
#
test -s stop && exit 1
#

if test X"${SM_NO_DNS_TEST}" != "X"
then
  echo "SKIPPED: $0"
  exit 0
fi

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

OUT=mxinvalid-0.out
IP=mxinvalid-0.ip
OK=mxinvalid-0.ok
TPRG=./t-smar-1
VERBOSE=false

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

rm -f ${SOCK} ${PIDS}

# Note: the test programs which rely on failures from SMAR work only if
# SMAR has been compiled with -DSMAR_TEST!
LIBDNS_TEST=false
../smar/smar -D | grep "LIBDNS_TEST" >/dev/null && LIBDNS_TEST=true

ADDR='<a@mxinvalid.sm9.org>'
if test ${LIBDNS_TEST} = false
then
  # echo "$0: SKIPPED; needs -DLIBDNS_TEST"
  # HACK
  D=bigramp.com
  dig ${D}. MX > ${OUT} 2>&1 || exit 0
  grep "^${D}.*MX.*@" ${OUT} >/dev/null || exit 0
  ADDR='<a@bigramp.com>'
  # exit 0
fi

# prepare mailertable
${CAT} > ${MT} <<EOF
EOF

# start SMAR
${SHELL} ${SD}/startsmar.sh || exit 1

rm -f ${OUT} ${IP} ${OK}

TEST=1
# ----------------------------------------
# test MX lookup for invalid domain
${VALGRIND} ${TPRG} -M -VVVV "${ADDR}" > ${OUT} 2>&1
egrep '^(IP|WARN)' ${OUT} | sort > ${IP}
cat > ${OK} <<EOF
WARN: lookup=unknown=0x88030147
EOF

if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

#rm -f ${OUT} ${IP} ${OK}

# stop SMAR
for i in `cat ${PIDS}`
do
  kill ${i}
done
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi

exit ${ERRS}
