#!/bin/sh
# $Id: t-dnsbl-0.sh,v 1.12 2005/10/05 23:17:47 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Script to test DNS BL and access map restrictions (only IP addresses)
# Uses smar, t-smar-3, access map, t-mm, startsmar.sh
# ------------------------------------------------------------
#
test -s stop && exit 1
#

if test X"${SM_NO_DNS_TEST}" != "X"
then
  echo "SKIPPED: $0"
  exit 0
fi

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

OUT=dnsbl-0.out
IP=dnsbl-0.ip
OK=dnsbl-0.ok
VERBOSE=false
CONF=smar.conf
TPRG=./t-smar-3

if test X"`uname`" != "XOSF1"
then
while getopts V FLAG
do
  case "${FLAG}" in
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

rm -f ${ACCMAP} ${SOCK} ${PIDS}

# create access map for tests
${MM} -t'	' -F ${ACCMAP} <<EOF
sm9dnsbl:127.0.0.1	error:550 5.7.1 found 127.0.0.1 in sm9dnsbl
sm9dnsbl:127.0.0.2	error:550 5.7.2 found 127.0.0.2 in sm9dnsbl
cltaddr:127.0.0.3	ok
sm9dnsbl:127.0.0.3	error:550 5.7.3 found 127.0.0.3 in sm9dnsbl
EOF

cat > ${CONF} <<EOF
smar {
Log_Level = 12;
DNS_timeout = 5;
# should tag include ":"?
dnsbl { domain = dnsbl.sm9.org.; tag = "sm9dnsbl"; }
#dnsbl { domain = bl.sm9.org.; tag = "sm9bl"; }
#dnsbl { domain = all.sm9.org.; tag = "sm9all"; }
}
EOF

# start SMAR
${SHELL} ${SD}/startsmar.sh -f ${CONF} || exit 1
rm -f ${OUT} ${IP} ${OK}

TEST=1
# ----------------------------------------
# test: dnsbl: rejection
${VALGRIND} ${TPRG} -d '127.0.0.2' > ${OUT} 2>&1
grep '^react=' ${OUT} > ${IP}
cat > ${OK} <<EOF
react=statt, ret=0, statt='550 5.7.2 found 127.0.0.2 in sm9dnsbl
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  ${VERBOSE} && echo ${TEST} failed
fi

TEST=2
# ----------------------------------------
# test: dnsbl: no access map entry
${VALGRIND} ${TPRG} -d '127.0.0.4' > ${OUT} 2>&1
grep '^react=' ${OUT} > ${IP}
cat > ${OK} <<EOF
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  ${VERBOSE} && echo ${TEST} failed
fi

TEST=3
# ----------------------------------------
# test: dnsbl: no DNS BL entry
${VALGRIND} ${TPRG} -d '127.0.0.99' > ${OUT} 2>&1
grep '^react=' ${OUT} > ${IP}
cat > ${OK} <<EOF
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  ${VERBOSE} && echo ${TEST} failed
fi

TEST=4
# ----------------------------------------
# test: dnsbl: override by access map
${VALGRIND} ${TPRG} -d '127.0.0.3' > ${OUT} 2>&1
grep '^react=' ${OUT} > ${IP}
cat > ${OK} <<EOF
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  ${VERBOSE} && echo ${TEST} failed
fi


# stop SMAR
for i in `cat ${PIDS}`
do
  kill ${i}
done
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi
sleep 3

exit ${ERRS}
