#!/bin/sh
# $Id: t-access-3.sh,v 1.9 2005/10/05 23:17:47 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Script to test access map restrictions for RFC2821 addresses.
# especially protectedrcpt:
# Uses smar, t-access-0, access map, t-mm, startsmar.sh
# ------------------------------------------------------------
# Note: smar and t-access-0 are running asynchronous, hence
# there must be no expected order in the output file.
#
# don't run if stop is "set".
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

OUT=access-3.out
IP=access-3.ip
OK=access-3.ok
TPRG=./t-access-0
SKIP=""
VERBOSE=false

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

rm -f ${ALIMAP} ${ACCMAP} ${SOCK} ${PIDS}

# create access map for tests
cat >${ACC} <<EOF
protectedrcpt:list1@b.c	list:<list1@b.c>
protectedrcpt:list2	list:<list2@b.c>
protectedrcpt:list3	from:<moderator3@local.dom>
protectedrcpt:list4	bogus:entry
to:rcpt5	error:550 no
to:list2@local.dom	relay
EOF
${VALGRIND} ${MM} -t'	' -F ${ACCMAP} < ${ACC}
if test $? -ne 0
then
  echo t-mm failed
  exit 1
fi

# create aliases map
cat >${ALI} <<EOF
user:	local:
list1:	<user1-1@l1-1.dom> <user2-1@l1-1.dom> <list2@local.dom>
list2:	<user1-2@l2-1.dom> <user2-2@l2-2.dom>
list3:	<user1-3@l3-1.dom> <user2-3@l3-2.dom>
EOF
${VALGRIND} ${MM} < ${ALI}
if test $? -ne 0
then
  echo t-mm failed
  exit 1
fi

# create mailertable (save old version?)
${CAT} > ${MT} <<EOF
local.dom	lmtp:
b.c	lmtp:
EOF

killit()
{
if test -s ${PIDS}
then
  # stop SMAR
  for i in `cat ${PIDS}`
  do
    kill ${i}
  done
fi
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi
exit 1
}
trap killit 2


# start SMAR
${SHELL} ${SD}/startsmar.sh || exit 1
rm -f ${OUT} ${IP} ${OK}

TEST=0
# ----------------------------------------
# sender not allowed to send to list
if echo "${SKIP} X" | grep -v '\<'${TEST}'\>' > /dev/null
then
${VALGRIND} ${TPRG} -p '<user1-1+x@l1-1.dom>' '<list1@b.c>' > ${OUT} 2>&1 || ERRS=`expr ${ERRS} + 1 `
grep '^rcpt-status=' ${OUT} > ${IP}
cat > ${OK} <<EOF
rcpt-status=550
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi
fi

TEST=1
# ----------------------------------------
# sender allowed to send to list
if echo "${SKIP} X" | grep -v '\<'${TEST}'\>' > /dev/null
then
${VALGRIND} ${TPRG} -p '<user1-1@l1-1.dom>' '<list1@b.c>' > ${OUT} 2>&1 || ERRS=`expr ${ERRS} + 1 `
grep '^rcpt-status=' ${OUT} > ${IP}
cat > ${OK} <<EOF
rcpt-status=0
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi
fi

TEST=3
# ----------------------------------------
# sender allowed to send to list (due to extended matching)
if echo "${SKIP} X" | grep -v '\<'${TEST}'\>' > /dev/null
then
${VALGRIND} ${TPRG} -p '<user1-1+ext@l1-1.dom>' -mD '<list1@b.c>' > ${OUT} 2>&1 || ERRS=`expr ${ERRS} + 1 `
grep '^rcpt-status=' ${OUT} > ${IP}
cat > ${OK} <<EOF
rcpt-status=0
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi
fi

TEST=4
# ----------------------------------------
# recipient rejected
if echo "${SKIP} X" | grep -v '\<'${TEST}'\>' > /dev/null
then
${VALGRIND} ${TPRG} -p '<user1-1@l1-1.dom>' -r '<rcpt5@b.c>' > ${OUT} 2>&1 || ERRS=`expr ${ERRS} + 1 `
egrep '^(rcpt-status|react)=' ${OUT} > ${IP}
cat > ${OK} <<EOF
rcpt-status=550
react=statt, ret=0, statt='550 no
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi
fi

TEST=5
# ----------------------------------------
# sender not allowed to send to list
if echo "${SKIP} X" | grep -v '\<'${TEST}'\>' > /dev/null
then
${VALGRIND} ${TPRG} -p '<not@l2-1.dom>' -mD '<list2@local.dom>' > ${OUT} 2>&1 || ERRS=`expr ${ERRS} + 1 `
grep '^rcpt-status=' ${OUT} > ${IP}
cat > ${OK} <<EOF
rcpt-status=550
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi
fi

TEST=6
# ----------------------------------------
# sender allowed to send to list
if echo "${SKIP} X" | grep -v '\<'${TEST}'\>' > /dev/null
then
${VALGRIND} ${TPRG} -p '<user1-2@l2-1.dom>' -mD '<list2@local.dom>' > ${OUT} 2>&1 || ERRS=`expr ${ERRS} + 1 `
grep '^rcpt-status=' ${OUT} > ${IP}
cat > ${OK} <<EOF
rcpt-status=0
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi
fi


# ----------------
# stop SMAR
for i in `cat ${PIDS}`
do
  kill ${i}
done
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi
sleep 3

exit ${ERRS}
