/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: log.h,v 1.9 2005/06/16 00:39:09 ca Exp $
 */

#ifndef SMAR_LOG_H
#define SMAR_LOG_H 1

#include "sm/generic.h"
#include "sm/log.h"

#if SMAR_LOG_DEFINES
sm_logcategory_T smar_lcats[] =
{
	{ "init",	0 },
	{ "config",	0 },
	{ "resolver",	0 },
	{ "comm",	0 },
	{ NULL,		0 }
};

sm_logmodule_T smar_lmods[] =
{
	{ "smar/to_qmgr",	0 },
	{ "smar/from_qmgr",	0 },
	{ "smar/config",	0 },
	{ "smar/resolver",	0 },
	{ "smar/rcpt_cb",	0 },
	{ "smar/rvrs_cb",	0 },
	{ "smar/comm",		0 },
	{ NULL,			0 }
};

#else /* SMAR_LOG_DEFINES */

/* should these be global or per smar context? */
extern sm_logcategory_T smar_lcats[];
extern sm_logmodule_T smar_lmods[];

#endif /* SMAR_LOG_DEFINES */

#define AR_LCAT_INIT		(&smar_lcats[0])
#define AR_LCAT_CONFIG		(&smar_lcats[1])
#define AR_LCAT_RESOLVER	(&smar_lcats[2])
#define AR_LCAT_COMM		(&smar_lcats[3])

/* Backwards compatibility. */
#define AR_LCAT_GENERAL	SM_LOGCATEGORY_GENERAL

#define AR_LMOD_TO_QMGR		(&smar_lmods[0])
#define AR_LMOD_FROM_QMGR	(&smar_lmods[1])
#define AR_LMOD_CONFIG		(&smar_lmods[2])
#define AR_LMOD_RESOLVER	(&smar_lmods[3])
#define AR_LMOD_RCPT_CB		(&smar_lmods[4])
#define AR_LMOD_RVRS_CB		(&smar_lmods[5])
#define AR_LMOD_COMM		(&smar_lmods[6])

void	 smar_log_init(sm_log_ctx_P _lctx);
void	 smar_log_setcontext(sm_log_ctx_P _lctx);

#endif /* SMAR_LOG_H */
