#!/bin/sh
# $Id: t-conf-0.sh,v 1.12 2005/09/01 21:13:17 ca Exp $
# Copyright (c) 2004 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# read map configuration files
# uses: t-confr-0
# ------------------------------------------------------------

test -s stop && exit 1

# source directory of this (and other) shell script
SD=`dirname $0`
ERRS=0
CNF=map0.conf
OUT=map0.out
OK=map0.ok
PRG=./t-confr-0

# ----------------------------------------
cat > ${CNF} <<EOF
map hash1 { type = hash; file= access.db; }
map hash2 { type = hash; file= user.db; }
map password { type = passwd; }
map seq1 { type = sequence; maps = { hash1, password}; }
EOF

cat > ${OK} <<EOF
map = 0
kind= 1
type= hash
name= hash1
file= access.db

map = 1
kind= 1
type= hash
name= hash2
file= user.db

map = 2
kind= 4
type= passwd
name= password

map = 3
kind= 3
type= sequence
name= seq1
maps[0]= hash1
maps[1]= password

EOF

if ${PRG} ${CNF} >${OUT}
then
  if diff ${OK} ${OUT}
  then
    :
  else
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit ${ERRS}
  fi
else
  ERRS=`expr ${ERRS} + 1 `
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

# ----------------------------------------
cat > ${CNF} <<EOF
map hash1 { type = hash; file= access.db; }
map password { type = passwd; }
map seq1 { type = sequence; maps = { hash1, password, hash2}; }
map hash2 { type = hash; file= user.db; }
EOF

cat > ${OK} <<EOF
map = 0
kind= 1
type= hash
name= hash1
file= access.db

map = 1
kind= 4
type= passwd
name= password

map = 2
kind= 3
type= sequence
name= seq1
maps[0]= hash1
maps[1]= password
maps[2]= hash2

map = 3
kind= 1
type= hash
name= hash2
file= user.db

EOF

if ${PRG} ${CNF} >${OUT}
then
  if diff ${OK} ${OUT}
  then
    :
  else
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit ${ERRS}
  fi
else
  ERRS=`expr ${ERRS} + 1 `
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

# ----------------------------------------
cat > ${CNF} <<EOF
map hash1 { type = hash; file= access.db; }
map password { type = passwd; }
map sock1 { type = socket; mapname=sock1map; path=/var/run/sock/map1.sock; }
map seq1 { type = sequence; maps = { hash1, password, sock1}; }
EOF

cat > ${OK} <<EOF
map = 0
kind= 1
type= hash
name= hash1
file= access.db

map = 1
kind= 4
type= passwd
name= password

map = 2
kind= 2
type= socket
name= sock1
mapname= sock1map
path= /var/run/sock/map1.sock

map = 3
kind= 3
type= sequence
name= seq1
maps[0]= hash1
maps[1]= password
maps[2]= sock1

EOF

if ${PRG} ${CNF} >${OUT}
then
  if diff ${OK} ${OUT}
  then
    :
  else
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit ${ERRS}
  fi
else
  ERRS=`expr ${ERRS} + 1 `
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi


# ----------------------------------------
cat > ${CNF} <<EOF
map hash1  { type = hash; file= access.db; }
map password  { type = passwd; }
map sock1  { type = socket; mapname=sock1map; address=127.0.0.1; port=1234; }
map seq1  { type = sequence; maps = { hash1, password, sock1}; }
EOF

cat > ${OK} <<EOF
map = 0
kind= 1
type= hash
name= hash1
file= access.db

map = 1
kind= 4
type= passwd
name= password

map = 2
kind= 2
type= socket
name= sock1
mapname= sock1map
ipv4= 7f000001
port= 1234

map = 3
kind= 3
type= sequence
name= seq1
maps[0]= hash1
maps[1]= password
maps[2]= sock1

EOF

if ${PRG} ${CNF} >${OUT}
then
  if diff ${OK} ${OUT}
  then
    :
  else
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit ${ERRS}
  fi
else
  ERRS=`expr ${ERRS} + 1 `
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi


# ----------------
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
