/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: maprewrite.c,v 1.9 2005/07/29 22:06:46 ca Exp $")

#include "sm/assert.h"
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/heap.h"
#include "map.h"
#include "sm/map.h"
#include "sm/maps.h"
#include "sm/mapc.h"

/*
NOT YET IMPLEMENTED
*/

/*
**  MAP_REWRITE - rewrite value
**	currently returns data of lookup verbatim
**	possible rewrite actions:
**	%n -> argv[n]	(sm8 map_rewrite)
**	${name}	-> lookup(name in some map)
**
**	Parameters:
**		map -- map
**		flags -- flags
**		old -- input string
**		new - output string
**	other parameters? e.g., recursion, name-map, argv[]?
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_map_rewrite(sm_map_P map, uint32_t flags, sm_str_P old, sm_str_P new)
{
	sm_ret_T ret;
	sm_mapc_P mapc;

	if (map == NULL)
		return sm_error_perm(SM_EM_MAP, EINVAL);	/* XXX */
	SM_IS_MAP(map);
	mapc = map->sm_map_class;
	SM_IS_MAPC(mapc);

	if (!SMMAP_IS_FL(map, SMMAP_FL_OPEN))
	{
		/* map closed but can be reopened? */
		if (!SMMAP_IS_CAPS(map, SMMAP_CAPS_DYNAMIC) &&
		    mapc->sm_mapc_reopenf != NULL)
		{
			ret = mapc->sm_mapc_reopenf(map, 0);
		}
		else
			ret = sm_error_perm(SM_EM_MAP, SM_E_CLOSEDMAP);
		if (sm_is_err(ret))
			return ret;
	}

	if (mapc->sm_mapc_lookupf == NULL)
		return sm_error_perm(SM_EM_MAP, ENOENT);	/* XXX */

	ret = mapc->sm_mapc_lookupf(map, flags, old, new);
	if (sm_is_err(ret))
		return ret;

	/*
	**  Who "owns" the data?
	**  need some flags that tell us what to do? see BDB.
	*/

	return ret;
}
