/*
 * Copyright (c) 2003, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: sm_inet_ipv42a.c,v 1.3 2005/02/23 21:51:14 ca Exp $")

#include "sm/assert.h"
#include "sm/error.h"
#include "sm/ctype.h"
#include "sm/net.h"
#include "sm/str.h"

/*
**  SM_INET_IPV4STR -- convert an IPv4 address to an ASCII string
**
**	Parameters:
**		ipv4 -- IPv4 address
**		dst -- append ASCII representation of address (output)
**
**	Returns:
**		error: ENOSPC
*/

sm_ret_T
sm_inet_ipv4str(ipv4_T ipv4, sm_str_P dst)
{
	uchar *src;
	ssize_t l;

	src = (uchar *) &ipv4;
	l = sm_str_printf(dst, "%u.%u.%u.%u", src[0], src[1], src[2], src[3]);
	if (l <= 0)
		return sm_error_perm(SM_EM_IP, ENOSPC);
	return SM_SUCCESS;
}

/*
**  SM_INET_INADDR2STR -- convert an IPv4 address struct to an ASCII string
**
**	Parameters:
**		inaddr -- IPv4 address struct
**		dst -- append ASCII representation of address (output)
**
**	Returns:
**		error: ENOSPC
*/

sm_ret_T
sm_inet_inaddr2str(struct in_addr inaddr, sm_str_P dst)
{
	uchar *src;
	ssize_t l;

	src = (uchar *) &inaddr;
	l = sm_str_printf(dst, "%u.%u.%u.%u", src[0], src[1], src[2], src[3]);
	if (l <= 0)
		return sm_error_perm(SM_EM_IP, ENOSPC);
	return SM_SUCCESS;
}
