/*
 * Copyright (c) 2002, 2003 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: ring.c,v 1.6 2003/11/05 19:50:24 ca Exp $")

#include "sm/ring.h"

#if !SM_RING_INLINE

/*
**  RING_INIT - initialize ring
**
**	Parameters:
**		ring -- ring to initialize.
**
**	Returns:
**		none.
*/

void
sm_ring_init(sm_ring_P ring)
{
	ring->sm_rg_pred = ring->sm_rg_succ = ring;
}

/*
**  RING_APPEND - insert entry after ring
**
**	Parameters:
**		ring -- ring.
**		entry -- element to append.
**
**	Returns:
**		none.
*/

void
sm_ring_append(sm_ring_P ring, sm_ring_P entry)
{
	entry->sm_rg_succ = ring->sm_rg_succ;
	entry->sm_rg_pred = ring;
	ring->sm_rg_succ->sm_rg_pred = entry;
	ring->sm_rg_succ = entry;
}

/*
**  RING_PREPEND - insert new entry before ring
**
**	Parameters:
**		ring -- ring.
**		entry -- element to prepend.
**
**	Returns:
**		none.
*/

void
sm_ring_prepend(sm_ring_P ring, sm_ring_P entry)
{
	entry->sm_rg_pred = ring->sm_rg_pred;
	entry->sm_rg_succ = ring;
	ring->sm_rg_pred->sm_rg_succ = entry;
	ring->sm_rg_pred = entry;
}
#endif /* !SM_RING_INLINE */

/*
**  RING_DELENTRY - remove entry from ring
**
**	Parameters:
**		entry -- ring.
**
**	Returns:
**		none.
*/

void
sm_ring_delentry(sm_ring_P entry)
{
	sm_ring_P succ;
	sm_ring_P pred;

	succ = entry->sm_rg_succ;
	pred = entry->sm_rg_pred;
	if (succ == NULL && pred == NULL)
		return;
	pred->sm_rg_succ = succ;
	succ->sm_rg_pred = pred;
	entry->sm_rg_succ = entry->sm_rg_pred = NULL;
}
