/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: rcbenew.c,v 1.14 2005/06/02 19:00:36 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/rcb.h"
#include "sm/rcbl.h"

/*
**  SM_RCBE_NEW -- Create a new RCB entry (list element).
**
**	Parameters:
**		rpool -- The rpool in which to allocate.
**			fixme: Not used by any caller...
**		len -- Best guess as to how long the buf will be.
**		maxlen -- Maximum length of buf data, if 0 a system
**			default will be used.
**
**	Returns:
**		New RCB entry.
**		NULL on error (ENOMEM)
**
**	Side Effects: none on error.
**
**	Last code review:
**	Last code change: 2005-03-22 17:34:45
*/

sm_rcbe_P
sm_rcbe_new(sm_rpool_P rpool, uint len, uint maxlen)
{
	sm_rcbe_P rcbe;

	SM_REQUIRE(maxlen == 0 || len <= maxlen);
	if (len < SM_MIN_RCB_SIZE)
		len = SM_MIN_RCB_SIZE;
	if (maxlen == 0)
		maxlen = SM_RCB_MAX_LEN;
	if (maxlen < SM_MIN_RCB_SIZE)
		maxlen = SM_MIN_RCB_SIZE;
	SM_REQUIRE(len <= maxlen);

	rcbe = sm_rpool_zalloc(rpool, sizeof(*rcbe));
	if (rcbe == NULL)
		return NULL;
	rcbe->rcbe_rcb.sm_rcb_base = sm_rpool_malloc(rpool, len);
	if (rcbe->rcbe_rcb.sm_rcb_base == NULL)
	{
		sm_rpool_free_size(rpool, rcbe, sizeof(*rcbe));
		return NULL;
	}
	rcbe->rcbe_rcb.sm_rcb_rw = 0;
#if SM_RCB_CHECK
	sm_memzero(rcbe->rcbe_rcb.sm_rcb_base, len);
	rcbe->rcbe_rcb.sm_rcb_state = SM_RCB_NONE;
#endif
	rcbe->rcbe_rcb.sm_rcb_max = maxlen;
	rcbe->rcbe_rcb.sm_rcb_rpool = rpool;
	rcbe->rcbe_rcb.sm_rcb_size = len;
	rcbe->rcbe_rcb.sm_magic = SM_RCB_MAGIC;
	return rcbe;
}
